/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import jfig.utils.SetupManager;

public final class EventList {
    private EventNode root;
    private EventNode cursor;
    private String name;
    public static boolean debug = false;
    public long n_created = 0L;
    public long n_recycled = 0L;
    public long n_available = 0L;
    private int STACK_SIZE = 500;
    private EventNode[] recycleStack;
    private int recyclePointer;
    private EventNode recycleNode;
    boolean enable_recycling = true;
    private double last_insert_time = -1.0;
    private int n_equal_insert_times = 0;
    private EventNode last_insert_event = null;

    public EventList() {
        this.root.next = this.root = new EventNode();
        this.root.prev = this.root;
        this.root.simTime = -42.0;
        this.cursor = this.root;
        this.name = "HadesEventList";
        this.enable_recycling = SetupManager.getBoolean("Hades.Simulator.EventList.EnableRecycling", true);
        this.STACK_SIZE = SetupManager.getInteger("Hades.Simulator.EventList.RecycleCapacity", 500);
        this.recycleStack = new EventNode[this.STACK_SIZE];
        this.recyclePointer = 0;
        if (!this.enable_recycling) {
            EventList.message("-W- EventList: node recycling is disabled!");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void first() {
        this.cursor = this.root.next;
    }

    public final void last() {
        this.cursor = this.root.prev;
    }

    public final void next() {
        if (this.cursor.next != this.root) {
            this.cursor = this.cursor.next;
        }
    }

    public final void prev() {
        if (this.cursor.prev != this.root) {
            this.cursor = this.cursor.prev;
        }
    }

    public final double getSimTime() {
        return this.cursor.simTime;
    }

    public final void setSimTime(double t) {
        this.cursor.setSimTime(t);
    }

    public final double getSecondEventTime() {
        EventNode next = this.root.next;
        if (next == this.root) {
            return Double.MAX_VALUE;
        }
        next = next.next;
        if (next == this.root) {
            return Double.MAX_VALUE;
        }
        return next.getSimTime();
    }

    public final SimEvent getData() {
        return this.cursor.data;
    }

    public EventNode getRecycledNode(SimEvent event) {
        if (this.enable_recycling && this.n_available > 0L) {
            try {
                --this.n_available;
                ++this.n_recycled;
                ++this.n_created;
                this.recycleNode = this.recycleStack[--this.recyclePointer];
                this.recycleNode.data = event;
                this.recycleNode.simTime = event.getTime();
                return this.recycleNode;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.printStatus();
                ++this.n_created;
                return new EventNode(event);
            }
        }
        ++this.n_created;
        return new EventNode(event);
    }

    public void recycleNode(EventNode victim) {
        if (this.enable_recycling && this.n_available < (long)this.STACK_SIZE) {
            this.recycleStack[this.recyclePointer++] = victim;
            ++this.n_available;
        }
    }

    public String printStatus() {
        return "EventNodes: created= " + this.n_created + " recycled= " + this.n_recycled + " available= " + this.n_available + " / capacity= " + this.STACK_SIZE + " equal times= " + this.n_equal_insert_times;
    }

    /*
     * Unable to fully structure code
     */
    public final void insert(SimEvent event) {
        novice = this.getRecycledNode(event);
        time = novice.simTime;
        if (this.root.next == this.root) {
            this.root.next = novice;
            this.root.prev = novice;
            novice.prev = this.root;
            novice.next = this.root;
            if (EventList.debug) {
                EventList.message("-#- EventList.insert<first> " + event);
            }
            this.last_insert_event = novice;
            this.last_insert_time = novice.simTime;
            return;
        }
        if (time == this.last_insert_time && this.last_insert_event != null) {
            ++this.n_equal_insert_times;
            novice.prev = this.last_insert_event;
            novice.next = this.last_insert_event.next;
            this.last_insert_event.next.prev = novice;
            this.last_insert_event.next = novice;
            this.last_insert_event = novice;
            this.last_insert_time = novice.simTime;
            return;
        }
        tmpcursor = this.root.prev;
        if (time >= tmpcursor.simTime) {
            novice.prev = this.root.prev;
            novice.next = this.root;
            this.root.prev.next = novice;
            this.root.prev = novice;
            if (EventList.debug) {
                EventList.message("-#- EventList.insert<at end> " + event);
            }
            this.last_insert_event = novice;
            this.last_insert_time = novice.simTime;
            return;
        }
        if (tmpcursor.prev != this.root) ** GOTO lbl46
        this.root.next = novice;
        tmpcursor.prev = novice;
        novice.prev = this.root;
        novice.next = tmpcursor;
        if (EventList.debug) {
            EventList.message("-#- EventList.insert<at top> " + event);
        }
        this.last_insert_event = novice;
        this.last_insert_time = novice.simTime;
        return;
lbl-1000:
        // 1 sources

        {
            if (EventList.debug) {
                EventList.message("-#- EL.insert<search> " + event + " " + tmpcursor);
            }
            tmpcursor = tmpcursor.prev;
lbl46:
            // 2 sources

            ** while (time < tmpcursor.simTime)
        }
lbl47:
        // 1 sources

        novice.next = tmpcursor.next;
        novice.prev = tmpcursor;
        tmpcursor.next.prev = novice;
        tmpcursor.next = novice;
        this.last_insert_event = novice;
        this.last_insert_time = novice.simTime;
        if (EventList.debug) {
            EventList.message("-#- EventList.insert<middle> " + event);
        }
    }

    public final void deleteFirst() {
        this.cursor = this.root.next;
        if (this.cursor != this.root) {
            if (this.cursor == this.last_insert_event) {
                this.last_insert_event = null;
            }
            this.root.next = this.cursor.next;
            this.cursor.next.prev = this.root;
            this.recycleNode(this.cursor);
            this.cursor = null;
        } else {
            this.last_insert_event = null;
        }
        this.cursor = this.root.next;
    }

    public final boolean delete(EventNode victim) {
        EventNode tmp = this.root.next;
        while (tmp != this.root) {
            if (tmp == victim) {
                tmp.prev.next = tmp.next;
                tmp.next.prev = tmp.prev;
                return true;
            }
            tmp = tmp.next;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + (this.isEmpty() ? "<empty>" : "") + '\n');
        EventNode tmp = this.root.next;
        while (tmp != this.root) {
            sb.append("  ");
            sb.append(tmp.getData().toShortString());
            sb.append("\n");
            tmp = tmp.next;
        }
        return sb.toString();
    }

    public final boolean isEmpty() {
        return this.root.next == this.root;
    }

    public void deleteAllEventsFromSource(SimObject source) {
        if (debug) {
            EventList.message("-I- EventList.deleteAllEventsFromSource: " + source);
        }
        this.last_insert_event = null;
        EventNode tmp = this.root;
        SimEvent event = null;
        int count = 0;
        tmp = this.root.next;
        while (tmp != this.root) {
            if (debug) {
                System.out.println("dAEFS: checking node " + tmp);
            }
            if ((event = tmp.getData()).getSource() == source) {
                if (debug) {
                    System.out.println("dAEFS: deleting node " + tmp);
                }
                tmp.prev.next = tmp.next;
                tmp.next.prev = tmp.prev;
                this.recycleNode(tmp);
                ++count;
            }
            tmp = tmp.next;
        }
        if (debug) {
            System.out.println("dAEFS: deleted " + count + " nodes!");
        }
    }

    public static void message(String msg) {
        System.out.println(msg);
    }

    public static void usage() {
        System.err.println("Usage: java hades.simulator.EventList <n-nodes>");
        System.err.println("Example: java hades.simulator.EventList 10");
    }

    public static void main(String[] argv) {
        double simtime0;
        int n = 0;
        if (argv.length < 1) {
            EventList.usage();
            return;
        }
        n = Integer.parseInt(argv[0]);
        System.out.println("EventList self test started...");
        SimObject dummy = new SimObject();
        System.out.println("got the SimObject...");
        EventList EL = new EventList();
        EL.setName("sample event list");
        System.out.println(EL.toString());
        System.out.println("...inserting " + n + " node(s)...");
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < n) {
            double simtime = (int)(10000.0 * Math.random());
            SimEvent sime = new SimEvent(dummy, simtime, "");
            EL.insert(sime);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Time used: " + (t1 - t0) + " msec.");
        System.out.println("...simulating...");
        EL.first();
        double simtime1 = simtime0 = EL.getSimTime();
        System.out.println("from time " + simtime0);
        block1: while (!EL.isEmpty()) {
            System.out.println("to time " + (simtime1 += (double)((int)(3000.0 * Math.random()))));
            while (!EL.isEmpty()) {
                EL.first();
                if (!(EL.getSimTime() < simtime1)) continue block1;
                EL.deleteFirst();
            }
        }
        System.out.println(EL.printStatus());
    }

    final class EventNode {
        SimEvent data;
        EventNode prev;
        EventNode next;
        double simTime;

        public EventNode() {
            this.simTime = -1.0;
            this.data = null;
            this.prev = null;
            this.next = null;
        }

        public EventNode(SimEvent data) {
            this.data = data;
            this.simTime = data.getTime();
            this.prev = null;
            this.next = null;
        }

        public final EventNode getNext() {
            return this.next;
        }

        public final EventNode getPrev() {
            return this.prev;
        }

        public final SimEvent getData() {
            return this.data;
        }

        public final double getSimTime() {
            return this.simTime;
        }

        public final void setNext(EventNode next) {
            this.next = next;
        }

        public final void setPrev(EventNode prev) {
            this.prev = prev;
        }

        public final void setData(SimEvent data) {
            this.data = data;
        }

        public final void setSimTime(double simTime) {
            this.simTime = simTime;
        }

        public String toString() {
            return "EventNode[" + this.simTime + "][" + this.data + "]";
        }
    }
}

