/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ttl74;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;

public class SN7400
extends SimObject
implements Simulatable {
    protected Port port_A1;
    protected Port port_B1;
    protected Port port_Y1;
    protected Port port_A2;
    protected Port port_B2;
    protected Port port_Y2;
    protected Port port_A3;
    protected Port port_B3;
    protected Port port_Y3;
    protected Port port_A4;
    protected Port port_B4;
    protected Port port_Y4;
    protected Port port_GND;
    protected Port port_VCC;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_U;
    static double t_delay = 2.0E-8;

    public SN7400() {
        this.ports = new Port[15];
        this.ports[0] = new Port(this, "dummy", 7, null);
        this.ports[1] = new Port(this, "A1", 0, null);
        this.ports[2] = new Port(this, "B1", 0, null);
        this.ports[3] = new Port(this, "Y1", 1, null);
        this.ports[4] = new Port(this, "A2", 0, null);
        this.ports[5] = new Port(this, "B2", 0, null);
        this.ports[6] = new Port(this, "Y2", 1, null);
        this.ports[7] = new Port(this, "GND", 0, null);
        this.ports[8] = new Port(this, "A3", 0, null);
        this.ports[9] = new Port(this, "B3", 0, null);
        this.ports[10] = new Port(this, "Y3", 1, null);
        this.ports[11] = new Port(this, "A4", 0, null);
        this.ports[12] = new Port(this, "B4", 0, null);
        this.ports[13] = new Port(this, "Y4", 1, null);
        this.ports[14] = new Port(this, "VCC", 0, null);
        this.port_A1 = this.ports[1];
        this.port_B1 = this.ports[2];
        this.port_Y1 = this.ports[3];
        this.port_A2 = this.ports[4];
        this.port_B2 = this.ports[5];
        this.port_Y2 = this.ports[6];
        this.port_A3 = this.ports[8];
        this.port_B3 = this.ports[9];
        this.port_Y3 = this.ports[10];
        this.port_A4 = this.ports[11];
        this.port_B4 = this.ports[12];
        this.port_Y4 = this.ports[13];
        this.port_VCC = this.ports[14];
        this.port_GND = this.ports[7];
        this.value_0 = new StdLogic1164(2);
        this.value_1 = new StdLogic1164(3);
        this.value_U = new StdLogic1164(0);
        this.value_X = new StdLogic1164(1);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            double time = this.simulator.getSimTime();
            this.schedule(this.port_Y1, this.value_X, time);
            this.schedule(this.port_Y2, this.value_X, time);
            this.schedule(this.port_Y3, this.value_X, time);
            this.schedule(this.port_Y4, this.value_X, time);
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- SN7400.evaluate()...");
        }
        if (this.simulator == null) {
            this.message("-E- Internal error: simulator is null in SN7400.evaluate");
            return;
        }
        double time = this.simulator.getSimTime() + t_delay;
        this.schedule(this.port_Y1, this.port_A1, this.port_B1, time);
        this.schedule(this.port_Y2, this.port_A2, this.port_B2, time);
        this.schedule(this.port_Y3, this.port_A3, this.port_B3, time);
        this.schedule(this.port_Y4, this.port_A4, this.port_B4, time);
    }

    public void schedule(Port port_Y, Port port_A, Port port_B, double time) {
        StdLogic1164 value_A = this.getValueOrU(port_A);
        StdLogic1164 value_B = this.getValueOrU(port_B);
        this.schedule(port_Y, StdLogic1164.not(StdLogic1164.and(value_A, value_B)), time);
    }

    public void schedule(Port target, StdLogic1164 value, double time) {
        Signal sout = target.getSignal();
        if (sout == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)sout, time, value, (Object)target));
    }

    public StdLogic1164 getValueOrU(Port p) {
        Signal s = p.getSignal();
        if (s == null) {
            return this.value_U;
        }
        return (StdLogic1164)s.getValue();
    }

    public String toString() {
        return "SN7400_" + this.getFullName();
    }
}

