/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.gui.FontCache;
import jfig.utils.SetupManager;

public class VT52Canvas
extends JPanel {
    public static final int n_lines = 25;
    public static final int n_chars = 80;
    public static final int MODE_NORMAL = 13;
    public static final int MODE_ESCAPE_SINGLE = 14;
    public static final int MODE_ESCAPE_MOVETO = 15;
    public static final int MODE_ESCAPE_MOVETO2 = 16;
    public static boolean debug = false;
    protected int cursor_x;
    protected int cursor_y;
    protected int cursor_old_x;
    protected int cursor_old_y;
    protected boolean cursor_on = true;
    protected int char_width;
    protected int char_height;
    protected int max_ascent;
    protected int width;
    protected int height;
    protected Font textFont;
    protected Color textColor;
    protected int t_repaint = 50;
    protected boolean auto_repaint_enable = true;
    protected StringBuffer[] displayBuffer;
    protected int mode;
    protected int moveto_x;
    protected int moveto_y;

    public VT52Canvas() {
        this.initFontAndColors();
        this.initDisplayBuffer();
        this.addDummyMouseListener();
        this.resetMode();
    }

    protected void initFontAndColors() {
        this.textColor = SetupManager.getColor("Hades.VT52Canvas.Color", Color.orange);
        String fontName = SetupManager.getProperty("Hades.VT52Canvas.FontName", "MonoSpaced");
        int fontSize = SetupManager.getInteger("Hades.VT52Canvas.FontSize", 12);
        int fontStyle = 0;
        this.setTextFont(new Font(fontName, fontStyle, fontSize));
        this.setBackground(Color.black);
    }

    public void setFont(Font f) {
        if (debug) {
            VT52Canvas.message("-W- VT52Canvas.setFont(): ignored");
        }
    }

    public void setTextFont(Font f) {
        this.textFont = f;
        this.updateFontMetrics();
    }

    public void updateFontMetrics() {
        FontMetrics FM = FontCache.getFontCache().getFontMetrics(this.textFont);
        this.char_width = FM.charWidth('M');
        this.char_height = FM.getHeight();
        this.max_ascent = FM.getAscent();
    }

    public void addDummyMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                VT52Canvas.this.requestFocus();
            }
        });
    }

    protected void initDisplayBuffer() {
        this.displayBuffer = new StringBuffer[25];
        int i = 0;
        while (i < this.displayBuffer.length) {
            this.displayBuffer[i] = new StringBuffer();
            int j = 0;
            while (j < 80) {
                this.displayBuffer[i].append(' ');
                ++j;
            }
            ++i;
        }
        this.setCursor(0, 0);
    }

    public void resetMode() {
        this.mode = 13;
    }

    public void setCursorOn() {
        this.cursor_on = true;
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void setCursorOff() {
        this.cursor_on = false;
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void setCursor(int x, int y) {
        this.cursor_x = this.clip(x, 0, 79);
        this.cursor_y = this.clip(y, 0, 24);
    }

    public void moveCursorLinefeed() {
        ++this.cursor_y;
        if (this.cursor_y >= 25) {
            this.cursor_y = 24;
            this.scrollUp();
            if (this.auto_repaint_enable && this.isShowing()) {
                this.repaint(this.t_repaint);
            }
        }
    }

    public void moveCursorCarriageReturn() {
        this.cursor_x = 0;
    }

    public void moveNewline() {
        this.cursor_x = 0;
        ++this.cursor_y;
        if (this.cursor_y >= 25) {
            this.cursor_y = 24;
            this.scrollUp();
            if (this.auto_repaint_enable && this.isShowing()) {
                this.repaint(this.t_repaint);
            }
        }
    }

    public void moveCursorUp() {
        this.cursor_y = this.clip(this.cursor_y - 1, 0, 24);
    }

    public void moveCursorUpWithScrolling() {
        this.cursor_y = this.clip(this.cursor_y - 1, 0, 24);
        VT52Canvas.message("-E- cursorUpWithScrolling not implemented!");
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void moveCursorDown() {
        this.cursor_y = this.clip(this.cursor_y + 1, 0, 24);
    }

    public void moveCursorRight() {
        this.cursor_x = this.clip(this.cursor_x + 1, 0, 79);
    }

    public void moveCursorLeft() {
        this.cursor_x = this.clip(this.cursor_x - 1, 0, 79);
    }

    public void moveCursorHome() {
        this.cursor_x = 0;
        this.cursor_y = 0;
    }

    public void moveCursorTo(int x, int y) {
        this.setCursor(x, y);
    }

    public void clearRestOfLine() {
        int i = this.cursor_x;
        while (i < 79) {
            this.displayBuffer[this.cursor_y].setCharAt(i, ' ');
            ++i;
        }
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void clearRestOfDisplay() {
        this.clearRestOfLine();
        int y = this.cursor_y;
        while (y < 24) {
            int x = 0;
            while (x < 79) {
                this.displayBuffer[this.cursor_y].setCharAt(x, ' ');
                ++x;
            }
            ++y;
        }
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void identifyTerminal() {
        VT52Canvas.message("-E- VT52: ESC Z not implemented!");
    }

    public void addChar(char c) {
        block29: {
            block28: {
                VT52Canvas.msg("-I- addChar: " + c + " at (" + this.cursor_x + "," + this.cursor_y + ")");
                if (this.mode == 13) {
                    switch (c) {
                        case '\b': {
                            this.moveCursorLeft();
                            return;
                        }
                        case '\u008d': {
                            this.moveNewline();
                            return;
                        }
                        case '\n': {
                            this.moveCursorLinefeed();
                            return;
                        }
                        case '\r': {
                            this.moveCursorCarriageReturn();
                            return;
                        }
                        case '\u001b': {
                            if (SetupManager.getBoolean("Hades.VT52Canvas.Debug", false)) {
                                VT52Canvas.message("-I- VT52Canvas: got an ESCAPE...");
                            }
                            this.mode = 14;
                            return;
                        }
                        case '\u007f': {
                            this.moveCursorLeft();
                            return;
                        }
                    }
                    this.addNormalChar(c);
                    return;
                }
                if (this.mode != 14) break block28;
                switch (c) {
                    case 'A': {
                        this.moveCursorUp();
                        this.mode = 13;
                        break block29;
                    }
                    case 'B': {
                        this.moveCursorDown();
                        this.mode = 13;
                        break block29;
                    }
                    case 'C': {
                        this.moveCursorRight();
                        this.mode = 13;
                        break block29;
                    }
                    case 'D': {
                        this.moveCursorLeft();
                        this.mode = 13;
                        break block29;
                    }
                    case 'H': {
                        this.moveCursorHome();
                        this.mode = 13;
                        break block29;
                    }
                    case 'I': {
                        this.moveCursorUpWithScrolling();
                        this.mode = 13;
                        break block29;
                    }
                    case 'J': {
                        this.clearRestOfLine();
                        this.mode = 13;
                        break block29;
                    }
                    case 'K': {
                        this.clearRestOfDisplay();
                        this.mode = 13;
                        break block29;
                    }
                    case 'Y': {
                        this.mode = 15;
                        break block29;
                    }
                    case 'Z': {
                        this.identifyTerminal();
                        this.mode = 13;
                        break block29;
                    }
                    case 'e': {
                        this.setCursorOn();
                        this.mode = 13;
                        break block29;
                    }
                    case 'f': {
                        this.setCursorOff();
                        this.mode = 13;
                        break block29;
                    }
                    default: {
                        VT52Canvas.message("-E- VT52Canvas: unknown ESC command: " + c + " '" + c + "'");
                        this.mode = 13;
                        return;
                    }
                }
            }
            if (this.mode == 15) {
                this.moveto_y = -32 + c;
                this.mode = 16;
            } else if (this.mode == 16) {
                this.moveto_x = -32 + c;
                this.moveCursorTo(this.moveto_x, this.moveto_y);
                this.mode = 13;
            } else {
                VT52Canvas.message("-E- VT52Canvas internal: unknown mode: " + this.mode);
                this.mode = 13;
            }
        }
    }

    public void addNormalChar(char c) {
        this.displayBuffer[this.cursor_y].setCharAt(this.cursor_x, c);
        if (this.isShowing()) {
            this.paintCharAt(this.getGraphics(), this.cursor_x, this.cursor_y);
        }
        ++this.cursor_x;
        if (this.cursor_x >= 80) {
            this.cursor_x = 0;
            ++this.cursor_y;
        }
        if (this.cursor_y >= 25) {
            this.cursor_y = 24;
            this.scrollUp();
            if (this.auto_repaint_enable && this.isShowing()) {
                this.repaint(this.t_repaint);
            }
        }
    }

    public void clear() {
        int y = 0;
        while (y < 25) {
            StringBuffer tmp = this.displayBuffer[y];
            int i = 0;
            while (i < 80) {
                tmp.setCharAt(i, ' ');
                ++i;
            }
            ++y;
        }
        this.setCursor(0, 0);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void scrollUp() {
        VT52Canvas.msg("-I- scrollUp!");
        StringBuffer victim = this.displayBuffer[0];
        int y = 0;
        while (y < 24) {
            this.displayBuffer[y] = this.displayBuffer[y + 1];
            ++y;
        }
        int i = 0;
        while (i < 80) {
            victim.setCharAt(i, ' ');
            ++i;
        }
        this.displayBuffer[24] = victim;
    }

    public int clip(int value, int minValue, int maxValue) {
        if (value > maxValue) {
            return maxValue;
        }
        if (value < minValue) {
            return minValue;
        }
        return value;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(80 * this.char_width, 25 * this.char_height);
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(Graphics g) {
        g.setFont(this.textFont);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(this.textColor);
        int i = 0;
        while (i < 25) {
            g.drawString(this.displayBuffer[i].toString(), 0, i * this.char_height + this.max_ascent);
            ++i;
        }
        g.dispose();
    }

    public void paintCharAt(Graphics g, int x, int y) {
        g.setFont(this.textFont);
        g.setColor(Color.black);
        g.fillRect(x * this.char_width, y * this.char_height, this.char_width, this.char_height);
        g.setColor(this.textColor);
        g.drawString("" + this.displayBuffer[y].charAt(x), x * this.char_width, y * this.char_height + this.max_ascent);
        g.dispose();
    }

    public void showCursor(Graphics g) {
        if (g == null) {
            return;
        }
        this.cursor_old_x = this.cursor_x;
        this.cursor_old_y = this.cursor_y;
        if (!this.cursor_on) {
            return;
        }
        g.setFont(this.textFont);
        g.setColor(this.textColor);
        g.fillRect(this.cursor_x * this.char_width, this.cursor_y * this.char_height, this.char_width, this.char_height);
        g.dispose();
    }

    public void hideCursor(Graphics g) {
        if (g == null) {
            return;
        }
        g.setFont(this.textFont);
        g.setColor(this.getBackground());
        g.fillRect(this.cursor_old_x * this.char_width, this.cursor_old_y * this.char_height, this.char_width, this.char_height);
        g.setColor(this.textColor);
        g.drawString("" + this.displayBuffer[this.cursor_old_y].charAt(this.cursor_old_x), this.cursor_old_x * this.char_width, this.cursor_old_y * this.char_height + this.max_ascent);
        g.dispose();
    }

    public boolean getAutoRepaintEnable() {
        return this.auto_repaint_enable;
    }

    public void setAutoRepaintEnable(boolean b) {
        this.auto_repaint_enable = b;
    }

    public void setAutoRepaintDelay(int millis) {
        this.t_repaint = millis;
    }

    public void startCursorBlinking() {
        new BlinkTimer().start();
    }

    public static void msg(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public void addDummyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                VT52Canvas.this.addChar(e.getKeyChar());
            }

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        VT52Canvas.this.cursor_y = VT52Canvas.this.clip(VT52Canvas.this.cursor_y - 1, 0, 24);
                        break;
                    }
                    case 40: {
                        VT52Canvas.this.cursor_y = VT52Canvas.this.clip(VT52Canvas.this.cursor_y + 1, 0, 24);
                        break;
                    }
                    case 37: {
                        VT52Canvas.this.cursor_x = VT52Canvas.this.clip(VT52Canvas.this.cursor_x - 1, 0, 79);
                        break;
                    }
                    case 39: {
                        VT52Canvas.this.cursor_x = VT52Canvas.this.clip(VT52Canvas.this.cursor_x + 1, 0, 79);
                    }
                }
            }
        });
    }

    public static void message(String s) {
        System.err.println(s);
    }

    public static void main(String[] argv) {
        SetupManager.loadAllProperties(".hadesrc");
        JFrame frame = new JFrame("VT52Canvas selftest");
        VT52Canvas vtc = new VT52Canvas();
        frame.getContentPane().add("Center", vtc);
        frame.pack();
        frame.setVisible(true);
        vtc.startCursorBlinking();
        vtc.addDummyListener();
        vtc.setCursor(10, 2);
        int i = 0;
        while (i < 2000) {
            vtc.addChar((char)(65 + (int)(60.0 * Math.random())));
            ++i;
        }
    }

    protected class BlinkTimer
    extends Thread {
        public BlinkTimer() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                    VT52Canvas.this.hideCursor(VT52Canvas.this.getGraphics());
                    VT52Canvas.this.showCursor(VT52Canvas.this.getGraphics());
                    Thread.sleep(500L);
                    VT52Canvas.this.hideCursor(VT52Canvas.this.getGraphics());
                }
            }
            catch (InterruptedException e) {
                VT52Canvas.msg("-E- BlinkTimer: " + e);
                return;
            }
        }
    }
}

