/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.special.VT52Canvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Symbol;
import hades.utils.HexFormat;
import hades.utils.StringTokenizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jfig.gui.ImageHelper;
import jfig.utils.ExceptionTracer;

public class SerialTerminal
extends SimObject
implements Simulatable,
Wakeable {
    protected PortStdLogic1164 port_RX;
    protected PortStdLogic1164 port_TX;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    protected int baud_rate = 9600;
    protected int n_databits = 8;
    protected int n_stopbits = 2;
    protected int parity_mode = 1;
    protected double bit_time = 1.0 / (double)this.baud_rate;
    protected int n_rx_bits = 11;
    protected int rx_state = 0;
    protected boolean rx_waiting = true;
    protected boolean[] rx_samples = new boolean[12];
    protected double lastSendTime = 0.0;
    protected boolean enable_log = false;
    protected boolean showGUIAutomaticallyOption = true;
    JFrame topFrame;
    JPanel buttonPanel;
    JButton clearButton;
    JButton closeButton;
    JButton configButton;
    VT52Canvas vt52Canvas;
    JLabel receiveTF;
    JLabel receiveHexTF;
    JLabel transmitTF;
    JLabel transmitHexTF;
    JCheckBox enableLogCB;
    JConfigDialog configDialog;
    Image theIcon;
    private static char[] parity_chars = new char[]{'N', 'O', 'E'};

    public SerialTerminal() {
        this.port_RX = new PortStdLogic1164(this, "RX", 0, null);
        this.port_TX = new PortStdLogic1164(this, "TX", 1, null);
        this.ports = new Port[2];
        this.ports[0] = this.port_RX;
        this.ports[1] = this.port_TX;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.rx_waiting = true;
        this.rx_state = 0;
        this.buildGUI();
        this.buildGUICallbacks();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
    }

    public void setName(String name) {
        super.setName(name);
        if (this.topFrame != null) {
            this.topFrame.setTitle("SerialTerminal " + this.getName());
        }
    }

    void buildButtonPanel() {
        this.clearButton = new JButton("clear");
        this.closeButton = new JButton("close");
        this.configButton = new JButton("configure");
        this.enableLogCB = new JCheckBox("log:", this.enable_log);
        int CENTER = 0;
        this.receiveTF = new JLabel("__", CENTER);
        this.receiveHexTF = new JLabel("__", CENTER);
        this.transmitTF = new JLabel("__", CENTER);
        this.transmitHexTF = new JLabel("__", CENTER);
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.buttonPanel.setBackground(Color.lightGray);
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.buttonPanel.add(this.clearButton);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.configButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.enableLogCB);
        this.buttonPanel.add(new JLabel("rx:"));
        this.buttonPanel.add(this.receiveTF);
        this.buttonPanel.add(this.receiveHexTF);
        this.buttonPanel.add(new JLabel(" tx:"));
        this.buttonPanel.add(this.transmitTF);
        this.buttonPanel.add(this.transmitHexTF);
    }

    void buildGUI() {
        this.topFrame = new JFrame("SerialTerminal " + this.getName());
        this.topFrame.setBackground(Color.lightGray);
        this.topFrame.setDefaultCloseOperation(1);
        this.vt52Canvas = new VT52Canvas();
        this.vt52Canvas.setCursor(0, 0);
        this.vt52Canvas.startCursorBlinking();
        this.buildButtonPanel();
        this.theIcon = ImageHelper.loadResourceImage("/hades/gui/images/terminal-big.gif");
        this.topFrame.setIconImage(this.theIcon);
        this.topFrame.getContentPane().add("West", this.vt52Canvas);
        this.topFrame.getContentPane().add("South", this.buttonPanel);
        this.topFrame.pack();
    }

    void buildGUICallbacks() {
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SerialTerminal.this.vt52Canvas.clear();
                SerialTerminal.this.elaborate(null);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SerialTerminal.this.topFrame.setVisible(false);
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SerialTerminal.this.configDialog == null) {
                    SerialTerminal.this.configDialog = new JConfigDialog(SerialTerminal.this.topFrame, "Configure " + SerialTerminal.this.getName());
                }
                SerialTerminal.this.configDialog.setVisible(true);
            }
        });
        this.vt52Canvas.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                SerialTerminal.this.transmitOneCharacter(e.getKeyChar());
                if (SerialTerminal.this.enable_log) {
                    SerialTerminal.this.transmitTF.setText("' " + e.getKeyChar() + " '");
                    SerialTerminal.this.transmitHexTF.setText(HexFormat.getHexString(e.getKeyChar(), 2));
                }
            }
        });
        this.topFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SerialTerminal.this.topFrame.setVisible(false);
            }
        });
        this.enableLogCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                SerialTerminal.this.enable_log = SerialTerminal.this.enableLogCB.isSelected();
                SerialTerminal.this.buttonPanel.repaint();
            }
        });
    }

    public void setCommunication(int baud_rate, int data_bits, int stop_bits, int parity_mode) {
        this.baud_rate = baud_rate;
        this.n_databits = data_bits;
        this.n_stopbits = stop_bits;
        this.parity_mode = parity_mode;
        this.bit_time = 1.0 / (double)baud_rate;
        this.n_rx_bits = 1 + this.n_databits + this.n_stopbits;
        if (parity_mode != 0) {
            ++this.n_rx_bits;
        }
    }

    public void changeName() {
        this.message("-E- SerialTerminal.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.baud_rate + " " + this.n_databits + " " + this.n_stopbits + " " + this.parity_mode + " " + this.showGUIAutomaticallyOption);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.baud_rate = Integer.parseInt(st.nextToken());
            this.n_databits = Integer.parseInt(st.nextToken());
            this.n_stopbits = Integer.parseInt(st.nextToken());
            this.parity_mode = Integer.parseInt(st.nextToken());
            this.setCommunication(this.baud_rate, this.n_databits, this.n_stopbits, this.parity_mode);
            if (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                this.showGUIAutomaticallyOption = "true".equals(tmp);
            }
            if (this.showGUIAutomaticallyOption) {
                this.configure();
            }
            if (SimObject.debug) {
                this.message("SerialTerminal.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- SerialTerminal.initialize(): " + s);
        }
        return true;
    }

    public Component getPropertySheet() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        return this.topFrame;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("-I- SerialTerminal: mousePressed");
        }
        if (this.topFrame == null) {
            this.configure();
        } else {
            this.topFrame.setVisible(!this.topFrame.isShowing());
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.rx_waiting = true;
        this.lastSendTime = 0.0;
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        Signal signal_TX = this.port_TX.getSignal();
        double time = this.simulator.getSimTime();
        if (signal_TX != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_TX, time, this.value_1, (Object)this.port_TX));
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if (this.rx_waiting) {
            StdLogic1164 value = this.port_RX.getValueOrU();
            if (value.is_0()) {
                this.startReceive();
            }
        } else {
            return;
        }
    }

    public void wakeup(Object arg) {
        StdLogic1164 value = this.port_RX.getValueOrU();
        if (value == null || !value.is_01()) {
            this.message("-W- in SerialTerminal.wakeup: undefined RX value!");
            this.rx_waiting = true;
            this.rx_state = 0;
            return;
        }
        if (SimObject.debug) {
            this.message("SerialTerminal.wakeup: " + this.rx_state + " " + value);
        }
        if (this.rx_state == 0 && !value.is_0()) {
            this.message("-I- SerialTerminal: no start bit found!");
            this.rx_waiting = true;
            this.rx_state = 0;
            return;
        }
        this.rx_samples[this.rx_state] = value.is_1();
        ++this.rx_state;
        if (this.rx_state < this.n_rx_bits) {
            double time = this.simulator.getSimTime();
            this.simulator.scheduleWakeup(this, time + this.bit_time, this);
        } else {
            this.decode(this.rx_samples);
            this.rx_waiting = true;
            this.rx_state = 0;
        }
    }

    void startReceive() {
        if (SimObject.debug) {
            this.message("-I- SerialTerminal.startReceive!");
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + 0.5 * this.bit_time, this);
        this.rx_waiting = false;
        this.rx_state = 0;
    }

    void decode(boolean[] receivedBits) {
        if (SimObject.debug) {
            this.message("-I- decode: " + receivedBits);
        }
        int mask = 0;
        boolean calc_parity = false;
        int i = this.n_databits;
        while (i >= 1) {
            mask += mask;
            if (receivedBits[i]) {
                ++mask;
            }
            if (receivedBits[i]) {
                calc_parity = !calc_parity;
            }
            --i;
        }
        if (this.enable_log) {
            this.receiveTF.setText("' " + (char)mask + " '");
            this.receiveHexTF.setText(HexFormat.getHexString(mask, 2));
        }
        this.vt52Canvas.addChar((char)mask);
    }

    public void transmitOneCharacter(char c) {
        Signal signal_TX;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + " scheduling: " + c);
        }
        if ((signal_TX = this.port_TX.getSignal()) == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        if (time <= this.lastSendTime) {
            time = this.lastSendTime;
        }
        this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_0);
        time += this.bit_time;
        boolean[] databits = this.getDataBits(c, this.n_databits);
        int i = 0;
        while (i < this.n_databits) {
            if (databits[i]) {
                this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_1);
            } else {
                this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_0);
            }
            time += this.bit_time;
            ++i;
        }
        if (this.parity_mode != 0) {
            boolean parity = this.parity_mode == 2 ? this.getParityBit(databits, true) : this.getParityBit(databits, false);
            if (parity) {
                this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_1);
            } else {
                this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_0);
            }
            time += this.bit_time;
        }
        int i2 = 0;
        while (i2 < this.n_stopbits) {
            this.scheduleInteractive(signal_TX, this.port_TX, time, this.value_1);
            time += this.bit_time;
            ++i2;
        }
        this.lastSendTime = time;
    }

    void scheduleInteractive(Signal signal, Port port, double time, StdLogic1164 value) {
        this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public boolean[] getDataBits(char c, int n_databits) {
        boolean[] databits = new boolean[n_databits];
        int mask = c;
        int i = 0;
        while (i < n_databits) {
            databits[i] = (mask & '\u0001') > 0;
            mask >>>= 1;
            ++i;
        }
        return databits;
    }

    public boolean getParityBit(boolean[] databits, boolean even_parity) {
        boolean parity = false;
        int i = 0;
        while (i < databits.length) {
            if (databits[i]) {
                parity = !parity;
            }
            ++i;
        }
        if (even_parity) {
            parity = !parity;
        }
        return parity;
    }

    public SimObject copy() {
        SerialTerminal tmp = null;
        try {
            tmp = (SerialTerminal)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setCommunication(this.baud_rate, this.n_databits, this.n_stopbits, this.parity_mode);
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + this.baud_rate + " " + this.getCommString();
    }

    public String getCommString() {
        return "" + this.n_databits + parity_chars[this.parity_mode] + this.n_stopbits;
    }

    public String toString() {
        return "SerialTerminal: " + this.getFullName();
    }

    public static void main(String[] argv) {
        SerialTerminal cc = new SerialTerminal();
        cc.topFrame.setVisible(true);
    }

    public class JConfigDialog
    extends JDialog
    implements ActionListener {
        JPanel configPanel;
        JPanel buttonPanel;
        JComboBox baudRateChoice;
        JComboBox dataBitsChoice;
        JComboBox stopBitsChoice;
        JComboBox parityChoice;
        JCheckBox openGUICB;
        JButton okButton;
        JButton applyButton;
        JButton cancelButton;
        JLabel imageCanvas;
        int[] baudRates = new int[]{300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 56400, 115200};
        int[] dataBits = new int[]{7, 8};
        int[] stopBits = new int[]{1, 2};
        String[] parityModes = new String[]{"none", "odd", "even"};

        public JConfigDialog(JFrame parent, String name) {
            super((Frame)parent, name);
            this.buildGUI();
        }

        public void buildGUI() {
            this.setBackground(Color.lightGray);
            this.baudRateChoice = new JComboBox();
            int i = 0;
            while (i < this.baudRates.length) {
                this.baudRateChoice.addItem("" + this.baudRates[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.baudRates.length) {
                if (this.baudRates[i2] == SerialTerminal.this.baud_rate) {
                    this.baudRateChoice.setSelectedIndex(i2);
                }
                ++i2;
            }
            this.dataBitsChoice = new JComboBox();
            int i3 = 0;
            while (i3 < this.dataBits.length) {
                this.dataBitsChoice.addItem("" + this.dataBits[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.dataBits.length) {
                if (this.dataBits[i4] == SerialTerminal.this.n_databits) {
                    this.dataBitsChoice.setSelectedIndex(i4);
                }
                ++i4;
            }
            this.stopBitsChoice = new JComboBox();
            int i5 = 0;
            while (i5 < this.stopBits.length) {
                this.stopBitsChoice.addItem("" + this.stopBits[i5]);
                ++i5;
            }
            int i6 = 0;
            while (i6 < this.stopBits.length) {
                if (this.stopBits[i6] == SerialTerminal.this.n_stopbits) {
                    this.stopBitsChoice.setSelectedIndex(i6);
                }
                ++i6;
            }
            this.parityChoice = new JComboBox();
            int i7 = 0;
            while (i7 < this.parityModes.length) {
                this.parityChoice.addItem(this.parityModes[i7]);
                ++i7;
            }
            this.parityChoice.setSelectedIndex(SerialTerminal.this.parity_mode);
            this.openGUICB = new JCheckBox("shown at simulation start");
            this.openGUICB.setSelected(SerialTerminal.this.showGUIAutomaticallyOption);
            this.configPanel = new JPanel();
            this.configPanel.setLayout(new GridLayout(0, 2, 10, 10));
            this.configPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.configPanel.add(new JLabel("     baud rate:", 4));
            this.configPanel.add(this.baudRateChoice);
            this.configPanel.add(new JLabel("data bits:", 4));
            this.configPanel.add(this.dataBitsChoice);
            this.configPanel.add(new JLabel("parity:", 4));
            this.configPanel.add(this.parityChoice);
            this.configPanel.add(new JLabel("stop bits:", 4));
            this.configPanel.add(this.stopBitsChoice);
            this.configPanel.add(new JLabel(""));
            this.configPanel.add(new JLabel(""));
            this.configPanel.add(new JLabel("window:", 4));
            this.configPanel.add(this.openGUICB);
            this.buttonPanel = new JPanel();
            this.cancelButton = new JButton("Cancel");
            this.applyButton = new JButton("Apply");
            this.okButton = new JButton("OK");
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(this.applyButton);
            this.buttonPanel.add(new JLabel(""));
            this.buttonPanel.add(this.okButton);
            this.imageCanvas = new JLabel(new ImageIcon(SerialTerminal.this.theIcon));
            JPanel panel = new JPanel();
            panel.setBorder(new EmptyBorder(10, 5, 5, 5));
            panel.setLayout(new BorderLayout());
            panel.add("North", new JLabel("Communication:", 0));
            panel.add("Center", this.configPanel);
            panel.add("South", this.buttonPanel);
            panel.add("West", this.imageCanvas);
            this.getContentPane().add("Center", panel);
            this.pack();
            this.setVisible(true);
            this.cancelButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.okButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.cancelButton) {
                this.setVisible(false);
            } else if (evt.getSource() == this.applyButton) {
                this.applyCommunicationValues();
            } else if (evt.getSource() == this.okButton) {
                this.applyCommunicationValues();
                this.setVisible(false);
            }
        }

        public void applyCommunicationValues() {
            int baud_rate = this.baudRates[this.baudRateChoice.getSelectedIndex()];
            int data_bits = this.dataBits[this.dataBitsChoice.getSelectedIndex()];
            int stop_bits = this.stopBits[this.stopBitsChoice.getSelectedIndex()];
            int parity_mode = this.parityChoice.getSelectedIndex();
            SerialTerminal.this.setCommunication(baud_rate, data_bits, stop_bits, parity_mode);
            SerialTerminal.this.showGUIAutomaticallyOption = this.openGUICB.isSelected();
        }
    }
}

