/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.special.VT52Canvas;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.HexFormat;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jfig.gui.ImageHelper;
import jfig.utils.ExceptionTracer;

public class ParallelTerminal
extends SimObject
implements Simulatable {
    protected PortStdLogic1164 port_CLR;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_D0;
    protected PortStdLogic1164 port_STR;
    protected PortStdLogic1164 port_Q0;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    protected int index_D0;
    protected int index_STR;
    protected int index_Q0;
    protected double lastSendTime = 0.0;
    protected Label symbolTypeLabel;
    JFrame topFrame;
    JPanel buttonPanel;
    JButton clearButton;
    JButton closeButton;
    VT52Canvas vt52Canvas;
    JLabel receiveTF;
    JLabel receiveHexTF;
    JLabel transmitTF;
    JLabel transmitHexTF;
    Image theIcon;
    JCheckBox logCB;

    public ParallelTerminal() {
        this.ports = new Port[19];
        this.ports[0] = new PortStdLogic1164(this, "CLR", 0, null);
        this.ports[1] = new PortStdLogic1164(this, "CLK", 0, null);
        this.ports[2] = new PortStdLogic1164(this, "D0", 0, null);
        this.ports[3] = new PortStdLogic1164(this, "D1", 0, null);
        this.ports[4] = new PortStdLogic1164(this, "D2", 0, null);
        this.ports[5] = new PortStdLogic1164(this, "D3", 0, null);
        this.ports[6] = new PortStdLogic1164(this, "D4", 0, null);
        this.ports[7] = new PortStdLogic1164(this, "D5", 0, null);
        this.ports[8] = new PortStdLogic1164(this, "D6", 0, null);
        this.ports[9] = new PortStdLogic1164(this, "D7", 0, null);
        this.ports[10] = new PortStdLogic1164(this, "STR", 1, null);
        this.ports[11] = new PortStdLogic1164(this, "Q0", 1, null);
        this.ports[12] = new PortStdLogic1164(this, "Q1", 1, null);
        this.ports[13] = new PortStdLogic1164(this, "Q2", 1, null);
        this.ports[14] = new PortStdLogic1164(this, "Q3", 1, null);
        this.ports[15] = new PortStdLogic1164(this, "Q4", 1, null);
        this.ports[16] = new PortStdLogic1164(this, "Q5", 1, null);
        this.ports[17] = new PortStdLogic1164(this, "Q6", 1, null);
        this.ports[18] = new PortStdLogic1164(this, "Q7", 1, null);
        this.port_CLR = (PortStdLogic1164)this.ports[0];
        this.port_CLK = (PortStdLogic1164)this.ports[1];
        this.port_D0 = (PortStdLogic1164)this.ports[2];
        this.port_STR = (PortStdLogic1164)this.ports[10];
        this.port_Q0 = (PortStdLogic1164)this.ports[11];
        this.index_D0 = 2;
        this.index_STR = 10;
        this.index_Q0 = 11;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.lastSendTime = 0.0;
        this.configure();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
    }

    public void setName(String name) {
        super.setName(name);
        this.topFrame.setTitle("ParallelTerminal " + this.getName());
    }

    void buildButtonPanel() {
        this.clearButton = new JButton("clear");
        this.closeButton = new JButton("close");
        this.logCB = new JCheckBox("log:");
        this.logCB.setSelected(true);
        this.receiveTF = new JLabel("__", 0);
        this.receiveHexTF = new JLabel("__", 0);
        this.transmitTF = new JLabel("__", 0);
        this.transmitHexTF = new JLabel("__", 0);
        this.buttonPanel = new JPanel(new GridLayout(1, 0, 2, 2));
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.buttonPanel.add(this.clearButton);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.logCB);
        this.buttonPanel.add(new JLabel("   receive:"));
        this.buttonPanel.add(this.receiveTF);
        this.buttonPanel.add(this.receiveHexTF);
        this.buttonPanel.add(new JLabel("   transmit:"));
        this.buttonPanel.add(this.transmitTF);
        this.buttonPanel.add(this.transmitHexTF);
    }

    void buildGUI() {
        this.topFrame = new JFrame("ParallelTerminal " + this.getName());
        this.topFrame.setDefaultCloseOperation(1);
        this.vt52Canvas = new VT52Canvas();
        this.vt52Canvas.setCursor(0, 0);
        this.vt52Canvas.startCursorBlinking();
        this.buildButtonPanel();
        this.theIcon = ImageHelper.loadResourceImage("/hades/gui/images/terminal-big.gif");
        this.topFrame.setIconImage(this.theIcon);
        this.topFrame.getContentPane().add("Center", this.vt52Canvas);
        this.topFrame.getContentPane().add("South", this.buttonPanel);
        this.topFrame.pack();
    }

    void buildGUICallbacks() {
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParallelTerminal.this.vt52Canvas.clear();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParallelTerminal.this.topFrame.setVisible(false);
            }
        });
        this.vt52Canvas.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (ParallelTerminal.this.logCB.isSelected()) {
                    ParallelTerminal.this.transmitTF.setText("' " + e.getKeyChar() + " '");
                    ParallelTerminal.this.transmitHexTF.setText(HexFormat.getHexString(e.getKeyChar(), 2));
                }
                ParallelTerminal.this.transmitOneCharacter(e.getKeyChar());
            }
        });
        this.topFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ParallelTerminal.this.topFrame.setVisible(false);
            }
        });
    }

    public void changeName() {
        this.message("-E- ParallelTerminal.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (SimObject.debug) {
                this.message("ParallelTerminal.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- ParallelTerminal.initialize(): " + s);
        }
        return true;
    }

    public Component getPropertySheet() {
        return this.topFrame;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("-I- ParallelTerminal: mousePressed");
        }
        this.topFrame.setVisible(!this.topFrame.isShowing());
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        int i = this.index_STR;
        while (i < this.ports.length) {
            Signal signal_tmp = this.ports[i].getSignal();
            if (signal_tmp != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_tmp, time, this.value_0, (Object)this.ports[i]));
            }
            ++i;
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogic1164 value_CLR = this.port_CLR.getValueOrU();
        SignalStdLogic1164 signal_CLK = (SignalStdLogic1164)this.port_CLK.getSignal();
        if (value_CLR.is_0()) {
            this.vt52Canvas.clear();
            return;
        }
        if (signal_CLK != null && signal_CLK.hasRisingEdge()) {
            this.latchOneCharacter();
        }
    }

    void latchOneCharacter() {
        PortStdLogic1164 port_i = null;
        StdLogic1164 value_i = null;
        int mask = 0;
        int i = 0;
        while (i < 8) {
            mask += mask;
            port_i = (PortStdLogic1164)this.ports[this.index_D0 + 7 - i];
            value_i = port_i.getValueOrU();
            if (value_i.is_1()) {
                ++mask;
            }
            ++i;
        }
        this.vt52Canvas.addChar((char)mask);
        if (this.logCB.isSelected()) {
            this.receiveTF.setText("' " + (char)mask + " '");
            this.receiveHexTF.setText(HexFormat.getHexString(mask, 2));
        }
    }

    public void transmitOneCharacter(char c) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + " scheduling: " + (char)c);
        }
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        if (time <= this.lastSendTime) {
            time = this.lastSendTime;
        }
        Port port_i = null;
        Signal signal_i = null;
        StdLogic1164 value_i = null;
        int mask = c;
        int i = 0;
        while (i < 8) {
            port_i = this.ports[this.index_Q0 + i];
            signal_i = port_i.getSignal();
            if (signal_i != null) {
                value_i = (mask & '\u0001') > 0 ? new StdLogic1164(3) : new StdLogic1164(2);
                this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_i, time, value_i, (Object)port_i));
                mask >>>= 1;
            }
            ++i;
        }
        signal_i = this.port_STR.getSignal();
        if (signal_i == null) {
            return;
        }
        this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_i, time + 1.0E-7, this.value_1, (Object)this.port_STR));
        this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_i, time + 2.0E-7, this.value_0, (Object)this.port_STR));
        this.lastSendTime = time + 2.0E-7;
    }

    public SimObject copy() {
        ParallelTerminal tmp = null;
        try {
            tmp = (ParallelTerminal)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName();
    }

    public String toString() {
        return "ParallelTerminal: " + this.getFullName();
    }

    public static void main(String[] argv) {
        ParallelTerminal cc = new ParallelTerminal();
        cc.topFrame.setVisible(true);
    }
}

