/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Symbol;
import hades.utils.HexFormat;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;

public class MidiReceiver
extends SimObject
implements Simulatable,
Wakeable {
    protected PortStdLogic1164 port_RX;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    protected int baud_rate = 31250;
    protected int n_databits = 8;
    protected int n_stopbits = 1;
    protected int parity_mode = 0;
    protected double bit_time = 1.0 / (double)this.baud_rate;
    protected int n_rx_bits = 10;
    protected int rx_state = 0;
    protected boolean rx_waiting = true;
    protected boolean[] rx_samples = new boolean[12];
    protected double lastSendTime = 0.0;

    public MidiReceiver() {
        this.port_RX = new PortStdLogic1164(this, "RX", 0, null);
        this.ports = new Port[1];
        this.ports[0] = this.port_RX;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.rx_waiting = true;
        this.rx_state = 0;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void write(PrintWriter ps) {
        ps.print(" ");
    }

    public boolean initialize(String s) {
        return true;
    }

    public void configure() {
        this.message("-E- " + this.toString() + ".configure not yet!");
    }

    public void mousePressed(MouseEvent me) {
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.rx_waiting = true;
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
    }

    public StdLogic1164 getInputValue(Port p) {
        Signal signal = p.getSignal();
        if (signal == null) {
            return new StdLogic1164();
        }
        StdLogic1164 value = (StdLogic1164)signal.getValue();
        if (value == null) {
            return new StdLogic1164();
        }
        return value;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if (this.rx_waiting) {
            StdLogic1164 value = this.port_RX.getValueOrU();
            if (value.is_0()) {
                this.startReceive();
            }
        } else {
            return;
        }
    }

    public void wakeup(Object arg) {
        StdLogic1164 value = this.port_RX.getValueOrU();
        if (value == null || !value.is_01() && !value.is_H()) {
            this.message("-W- in MidiReceiver.wakeup: undefined RX value!");
            this.rx_waiting = true;
            this.rx_state = 0;
            return;
        }
        if (SimObject.debug) {
            this.message("MidiReceiver.wakeup: " + this.rx_state + " " + value);
        }
        if (this.rx_state == 0 && !value.is_0()) {
            this.message("-I- MidiReceiver: no start bit found!");
            this.rx_waiting = true;
            this.rx_state = 0;
            return;
        }
        this.rx_samples[this.rx_state] = value.is_1H();
        ++this.rx_state;
        if (this.rx_state < this.n_rx_bits) {
            double time = this.simulator.getSimTime();
            this.simulator.scheduleWakeup(this, time + this.bit_time, this);
        } else {
            this.decode(this.rx_samples);
            this.rx_waiting = true;
            this.rx_state = 0;
        }
    }

    void startReceive() {
        if (SimObject.debug) {
            this.message("-I- MidiReceiver.startReceive!");
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + 0.5 * this.bit_time, this);
        this.rx_waiting = false;
        this.rx_state = 0;
    }

    void decode(boolean[] receivedBits) {
        if (SimObject.debug) {
            this.message("-I- decode: " + receivedBits);
        }
        int mask = 0;
        boolean calc_parity = false;
        int i = this.n_databits;
        while (i >= 1) {
            mask += mask;
            if (receivedBits[i]) {
                ++mask;
            }
            if (receivedBits[i]) {
                calc_parity = !calc_parity;
            }
            --i;
        }
        System.out.println("MidiReceiver: got #" + HexFormat.getHexString(mask, 2) + " " + mask);
    }

    void schedule(Signal signal, Port port, double time, StdLogic1164 value) {
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public boolean[] getDataBits(char c, int n_databits) {
        boolean[] databits = new boolean[n_databits];
        int mask = c;
        int i = 0;
        while (i < n_databits) {
            databits[i] = (mask & '\u0001') > 0;
            mask >>>= 1;
            ++i;
        }
        return databits;
    }

    public boolean getParityBit(boolean[] databits, boolean even_parity) {
        boolean parity = false;
        int i = 0;
        while (i < databits.length) {
            if (databits[i]) {
                parity = !parity;
            }
            ++i;
        }
        if (even_parity) {
            parity = !parity;
        }
        return parity;
    }

    public SimObject copy() {
        MidiReceiver tmp = null;
        try {
            tmp = (MidiReceiver)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String toString() {
        return "MidiReceiver: " + this.getFullName();
    }

    public static void main(String[] argv) {
    }
}

