/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.special.GraphicsLCDCanvas;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.JFrame;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class GraphicsLCD
extends SimObject
implements Simulatable,
Wakeable {
    boolean debug = false;
    protected boolean busy = false;
    protected int command_word = 0;
    protected PortStdLogic1164 port_RS;
    protected PortStdLogic1164 port_RW;
    protected PortStdLogic1164 port_E = new PortStdLogic1164(this, "E", 0, null);
    protected PortStdLogic1164 port_nCS1 = new PortStdLogic1164(this, "nCS1", 0, null);
    protected PortStdLogic1164 port_nCS2 = new PortStdLogic1164(this, "nCS2", 0, null);
    protected PortStdLogic1164 port_nR = new PortStdLogic1164(this, "nR", 0, null);
    protected PortStdLogic1164 port_D7;
    protected PortStdLogic1164 port_D6;
    protected PortStdLogic1164 port_D5;
    protected PortStdLogic1164 port_D4;
    protected PortStdLogic1164 port_D3;
    protected PortStdLogic1164 port_D2;
    protected PortStdLogic1164 port_D1;
    protected PortStdLogic1164 port_D0;
    protected PortStdLogic1164 port_VO;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_H;
    protected Label symbolTypeLabel;
    KS0108 driver1;
    KS0108 driver2;
    JFrame topFrame;
    GraphicsLCDCanvas lcdCanvas;
    Image theIcon;
    public static final int NO_CS_BITS = 53247;
    public static final int BIT_nR = 16384;
    public static final int BIT_nCS2 = 8192;
    public static final int BIT_nCS1 = 4096;
    public static final int BIT_E = 1024;
    public static final int BIT_RS = 512;
    public static final int BIT_RW = 256;
    public static final int BIT_D7 = 128;
    public static final int BIT_D6 = 64;
    public static final int BIT_D5 = 32;
    public static final int BIT_D4 = 16;
    public static final int BIT_D3 = 8;
    public static final int BIT_D2 = 4;
    public static final int BIT_D1 = 2;
    public static final int BIT_D0 = 1;
    public int t_awt_repaint_millis = 100;

    public GraphicsLCD() {
        this.port_RS = new PortStdLogic1164(this, "RS", 0, null);
        this.port_RW = new PortStdLogic1164(this, "RW", 0, null);
        this.port_D7 = new PortStdLogic1164(this, "D7", 2, null);
        this.port_D6 = new PortStdLogic1164(this, "D6", 2, null);
        this.port_D5 = new PortStdLogic1164(this, "D5", 2, null);
        this.port_D4 = new PortStdLogic1164(this, "D4", 2, null);
        this.port_D3 = new PortStdLogic1164(this, "D3", 2, null);
        this.port_D2 = new PortStdLogic1164(this, "D2", 2, null);
        this.port_D1 = new PortStdLogic1164(this, "D1", 2, null);
        this.port_D0 = new PortStdLogic1164(this, "D0", 2, null);
        this.ports = new Port[14];
        this.ports[0] = this.port_D0;
        this.ports[1] = this.port_D1;
        this.ports[2] = this.port_D2;
        this.ports[3] = this.port_D3;
        this.ports[4] = this.port_D4;
        this.ports[5] = this.port_D5;
        this.ports[6] = this.port_D6;
        this.ports[7] = this.port_D7;
        this.ports[8] = this.port_RW;
        this.ports[9] = this.port_RS;
        this.ports[10] = this.port_E;
        this.ports[11] = this.port_nCS1;
        this.ports[12] = this.port_nCS2;
        this.ports[13] = this.port_nR;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.value_H = Const1164.__H;
        this.buildGUI();
        this.buildGUICallbacks();
        this.driver1 = new KS0108();
        this.driver1.setOffsets(0, 0);
        this.driver1.setCanvas(this.lcdCanvas);
        this.driver2 = new KS0108();
        this.driver2.setOffsets(0, 64);
        this.driver2.setCanvas(this.lcdCanvas);
        this.t_awt_repaint_millis = SetupManager.getInteger("Hades.GraphicsLCD.repaintMillis", 100);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
    }

    public void setName(String name) {
        super.setName(name);
        this.topFrame.setTitle("GraphicsLCD " + this.getName());
    }

    void buildGUI() {
        this.topFrame = new JFrame("GraphicsLCD " + this.getName());
        this.topFrame.setDefaultCloseOperation(1);
        this.lcdCanvas = new GraphicsLCDCanvas();
        this.topFrame.getContentPane().add("Center", this.lcdCanvas);
        this.topFrame.pack();
    }

    void buildGUICallbacks() {
        this.topFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GraphicsLCD.this.topFrame.setVisible(false);
            }
        });
    }

    public void changeName() {
        this.message("-E- GraphicsLCD.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (this.debug) {
                this.message("GraphicsLCD.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- GraphicsLCD.initialize(): " + s);
        }
        return true;
    }

    public Component getPropertySheet() {
        return this.topFrame;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (this.debug) {
            this.message("-I- GraphicsLCD: mousePressed");
        }
        this.topFrame.setVisible(!this.topFrame.isShowing());
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        this.driver1.doInitialize();
        this.driver2.doInitialize();
        this.disableDataBusDrivers(0.0);
    }

    public void evaluate(Object arg) {
        if (this.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        SignalStdLogic1164 signal_E = (SignalStdLogic1164)this.port_E.getSignal();
        SignalStdLogic1164 signal_RW = (SignalStdLogic1164)this.port_RW.getSignal();
        if (!this.port_nR.getValueOrU().is_1()) {
            this.disableDataBusDrivers(3.0E-8);
            this.driver1.doInitialize();
            this.driver2.doInitialize();
        }
        if (signal_E == null) {
            return;
        }
        StdLogic1164 value_RW = this.port_RW.getValueOrU();
        if (value_RW.is_1()) {
            if (signal_E.hasRisingEdge()) {
                int data = this.driver1.readData() & 0x7F;
                if (this.busy) {
                    data |= 0x80;
                }
                if (this.debug) {
                    System.out.println("-#- LCD.evaluate: reading: " + data + " " + this.busy);
                }
                this.enableDataBusDrivers(data, 3.0E-7);
                return;
            }
            if (signal_E.hasFallingEdge()) {
                this.disableDataBusDrivers(3.0E-8);
                return;
            }
        } else {
            if (signal_RW.hasFallingEdge()) {
                this.disableDataBusDrivers(3.0E-8);
                return;
            }
            if (value_RW.is_0() && signal_E.hasFallingEdge()) {
                int new_command = this.buildCommandWord();
                this.decode(new_command);
            }
        }
    }

    private int buildCommandWord() {
        int command_word = 0;
        if (this.port_nR.getValueOrU().is_0()) {
            command_word |= 0x4000;
        }
        if (this.port_nCS2.getValueOrU().is_0()) {
            command_word |= 0x2000;
        }
        if (this.port_nCS1.getValueOrU().is_0()) {
            command_word |= 0x1000;
        }
        if (this.port_RS.getValueOrU().isHigh_1H()) {
            command_word |= 0x200;
        }
        if (this.port_RW.getValueOrU().isHigh_1H()) {
            command_word |= 0x100;
        }
        if (this.port_D7.getValueOrU().isHigh_1H()) {
            command_word |= 0x80;
        }
        if (this.port_D6.getValueOrU().isHigh_1H()) {
            command_word |= 0x40;
        }
        if (this.port_D5.getValueOrU().isHigh_1H()) {
            command_word |= 0x20;
        }
        if (this.port_D4.getValueOrU().isHigh_1H()) {
            command_word |= 0x10;
        }
        if (this.port_D3.getValueOrU().isHigh_1H()) {
            command_word |= 8;
        }
        if (this.port_D2.getValueOrU().isHigh_1H()) {
            command_word |= 4;
        }
        if (this.port_D1.getValueOrU().isHigh_1H()) {
            command_word |= 2;
        }
        if (this.port_D0.getValueOrU().isHigh_1H()) {
            command_word |= 1;
        }
        if (this.debug) {
            System.out.println("-#- decoded command word: " + Integer.toHexString(command_word));
        }
        return command_word;
    }

    public void decode(int command) {
        if ((command & 0x2000) > 0) {
            this.driver2.decode(command & 0xCFFF);
        }
        if ((command & 0x1000) > 0) {
            this.driver1.decode(command & 0xCFFF);
        }
    }

    public SimObject copy() {
        GraphicsLCD tmp = null;
        try {
            tmp = (GraphicsLCD)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    private void disableDataBusDrivers(double delay) {
        if (this.simulator == null) {
            return;
        }
        StdLogic1164 value = this.value_H;
        double time = this.simulator.getSimTime() + delay;
        if (this.debug) {
            System.out.println("-#- LCD.disableDataBusDrivers: " + time);
        }
        int i = 0;
        while (i < 8) {
            Port port = this.ports[i];
            Signal signal = port.getSignal();
            if (signal != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            ++i;
        }
    }

    private void enableDataBusDrivers(int data, double delay) {
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        if (this.debug) {
            System.out.println("-#- LCD.enableDataBusDrivers: " + data + " " + time);
        }
        int mask = 1;
        int i = 0;
        while (i < 8) {
            StdLogic1164 value;
            Port port = this.ports[i];
            Signal signal = port.getSignal();
            StdLogic1164 stdLogic1164 = value = (data & mask) > 0 ? this.value_1 : this.value_0;
            if (signal != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            mask <<= 1;
            ++i;
        }
    }

    public void busyWait(double delta_t) {
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + delta_t, this);
        if (this.debug) {
            System.out.println("-#- busyWait: " + delta_t + " at " + time);
        }
    }

    public void wakeup(Object arg) {
        if (this.debug) {
            System.out.println("-#- wakeup: " + this.simulator.getSimTime());
        }
        this.busy = false;
        this.disableDataBusDrivers(0.0);
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName();
    }

    public String toString() {
        return "GraphicsLCD: " + this.getFullName();
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {}
    }

    public static void main(String[] argv) {
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        GraphicsLCD cc = new GraphicsLCD();
        cc.topFrame.setVisible(true);
        cc.lcdCanvas.clearDisplay();
        cc.decode(8255);
        cc.lcdCanvas.repaint();
        System.out.println("on");
        GraphicsLCD.sleep(1000);
        cc.decode(8254);
        cc.lcdCanvas.repaint();
        System.out.println("off");
        GraphicsLCD.sleep(1000);
        cc.decode(8255);
        cc.lcdCanvas.repaint();
        System.out.println("on again");
        GraphicsLCD.sleep(1000);
        cc.decode(8384);
        cc.decode(8372);
        cc.decode(8302);
        int i = 0;
        while (i < 32) {
            int data = (int)(256.0 * Math.random());
            cc.decode(8704 + data);
            ++i;
        }
        cc.lcdCanvas.repaint();
        System.out.println("first random data ready");
        GraphicsLCD.sleep(2000);
        cc.decode(4279);
        cc.decode(4160);
        int i2 = 0;
        while (i2 < 63) {
            int data = i2++;
            cc.decode(4608 + data);
        }
        cc.lcdCanvas.repaint();
        GraphicsLCD.sleep(2000);
        System.out.println("write binary data ready");
    }

    class KS0108 {
        public static final int CMD_RESET = 16384;
        public static final int CMD_READ_RAM = 768;
        public static final int CMD_WRITE_RAM = 512;
        public static final int CMD_READ_BUSY = 256;
        public static final int CMD_START_ADDR = 192;
        public static final int CMD_PAGE_ADDR = 176;
        public static final int CMD_BYTE_ADDR = 64;
        public static final int CMD_DISPLAY_ON = 48;
        public static final int CMD_CLEAR = 1;
        public static final int CMD_IDLE = 0;
        protected int command_word = 0;
        public static final int BIT_nR = 16384;
        public static final int BIT_RS = 512;
        public static final int BIT_RW = 256;
        public static final int BIT_D7 = 128;
        public static final int BIT_D6 = 64;
        public static final int BIT_D5 = 32;
        public static final int BIT_D4 = 16;
        public static final int BIT_D3 = 8;
        public static final int BIT_D2 = 4;
        public static final int BIT_D1 = 2;
        public static final int BIT_D0 = 1;
        protected int page_address = 0;
        protected int byte_address = 0;
        protected int start_address = 0;
        protected int lcd_start_page = 0;
        protected int lcd_start_col = 0;

        public void setOffsets(int page, int col) {
            this.lcd_start_page = page;
            this.lcd_start_col = col;
        }

        public void setCanvas(GraphicsLCDCanvas _canvas) {
            GraphicsLCD.this.lcdCanvas = _canvas;
        }

        public void doInitialize() {
            if (GraphicsLCD.this.debug) {
                System.out.println("-#- .doInitialize...");
            }
            this.start_address = 0;
            this.page_address = 0;
            this.byte_address = 0;
            this.command_word = 0;
            GraphicsLCD.this.lcdCanvas.clearDisplay();
            GraphicsLCD.this.lcdCanvas.enableDisplay(false);
        }

        public void doSetDisplayOn() {
            if ((this.command_word & 1) > 0) {
                GraphicsLCD.this.lcdCanvas.enableDisplay(true);
            } else {
                GraphicsLCD.this.lcdCanvas.enableDisplay(false);
            }
        }

        public void doSetStartAddress() {
            this.start_address = this.command_word & 0x3F;
            if (GraphicsLCD.this.debug) {
                System.err.println("-#- doSetStartAddress..." + this.start_address);
            }
        }

        public void doSetByteAddress() {
            this.byte_address = this.command_word & 0x3F;
            if (GraphicsLCD.this.debug) {
                System.err.println("-#- doSetByteAddress..." + this.byte_address);
            }
        }

        public void doSetPageAddress() {
            this.page_address = this.command_word & 7;
            if (GraphicsLCD.this.debug) {
                System.err.println("-#- doSetPageAddress..." + this.page_address);
            }
        }

        public void doReadBusy() {
            if (GraphicsLCD.this.debug) {
                System.err.println("-#- doReadBusy: NOT YET!");
            }
        }

        public void doWriteData() {
            if (GraphicsLCD.this.debug) {
                System.err.println("-#- doWriteData: " + this.command_word);
            }
            this.writeData(this.command_word & 0xFF);
        }

        public void doReadData() {
            int value = this.readData();
            if (GraphicsLCD.this.debug) {
                GraphicsLCD.this.message("-#- GraphicsLCD.doReadData: " + value);
            }
        }

        public void writeData(int value) {
            if (GraphicsLCD.this.debug) {
                System.out.println("-#- writeData: " + this.page_address + " " + this.byte_address + " " + value);
            }
            GraphicsLCD.this.lcdCanvas.write(this.lcd_start_page + this.page_address, this.lcd_start_col + this.byte_address, value);
            this.updateDataAddress();
        }

        public void updateDataAddress() {
            this.byte_address = this.byte_address + 1 & 0x3F;
        }

        public int readData() {
            int data = GraphicsLCD.this.lcdCanvas.read(this.lcd_start_page + this.page_address, this.lcd_start_col + this.byte_address);
            this.updateDataAddress();
            return data;
        }

        public void decode(int command) {
            if (GraphicsLCD.this.debug) {
                System.out.println("... decoding: " + Integer.toHexString(command));
            }
            this.command_word = command;
            if (this.command_word == 0) {
                return;
            }
            if (this.command_word >= 16384) {
                this.doInitialize();
            } else if (this.command_word >= 768) {
                this.doReadData();
            } else if (this.command_word >= 512) {
                this.doWriteData();
            } else if (this.command_word >= 256) {
                this.doReadBusy();
            } else if (this.command_word >= 192) {
                this.doSetStartAddress();
            } else if (this.command_word >= 176) {
                this.doSetPageAddress();
            } else if (this.command_word >= 64) {
                this.doSetByteAddress();
            } else if (this.command_word >= 48) {
                this.doSetDisplayOn();
            } else {
                System.err.println("-E- internal error: illegal command word: " + Integer.toHexString(this.command_word));
            }
        }
    }
}

