/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.models.ruge.Color_DIN_IEC_62;
import hades.models.ruge.ColoredRectangle;
import hades.models.ruge.ColoredValueLabel;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class Latch
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_CLK;
    protected Port port_D;
    protected Port port_Q;
    protected Integer value;
    protected Integer value_U;
    protected StdLogic1164 ieee_U;
    protected double delay;
    protected double defaultdelay = 1.0E-8;
    protected double t_setup = 5.0E-9;
    static /* synthetic */ Class class$hades$signals$SignalStdLogic1164;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;

    public Latch() {
        this.ports = new Port[3];
        this.ports[0] = new Port(this, "CLK", 0, null, class$hades$signals$SignalStdLogic1164 == null ? (class$hades$signals$SignalStdLogic1164 = Latch.class$("hades.signals.SignalStdLogic1164")) : class$hades$signals$SignalStdLogic1164);
        this.ports[1] = new Port(this, "D", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Latch.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[2] = new Port(this, "Q", 1, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Latch.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_CLK = this.ports[0];
        this.port_D = this.ports[1];
        this.port_Q = this.ports[2];
        this.value = this.value_U = new Integer(0);
        this.ieee_U = new StdLogic1164();
        this.delay = this.defaultdelay;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer _value) {
        this.value = _value;
        this.schedule();
    }

    public void setValue(String s) {
        try {
            this.value = new Integer(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-W- Using default value: " + this.value_U);
            this.value = this.value_U;
        }
        this.schedule();
        this.updateColors();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        this.value = arg instanceof Integer ? (Integer)arg : this.value_U;
        if (this.value == null) {
            this.message("-E- Internal in Latch.elaborate: value == null ?!");
            this.value = new Integer(13);
        }
        this.schedule();
        this.updateColors();
    }

    public void evaluate(Object arg) {
        Integer value_D;
        StdLogic1164 value_CLK;
        if (SimObject.debug) {
            this.message("-I- Latch.evaluate...");
        }
        boolean unconnectedInputs = false;
        Signal signal_CLK = this.port_CLK.getSignal();
        if (signal_CLK != null) {
            value_CLK = (StdLogic1164)signal_CLK.getValue();
        } else {
            unconnectedInputs = true;
            value_CLK = this.ieee_U;
        }
        Signal signal_D = this.port_D.getSignal();
        if (signal_D != null) {
            value_D = (Integer)signal_D.getValue();
        } else {
            unconnectedInputs = true;
            value_D = this.value_U;
        }
        if (unconnectedInputs) {
            this.value = this.value_U;
            if (SimObject.debug) {
                this.message("-***- new value is " + this.value);
            }
            this.schedule();
            this.updateColors();
        } else if (value_CLK.is_1()) {
            this.value = value_D;
            if (SimObject.debug) {
                this.message("-***- new value is " + this.value);
            }
            this.schedule();
            this.updateColors();
        } else {
            return;
        }
    }

    public void schedule() {
        if (this.simulator == null) {
            return;
        }
        if (this.value == null) {
            return;
        }
        Signal signal_Q = this.port_Q.getSignal();
        if (signal_Q == null) {
            return;
        }
        this.simulator.scheduleEvent(new SimEvent(signal_Q, this.simulator.getSimTime() + this.delay, this.value, this.port_Q));
    }

    public void updateColors() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Color c = Color_DIN_IEC_62.getColor((int)this.value);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(c);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(c);
            ((ColoredValueLabel)tmp).setText("" + this.value);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "current value [0,1,..]:", "value", "propagation delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, current output value\nand propagation delay:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.value = new Integer(Integer.parseInt(st.nextToken()));
            this.delay = new Double(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Error in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.value = new Integer(42);
            this.delay = this.defaultdelay;
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.value + " " + this.delay);
    }

    public String toString() {
        return "Latch: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

