/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.WireSegment;
import java.awt.Color;
import jfig.canvas.ObjectPainter;
import jfig.utils.ExceptionTracer;

public class IntegerSignal
extends Signal {
    public Integer defaultValue = new Integer(-1);

    public IntegerSignal() {
        this("n0");
    }

    public IntegerSignal(String name) {
        this.value = this.defaultValue;
    }

    public IntegerSignal(String name, Port[] senders, Port[] receivers) {
        this(name);
        this.senders = senders;
        this.receivers = receivers;
        this.driverValues = new Object[senders.length];
        int i = 0;
        while (i < senders.length) {
            this.driverValues[i] = new Integer(-1);
            ++i;
        }
    }

    public void addSegment(WireSegment ws) {
        super.addSegment(ws);
        ws.getAttributes().lineWidth = 150.0;
        ws.update(ws.getAttributes());
    }

    public static Signal getDefaultValue() {
        return new IntegerSignal();
    }

    public void elaborate(Object arg) {
        this.lastChangeTime = 0.0;
        this.value = this.defaultValue;
        this.lastValue = null;
    }

    public void evaluate(Object arg) {
        if (Signal.debug) {
            System.err.println("IntegerSignal<" + this.getName() + ">.evaluate()");
            System.err.println("    argument: " + arg);
        }
        if (arg == null) {
            return;
        }
        SimEvent event = null;
        Object eventSource = null;
        try {
            event = (SimEvent)arg;
            if (this.senders.length == 1) {
                this.lastValue = this.value;
                this.value = (Integer)event.getArg();
                eventSource = event.getSource();
            } else {
                this.lastValue = this.value;
                this.value = (Integer)event.getArg();
                eventSource = event.getSource();
            }
            if (this.value == null) {
                this.value = new Integer(-1);
            }
            if (!this.value.equals(this.lastValue)) {
                this.lastChangeTime = event.getTime();
                int i = 0;
                while (i < this.receivers.length) {
                    if (eventSource != this.receivers[i]) {
                        this.receivers[i].getHandler().evaluate(event);
                    }
                    ++i;
                }
                if (this.hasProbe()) {
                    this.probe.addValue(this.value, this.lastChangeTime);
                }
                this.animate();
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("IntegerSignal.evaluate: Exception " + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public Color getColor() {
        if (!this.glowMode) {
            return Color.blue;
        }
        return Color_DIN_IEC_62.getColor((Integer)this.value);
    }

    public void handleGlowMode() {
        if (!this.visible) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public void animate() {
        if (!this.glowMode) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }
}

