/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;

public class DelayNode
extends SimObject
implements Simulatable,
Serializable {
    protected Integer value;
    protected double delay;
    protected double defaultdelay = 0.2;
    protected int defaultValue = 0;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;

    public DelayNode() {
        this.ports = new Port[4];
        this.ports[0] = new Port(this, "A", 2, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = DelayNode.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[1] = new Port(this, "B", 2, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = DelayNode.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[2] = new Port(this, "C", 2, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = DelayNode.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[3] = new Port(this, "D", 2, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = DelayNode.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.value = new Integer(this.defaultValue);
        this.delay = this.defaultdelay;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer _value) {
        this.value = _value;
        this.schedule(-1);
    }

    public void setValue(String s) {
        try {
            this.value = new Integer(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultValue);
            this.value = new Integer(this.defaultValue);
        }
        this.schedule(-1);
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        if (arg == null) {
            return;
        }
        this.value = arg instanceof Integer ? (Integer)arg : new Integer(this.defaultValue);
        this.schedule(-1);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- DelayNode.evaluate: " + arg);
        }
        Signal signal = null;
        Integer newvalue = null;
        int i = 0;
        while (i < this.ports.length) {
            signal = this.ports[i].getSignal();
            if (signal != null && signal.hasEvent()) {
                newvalue = (Integer)signal.getValue();
                if (newvalue.intValue() != this.value.intValue()) {
                    if (newvalue == null) {
                        this.message("-E- Internal in DelayNode.evaluate: newvalue=null");
                        return;
                    }
                    this.value = newvalue;
                    this.schedule(i);
                }
                return;
            }
            ++i;
        }
    }

    public void schedule(int index) {
        if (this.simulator == null) {
            return;
        }
        if (this.value == null) {
            return;
        }
        double time = this.simulator.getSimTime() + this.delay;
        Signal signal = null;
        int i = 0;
        while (i < this.ports.length) {
            if (i != index && (signal = this.ports[i].getSignal()) != null) {
                this.simulator.scheduleEvent(new SimEvent(signal, time, this.value, this.ports[i]));
            }
            ++i;
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "delay time:", "delay", "DelayNode value:", "value"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and output value:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.delay = new Double(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Error in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.value = new Integer(42);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public String toString() {
        return "DelayNode: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

