/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.models.ruge.Color_DIN_IEC_62;
import hades.models.ruge.ColoredRectangle;
import hades.models.ruge.ColoredValueLabel;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class Constant
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_Y;
    protected Integer value;
    protected double t_delay = 1.0E-9;
    protected int defaultValue = 0;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;

    public Constant() {
        this.ports = new Port[1];
        this.ports[0] = new Port(this, "Y", 1, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Constant.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_Y = this.ports[0];
        this.value = new Integer(this.defaultValue);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer _value) {
        this.value = _value;
        this.schedule();
    }

    public void setValue(String s) {
        try {
            this.value = new Integer(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultValue);
            this.value = new Integer(this.defaultValue);
        }
        this.schedule();
        this.updateColors();
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        this.value = arg instanceof Integer ? (Integer)arg : new Integer(this.defaultValue);
        this.schedule();
        this.updateColors();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- Constant.evaluate: " + arg);
        }
        this.schedule();
        this.updateColors();
    }

    public void schedule() {
        if (this.simulator == null) {
            return;
        }
        if (this.value == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        this.simulator.scheduleEvent(new SimEvent(signal_Y, this.simulator.getSimTime() + this.t_delay, this.value, this.port_Y));
    }

    public void updateColors() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Color c = Color_DIN_IEC_62.getColor((int)this.value);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(c);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(c);
            ((ColoredValueLabel)tmp).setText("" + this.value);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void mousePressed(MouseEvent evt) {
        int v = this.value;
        this.value = evt.isShiftDown() ? new Integer(--v) : new Integer(++v);
        this.schedule();
        this.updateColors();
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "constant value:", "value"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and output value\n\n(Click or <shift>+Click to increment/decrement)");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.value = new Integer(Integer.parseInt(st.nextToken()));
        }
        catch (Exception e) {
            this.message("-E- Error in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.value = new Integer(42);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.value);
    }

    public String toString() {
        return "Constant: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

