/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.register;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.utils.LFSR32;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class LFSR
extends GenericRtlibObject
implements Assignable {
    protected PortStdLogicVector port_Q;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_NR;
    protected double t_setup = 5.0E-9;
    protected LFSR32 lfsr = new LFSR32();
    protected int seed = 13755891;

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || this.n_bits > 32) {
            this.message("-E- Bus width out of range [1..32]: " + _n);
            this.message("-E- using width=32 instead...");
            this.n_bits = 32;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.updateSymbol();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int _seed) {
        this.seed = _seed;
    }

    public void setSeed(String s) {
        try {
            this.setSeed(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.message("-E- Illegal seed value: '" + s + "'");
        }
    }

    public void constructPorts() {
        this.port_Q = new PortStdLogicVector((SimObject)this, "Q", 1, null, this.n_bits);
        this.port_CLK = new PortStdLogic1164(this, "CLK", 0, null);
        this.port_NR = new PortStdLogic1164(this, "NR", 0, null);
        this.ports = new Port[3];
        this.ports[0] = this.port_CLK;
        this.ports[1] = this.port_NR;
        this.ports[2] = this.port_Q;
        this.vectorOutputPort = this.port_Q;
    }

    public void setValue(long _value) {
        super.setValue(_value);
        this.lfsr.setValue((int)this.getValue());
        this.setSeed((int)_value);
    }

    public void setValue(String s) {
        super.setValue(s);
        this.lfsr.setValue((int)this.getValue());
    }

    public long getLFSRValue() {
        return 0xFFFFFFFFL & (long)this.lfsr.getValue();
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.lfsr.setValue(this.seed);
        this.vector = new StdLogicVector(this.n_bits, this.getLFSRValue());
        this.updateSymbol();
        if (this.enableAnimationFlag) {
            this.wakeupAfter(this.delay);
        }
        this.scheduleAfter(this.delay, (Port)this.port_Q, this.vector);
    }

    public void evaluate(Object arg) {
        StdLogic1164 value_CLK = this.port_CLK.getValueOrU();
        StdLogic1164 value_NR = this.port_NR.getValueOrU();
        if (!value_CLK.is_01()) {
            this.vector = this.vector_XXX.copy();
        } else if (!value_NR.is_01()) {
            this.vector = this.vector_XXX.copy();
        } else if (value_NR.is_0()) {
            this.lfsr.setValue(this.seed);
            this.vector = new StdLogicVector(this.n_bits);
            this.vector.setValue(this.getLFSRValue());
        } else if (this.port_CLK.hasEvent() && value_CLK.is_1()) {
            this.lfsr.normal_clock();
            this.vector = new StdLogicVector(this.n_bits);
            this.vector.setValue(this.getLFSRValue());
        }
        if (this.enableAnimationFlag) {
            this.wakeupAfter(this.delay);
        }
        this.scheduleAfter(this.delay, (Port)this.port_Q, this.vector);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.vector.toBinString() + " " + this.delay + " " + this.seed);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setValue(st.nextToken());
            this.setDelay(st.nextToken());
            this.setSeed(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
            e.printStackTrace();
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number of bits [1 .. 62]:", "width", "output value [0..1ZX_b]:", "formattedValue", "output delay [sec]:", "delay", "enable animation: [T/F]", "enableAnimationFlag", "format[0=dec, 1=hex, 2=bin]:", "numberFormat", "seed [int]", "seed"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    abcd_h\ndecimal: 4711\n");
        this.propertySheet.setVisible(true);
    }
}

