/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.muxes;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ColoredRectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import jfig.objects.FigObject;

public class Mux21
extends GenericRtlibObject {
    protected PortStdLogicVector port_A1;
    protected PortStdLogicVector port_A0;
    protected PortStdLogicVector port_Y;
    protected PortStdLogic1164 port_S;
    protected FigObject marker1;
    protected FigObject marker0;

    public void constructPorts() {
        this.port_A1 = new PortStdLogicVector((SimObject)this, "A1", 0, null, this.n_bits);
        this.port_A0 = new PortStdLogicVector((SimObject)this, "A0", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.port_S = new PortStdLogic1164(this, "S", 0, null);
        this.ports = new Port[4];
        this.ports[0] = this.port_S;
        this.ports[1] = this.port_A1;
        this.ports[2] = this.port_A0;
        this.ports[3] = this.port_Y;
        this.vectorOutputPort = this.port_Y;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.initDisplay();
    }

    public void initDisplay() {
        if (SimObject.debug) {
            this.message("-#- Mux21.initDisplay...");
        }
        Point pos = this.symbol.getPos();
        this.marker1 = new ColoredRectangle();
        this.marker0 = new ColoredRectangle();
        this.marker1.initialize("1100 0 1300 400");
        this.marker0.initialize("2300 0 2500 400");
        this.marker1.setVisible(false);
        this.marker0.setVisible(false);
        this.marker1.move(pos.x, pos.y);
        this.marker0.move(pos.x, pos.y);
        this.symbol.addMember(this.marker1);
        this.symbol.addMember(this.marker0);
    }

    public void evaluate(Object arg) {
        Signal signal_Y;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogicVector a0 = this.port_A0.getVectorOrUUU();
        StdLogicVector a1 = this.port_A1.getVectorOrUUU();
        StdLogic1164 s = this.port_S.getValueOrU();
        if (s.is_1()) {
            this.vector = a1.copy();
            this.setMarkers(1);
        } else if (s.is_0()) {
            this.vector = a0.copy();
            this.setMarkers(0);
        } else {
            this.vector = this.vector_UUU.copy();
            this.setMarkers(-1);
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (this.enableAnimationFlag) {
            simulator.scheduleWakeup(this, time, this);
        }
        if ((signal_Y = this.port_Y.getSignal()) == null) {
            return;
        }
        simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
    }

    private void setMarkers(int i) {
        if (!this.enableAnimationFlag) {
            return;
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.marker0 == null) {
            this.message("-E- Internal: " + this.toString() + " marker0 is null?");
            return;
        }
        switch (i) {
            case 0: {
                this.marker0.setVisible(true);
                this.marker1.setVisible(false);
                break;
            }
            case 1: {
                this.marker0.setVisible(false);
                this.marker1.setVisible(true);
                break;
            }
            default: {
                this.marker0.setVisible(false);
                this.marker1.setVisible(false);
            }
        }
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (!this.enableAnimationFlag) {
            return;
        }
        int intValue = (int)this.vector.getValue();
        Color color = Color_DIN_IEC_62.getColor(intValue);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (!(tmp instanceof ColoredRectangle)) continue;
            ((ColoredRectangle)tmp).setColor(color);
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 30);
    }
}

