/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.muxes;

import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;

public class Decoder
extends GenericRtlibObject {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_Y;
    protected StdLogicVector value_A;

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, 1 << this.n_bits);
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_Y;
    }

    public void setWidth(int _n) {
        if (_n > 5) {
            this.message("-E- Bus width too big: " + _n + ", using 5 instead!");
            _n = 5;
        }
        super.setWidth(_n);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.value_A = this.port_A.getVectorOrUUU();
        if (this.value_A.has_UXZ()) {
            this.vector = new StdLogicVector(1 << this.n_bits);
        } else {
            this.vector = new StdLogicVector(1 << this.n_bits, 0L);
            long index = this.value_A.getValue();
            this.vector.setBitAt((int)index, new StdLogic1164(3));
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }
}

