/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class RegBank
extends GenericMemory {
    protected PortStdLogicVector port_AX;
    protected PortStdLogicVector port_AY;
    protected PortStdLogicVector port_AZ;
    protected PortStdLogicVector port_DX;
    protected PortStdLogicVector port_DY;
    protected PortStdLogicVector port_DZ;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_CLK;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;

    public RegBank() {
        this.constructPorts();
    }

    @Override
    protected void constructPorts() {
        int n = this.getAddressBusWidth();
        this.port_AX = new PortStdLogicVector((SimObject)this, "AX", 0, null, n);
        this.port_AY = new PortStdLogicVector((SimObject)this, "AY", 0, null, n);
        this.port_AZ = new PortStdLogicVector((SimObject)this, "AZ", 0, null, n);
        this.port_DX = new PortStdLogicVector((SimObject)this, "DX", 1, null, this.n_bits);
        this.port_DY = new PortStdLogicVector((SimObject)this, "DY", 1, null, this.n_bits);
        this.port_DZ = new PortStdLogicVector((SimObject)this, "DZ", 0, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_CLK = new PortStdLogic1164(this, "CLK", 0, null);
        this.ports = new Port[8];
        this.ports[0] = this.port_AX;
        this.ports[1] = this.port_AY;
        this.ports[2] = this.port_AZ;
        this.ports[3] = this.port_DX;
        this.ports[4] = this.port_DY;
        this.ports[5] = this.port_DZ;
        this.ports[6] = this.port_nWE;
        this.ports[7] = this.port_CLK;
    }

    @Override
    public boolean canChangeSize() {
        return !this.isConnected();
    }

    @Override
    public void setSize(int n) {
        this.resize(n, this.getBitsPerWord());
    }

    @Override
    public void setBitsPerWord(int n) {
        this.resize(this.getSize(), n);
    }

    @Override
    public boolean resize(int n, int n2) {
        this.n_words = n;
        this.n_bits = n2;
        this.data = new long[n];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    @Override
    public void elaborate(Object object) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        if (this.port_DX.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DX.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DX));
        }
        if (this.port_DY.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DY.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DY));
        }
    }

    @Override
    public void evaluate(Object object) {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double d = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector stdLogicVector = this.port_AX.getVectorOrUUU();
        StdLogicVector stdLogicVector2 = this.port_AY.getVectorOrUUU();
        StdLogicVector stdLogicVector3 = this.port_AZ.getVectorOrUUU();
        StdLogicVector stdLogicVector4 = null;
        StdLogicVector stdLogicVector5 = null;
        StdLogicVector stdLogicVector6 = this.port_DZ.getVectorOrUUU();
        StdLogic1164 stdLogic1164 = this.port_nWE.getValueOrU();
        StdLogic1164 stdLogic11642 = this.port_CLK.getValueOrU();
        if (!stdLogic1164.is_01()) {
            this.message("-W- " + this.toString() + "nWE undefined: data loss would occur! Ignoring...");
        } else if (!stdLogic11642.is_01()) {
            this.message("-W- " + this.toString() + "CLK undefined: data loss would occur! Ignoring...");
        } else if (stdLogicVector3.has_UXZ()) {
            this.message("-W- " + this.toString() + "AZ address undefined: data loss would occur! Ignoring...");
        } else {
            SignalStdLogic1164 signalStdLogic1164 = (SignalStdLogic1164)this.port_CLK.getSignal();
            if (stdLogic1164.is_0() && signalStdLogic1164 != null && signalStdLogic1164.hasRisingEdge()) {
                int n = (int)stdLogicVector3.getValue();
                long l = this.getDataAt(n);
                long l2 = stdLogicVector6.getValue();
                if (stdLogicVector6.has_UXZ()) {
                    l2 = -1L;
                }
                this.setDataAt(n, l2);
                this.notifyWriteListeners(n, l, l2);
            }
        }
        if (stdLogicVector.has_UXZ()) {
            stdLogicVector4 = this.vector_UUU.copy();
        } else {
            int n = (int)stdLogicVector.getValue();
            long l = this.getDataAt(n);
            stdLogicVector4 = new StdLogicVector(this.n_bits, l);
            this.notifyReadListeners(n, l);
            this.schedule(this.port_DX, stdLogicVector4, d + 3.0E-8);
        }
        if (stdLogicVector2.has_UXZ()) {
            stdLogicVector5 = this.vector_UUU.copy();
        } else {
            int n = (int)stdLogicVector2.getValue();
            long l = this.getDataAt(n);
            stdLogicVector5 = new StdLogicVector(this.n_bits, l);
            this.notifyReadListeners(n, l);
            this.schedule(this.port_DY, stdLogicVector5, d + 3.0E-8);
        }
    }

    public void schedule(Port port, Object object, double d) {
        Signal signal = port.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, d, object, port));
        }
    }
}

