/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class ROM
extends GenericMemory {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_D;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;

    public ROM() {
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_D = new PortStdLogicVector((SimObject)this, "D", 1, null, this.n_bits);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth());
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_D;
    }

    public boolean canChangeSize() {
        return !this.isConnected();
    }

    public void setSize(int n_words) {
        this.resize(n_words, this.getBitsPerWord());
    }

    public void setBitsPerWord(int n_bits) {
        this.resize(this.getSize(), n_bits);
    }

    public boolean resize(int n_words, int n_bits) {
        this.n_words = n_words;
        this.n_bits = n_bits;
        this.data = new long[n_words];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null && this.port_D.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_D.getSignal(), 0.0, this.vector_UUU.copy(), this.port_D));
        }
    }

    public void evaluate(Object arg) {
        Signal signal_D;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_D = this.port_D.getSignal()) == null) {
            return;
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_D = null;
        if (vector_A.has_UXZ()) {
            vector_D = this.vector_UUU.copy();
            int addr = -1;
            long data = -1L;
        } else {
            int addr = (int)vector_A.getValue();
            long data = this.getDataAt(addr);
            vector_D = new StdLogicVector(this.n_bits, data);
            this.notifyReadListeners(addr, data);
        }
        this.simulator.scheduleEvent(new SimEvent(signal_D, time, vector_D, this.port_D));
    }
}

