/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.TimeFormatter;

public class RAM
extends GenericMemory {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_DIN;
    protected PortStdLogicVector port_DOUT;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;

    public RAM() {
        this.constructPorts();
    }

    @Override
    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth());
        this.port_DIN = new PortStdLogicVector((SimObject)this, "DIN", 0, null, this.n_bits);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.ports = new Port[5];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DIN;
        this.ports[2] = this.port_DOUT;
        this.ports[3] = this.port_nWE;
        this.ports[4] = this.port_nCS;
    }

    @Override
    public boolean canChangeSize() {
        return !this.isConnected();
    }

    @Override
    public void setSize(int n) {
        this.resize(n, this.getBitsPerWord());
    }

    @Override
    public void setBitsPerWord(int n) {
        this.resize(this.getSize(), n);
    }

    @Override
    public boolean resize(int n, int n2) {
        this.n_words = n;
        this.n_bits = n2;
        this.data = new long[n];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    @Override
    public void elaborate(Object object) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null && this.port_DOUT.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DOUT.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DOUT));
        }
    }

    @Override
    public void evaluate(Object object) {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double d = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector stdLogicVector = this.port_A.getVectorOrUUU();
        StdLogicVector stdLogicVector2 = this.port_DIN.getVectorOrUUU();
        StdLogicVector stdLogicVector3 = null;
        StdLogic1164 stdLogic1164 = this.port_nCS.getValueOrU();
        StdLogic1164 stdLogic11642 = this.port_nWE.getValueOrU();
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        if (stdLogic1164.is_1()) {
            stdLogicVector3 = this.vector_ZZZ.copy();
        } else if (!stdLogic1164.is_0()) {
            stdLogicVector3 = this.vector_UUU.copy();
            if (!stdLogic11642.is_1()) {
                this.warning("-W- RAM: nWE active but nCS undefined: data might be lost!");
                this.checkInvalidateMemory();
            }
        } else if (stdLogic11642.is_1()) {
            if (stdLogicVector.has_UXZ()) {
                this.warning("-W- RAM: address undefined during read cycle");
                stdLogicVector3 = this.vector_UUU.copy();
            } else {
                n = (int)stdLogicVector.getValue();
                l = this.getDataAt(n);
                stdLogicVector3 = new StdLogicVector(this.n_bits, l);
                this.notifyReadListeners(n, l);
            }
        } else if (stdLogic11642.is_0()) {
            if (stdLogicVector.has_UXZ()) {
                this.warning("-W- RAM: address undefined during write cycle: complete memory contents might be lost!");
                this.checkInvalidateMemory();
                stdLogicVector3 = this.vector_UUU.copy();
            } else if (stdLogicVector2.has_UXZ()) {
                this.warning("-W- RAM: data undefined during write cycle: addressed data is invalidated!");
                System.out.println("-E- RAM: data undefined during write cycle: ");
                System.out.println("    vector_DIN= " + stdLogicVector2);
                System.out.println("    addr = " + stdLogicVector);
                System.out.println("    time " + TimeFormatter.format(this.simulator.getSimTime()));
                n = (int)stdLogicVector.getValue();
                l = this.vector_XXX.getValue();
                l2 = this.getDataAt(n);
                this.setDataAt(n, l);
                this.notifyWriteListeners(n, l2, l);
                stdLogicVector3 = this.vector_UUU.copy();
            } else {
                n = (int)stdLogicVector.getValue();
                l = stdLogicVector2.getValue();
                l2 = this.getDataAt(n);
                this.setDataAt(n, l);
                this.notifyWriteListeners(n, l2, l);
                stdLogicVector3 = new StdLogicVector(this.n_bits, l);
            }
        } else {
            this.message("-W- RAM.evaluate(): write enable undefined: data would be lost. Ignored!");
            stdLogicVector3 = this.vector_UUU.copy();
        }
        Signal signal = this.port_DOUT.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, d, stdLogicVector3, this.port_DOUT));
        }
    }
}

