/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.CloseableFrame;
import hades.gui.MemoryHexEditorField;
import hades.models.rtlib.memory.MR;
import hades.utils.ContextToolTip;
import hades.utils.HexFormat;
import hades.utils.ToolTipManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jfig.utils.SetupManager;

public class MRCanvas
extends MemoryHexEditorField
implements KeyListener,
MouseListener,
ContextToolTip {
    private MR microRom;
    protected int n_fields;
    protected int label_x;
    protected int[] field_x;
    protected Font textFont;
    private Color activeDataColor;
    private Color passiveDataColor;

    public MRCanvas(MR mR, int n) {
        super(mR, n);
        this.microRom = mR;
        this.n_words = this.microRom.getSize();
        this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
        this.moveCursorTo(17, 13);
        this.compileFieldIndexArray();
        this.n_columns = this.label_x + 15;
    }

    private void compileFieldIndexArray() {
        this.n_fields = this.microRom.getNumberOfFields();
        int n = this.n_chars_per_addr + 2;
        this.field_x = new int[this.n_fields + 1];
        for (int i = 0; i < this.n_fields; ++i) {
            if (this.microRom.isSeparator(i)) {
                n += 2;
            }
            this.field_x[i] = n;
            n += this.getFieldChars(i) + 1;
        }
        this.field_x[this.n_fields] = n + 2;
        this.label_x = this.field_x[this.n_fields];
    }

    int getFieldStartPixelX(int n) {
        return this.border_width + this.field_x[n] * this.char_width;
    }

    private int getLabelStartX() {
        return this.border_width + this.field_x[this.field_x.length - 1] * this.char_width;
    }

    private int getFieldChars(int n) {
        return Math.max(1, this.microRom.getFieldBits(n) / 4);
    }

    @Override
    public void prepareGUI() {
        this.activeDataColor = SetupManager.getColor("Hades.MemoryHexEditorField.ActiveDataColor", Color.yellow);
        this.passiveDataColor = SetupManager.getColor("Hades.MemoryHexEditorField.PassiveDataColor", Color.blue);
        super.prepareGUI();
    }

    @Override
    public void init() {
        super.prepareGUI();
        this.prepareGUI();
        this.initialized = true;
    }

    @Override
    public void setTextFont(Font font) {
        this.textFont = font;
        FontMetrics fontMetrics = this.getFontMetrics(this.textFont);
        this.char_width = fontMetrics.charWidth('M');
        this.char_height = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.baseline = fontMetrics.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.n_rows = this.microRom.getSize();
        this.n_words = this.microRom.getSize();
        this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.x0_addr = this.border_width;
        this.x0_data = this.x0_addr + (this.n_chars_per_addr + 2) * this.char_width;
        this.y0_data = this.y0_addr = this.border_height + this.baseline;
    }

    @Override
    public void paintAllAddresses(Graphics graphics) {
        super.paintAllAddresses(graphics);
    }

    @Override
    public void paintAllData(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = n = (rectangle.y - this.border_height) / this.char_height;
        int n3 = rectangle.y + rectangle.height + this.char_height;
        int n4 = this.y0_data + n * this.char_height;
        graphics.setColor(this.getDataColor());
        graphics.setFont(this.textFont);
        for (int i = n; i < this.n_rows; ++i) {
            graphics.setColor(this.getAddrColor());
            for (int j = 0; j < this.n_fields; ++j) {
                int n5 = this.microRom.getData(n2, j);
                int n6 = this.getFieldStartPixelX(j);
                String string = HexFormat.getHexStringOrX(n5, this.getFieldChars(j));
                if (n2 == this.getReadHightlightAddress()) {
                    graphics.setColor(this.getReadHightlightColor());
                } else if (this.microRom.isDefaultValue(n2, j)) {
                    graphics.setColor(this.passiveDataColor);
                } else {
                    graphics.setColor(this.activeDataColor);
                }
                graphics.drawString(string, n6, n4);
            }
            graphics.setColor(this.getAddrColor());
            graphics.drawString(this.microRom.getStateLabel(n2), this.getLabelStartX(), n4);
            ++n2;
            if ((n4 += this.char_height) > n3) break;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.checkInit();
        this.paintBackgroundAndBorder(graphics);
        this.paintAllAddresses(graphics);
        this.paintAllData(graphics);
        this.paintCursor(graphics);
        graphics.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        this.checkInit();
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        this.checkInit();
        return new Dimension(this.width, this.height);
    }

    @Override
    public int getAddrFromCursorPosition() {
        return this.cursor_y;
    }

    private int getAddrFromY(int n) {
        int n2 = (n - this.border_height) / this.char_height;
        return n2;
    }

    private int getFieldFromX(int n) {
        return this.getFieldFromCharIndex((n - this.border_width) / this.char_width);
    }

    private int getFieldFromCharIndex(int n) {
        for (int i = 0; i < this.n_fields; ++i) {
            if (n < this.field_x[i] || n > this.field_x[i] + this.getFieldChars(i)) continue;
            return i;
        }
        return -1;
    }

    private int getFieldFromCursorPosition() {
        return this.getFieldFromCharIndex(this.getCursor_x());
    }

    @Override
    public boolean isCursorInDataArea() {
        return this.getCursor_x() >= this.n_chars_per_addr + 2 && this.getCursor_x() < this.label_x;
    }

    @Override
    public void paintCursor(Graphics graphics) {
        int n = this.border_width;
        int n2 = this.border_height + this.baseline;
        if (this.cursorDataColor) {
            graphics.setColor(this.dataColor);
        } else {
            graphics.setColor(this.backgroundColor);
        }
        graphics.setFont(this.textFont);
        if (this.insertMode & this.isCursorInLabelArea()) {
            graphics.drawLine(n + this.cursor_x * this.char_width, n2 + this.cursor_y * this.char_height + 1, n + this.cursor_x * this.char_width, n2 + (this.cursor_y - 1) * this.char_height + 6);
        } else {
            graphics.drawString("_", n + this.cursor_x * this.char_width, n2 + this.cursor_y * this.char_height);
        }
    }

    private boolean isCursorInLabelArea() {
        return this.getCursor_x() >= this.label_x;
    }

    @Override
    public void moveTabNext() {
        int n = this.getFieldFromCursorPosition();
        if (n < this.n_fields) {
            this.moveCursorTo(this.field_x[n + 1], this.getCursor_y());
        }
        this.shiftMode = false;
    }

    @Override
    public void moveTabPrev() {
        int n = this.getFieldFromCursorPosition();
        if (n > 0) {
            this.moveCursorTo(this.field_x[n - 1], this.getCursor_y());
        }
        this.shiftMode = false;
    }

    private void checkToggleSingleBitField(int n, int n2) {
        if (n2 < 0) {
            return;
        }
        if (this.microRom.getFieldBits(n2) == 1) {
            int n3 = this.microRom.getData(n, n2);
            int n4 = n3 == 1 ? 0 : 1;
            this.microRom.setData(n, n2, n4);
            this.modified = true;
        }
    }

    @Override
    public void incrementValue() {
        if (!this.isCursorInDataArea()) {
            MRCanvas.msg("-W- incrementValue: cursor not in data area!");
            return;
        }
        int n = this.getAddrFromCursorPosition();
        int n2 = this.getFieldFromCursorPosition();
        int n3 = this.microRom.getData(n, n2);
        this.microRom.setData(n, n2, n3 + 1);
        this.modified = true;
    }

    @Override
    public void decrementValue() {
        if (!this.isCursorInDataArea()) {
            MRCanvas.msg("-W- incrementValue: cursor not in data area!");
            return;
        }
        int n = this.getAddrFromCursorPosition();
        int n2 = this.getFieldFromCursorPosition();
        int n3 = this.microRom.getData(n, n2);
        this.microRom.setData(n, n2, n3 - 1);
        this.modified = true;
    }

    @Override
    public void insertDigitAtMousePosition(char c) {
        int n = this.getAddrFromCursorPosition();
        int n2 = this.getFieldFromCursorPosition();
        if (this.isCursorInAddrArea()) {
            if (!MRCanvas.isHexDigit(c)) {
                return;
            }
            this.editStartAddress(c);
            return;
        }
        if (this.isCursorInLabelArea()) {
            return;
        }
        if (!this.isCursorInDataArea()) {
            MRCanvas.msg("-E- Internal in insertDigitAtMousePosition: not in data area!");
            return;
        }
        if (!MRCanvas.isHexDigit(c)) {
            return;
        }
        if (n2 >= 0 && n2 < this.n_fields) {
            int n3 = this.microRom.getData(n, n2);
            int n4 = this.getCursor_x() - this.field_x[n2];
            if (n4 >= this.getFieldChars(n2)) {
                MRCanvas.msg("-W- no editable field at that position: " + this.getCursor_x());
                return;
            }
            String string = HexFormat.getHexStringOrX(n3, this.getFieldChars(n2));
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!this.shiftMode) {
                stringBuffer.setCharAt(n4, c);
                if (n4 == this.getFieldChars(n2)) {
                    this.shiftMode = true;
                } else {
                    this.moveCursorRight();
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.setCharAt(i, string.charAt(i + 1));
                }
                stringBuffer.setCharAt(n4, c);
            }
            try {
                n3 = Integer.parseInt(stringBuffer.toString(), 16);
            }
            catch (Exception exception) {
                n3 = 0;
            }
            this.microRom.setData(n, n2, n3);
            this.modified = true;
        }
    }

    private void editLabel(char c) {
        int n = this.getAddrFromCursorPosition();
        int n2 = this.getCursor_x() - this.label_x;
        StringBuffer stringBuffer = new StringBuffer(this.microRom.getStateLabel(n));
        if (Character.isLetterOrDigit(c) || c == ' ' || c == '_' || c == '.' || c == '=' || c == '\b') {
            if (c == '\b') {
                if (n2 > 0 && n2 <= stringBuffer.length()) {
                    stringBuffer.deleteCharAt(n2 - 1);
                }
                if (n2 > 0) {
                    int n3 = this.clip(this.getCursor_x() + 1, this.label_x, this.n_columns - 1);
                    this.moveCursorTo(n3 - 2, this.getCursor_y());
                }
            } else {
                while (stringBuffer.length() <= n2) {
                    stringBuffer.append(' ');
                }
                if (this.insertMode) {
                    stringBuffer.insert(n2, c);
                } else {
                    stringBuffer.setCharAt(n2, c);
                }
                int n4 = this.clip(this.getCursor_x() + 1, this.label_x, this.n_columns - 1);
                this.moveCursorTo(n4, this.getCursor_y());
            }
            this.microRom.setStateLabel(n, stringBuffer.toString());
            this.modified = true;
        } else {
            MRCanvas.msg("-W- MRCanvas.editLabel: non-letter character ignored!");
            MRCanvas.msg("-W- keeping current label '" + stringBuffer + "'");
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.setCursorFromMousePosition(mouseEvent);
        int n = this.getAddrFromCursorPosition();
        int n2 = this.getFieldFromCursorPosition();
        if (mouseEvent.getClickCount() >= 2) {
            this.checkToggleSingleBitField(n, n2);
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.isCursorInLabelArea()) {
            this.editLabel(keyEvent.getKeyChar());
        }
    }

    @Override
    public String getToolTip(Point point, long l) {
        int n = this.getAddrFromY(point.y);
        int n2 = this.getFieldFromX(point.x);
        String string = "uROM [" + HexFormat.getHexString(n, 4) + "] state: " + this.microRom.getStateLabel(n);
        if (n2 >= 0) {
            string = string + "\n" + "field: " + this.microRom.getFieldName(n2) + " value: " + HexFormat.getHexString(this.microRom.getData(n, n2), this.getFieldChars(n2));
        }
        return string;
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        MRCanvas.msg("-I- MRCanvas selftest started...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        CloseableFrame closeableFrame = new CloseableFrame();
        closeableFrame.setSize(100, 100);
        closeableFrame.setVisible(true);
        MRCanvas mRCanvas = new MRCanvas(new MR(), 1);
        mRCanvas.addMouseListener(mRCanvas);
        closeableFrame.add("Center", mRCanvas);
        closeableFrame.pack();
        ToolTipManager toolTipManager = new ToolTipManager((Component)mRCanvas, mRCanvas, 1000L);
        toolTipManager.setEnabled(true);
    }

    @Override
    public int getColumns() {
        return this.n_columns;
    }

    @Override
    public int getRows() {
        return this.n_rows;
    }

    @Override
    public int getAddrAreaEnd() {
        return this.n_chars_per_addr;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (n == 39) {
                this.moveCursorRight();
            } else if (n == 37) {
                this.moveCursorLeft();
            } else if (n == 38) {
                if (keyEvent.isShiftDown()) {
                    this.incrementValue();
                } else {
                    this.moveCursorUp();
                }
            } else if (n == 40) {
                if (keyEvent.isShiftDown()) {
                    this.decrementValue();
                } else {
                    this.moveCursorDown();
                }
            } else if (n == 36) {
                this.moveHome();
            } else if (n == 35) {
                this.moveEnd();
            } else if (n == 155) {
                this.insertMode = !this.insertMode;
            }
        } else if (c == '\t') {
            if (keyEvent.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else if (c == ' ') {
            if (!this.isCursorInLabelArea()) {
                if (keyEvent.isShiftDown()) {
                    this.moveTabPrev();
                } else {
                    this.moveTabNext();
                }
            }
        } else if (c == 'I') {
            this.insertNewWordAtMousePosition();
        } else {
            this.insertDigitAtMousePosition(c);
        }
        this.repaint();
    }
}

