/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class DPRAM
extends GenericMemory {
    protected PortStdLogicVector port_A0;
    protected PortStdLogicVector port_A1;
    protected PortStdLogicVector port_DI0;
    protected PortStdLogicVector port_DO0;
    protected PortStdLogicVector port_DO1;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;

    public DPRAM() {
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_A0 = new PortStdLogicVector((SimObject)this, "A0", 0, null, this.getAddressBusWidth());
        this.port_A1 = new PortStdLogicVector((SimObject)this, "A1", 0, null, this.getAddressBusWidth());
        this.port_DI0 = new PortStdLogicVector((SimObject)this, "DI0", 0, null, this.n_bits);
        this.port_DO0 = new PortStdLogicVector((SimObject)this, "DO0", 1, null, this.n_bits);
        this.port_DO1 = new PortStdLogicVector((SimObject)this, "DO1", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.ports = new Port[7];
        this.ports[0] = this.port_A0;
        this.ports[1] = this.port_A1;
        this.ports[2] = this.port_DI0;
        this.ports[3] = this.port_DO0;
        this.ports[4] = this.port_DO1;
        this.ports[5] = this.port_nWE;
        this.ports[6] = this.port_nCS;
    }

    public boolean canChangeSize() {
        return !this.isConnected();
    }

    public void setSize(int n_words) {
        this.resize(n_words, this.getBitsPerWord());
    }

    public void setBitsPerWord(int n_bits) {
        this.resize(this.getSize(), n_bits);
    }

    public boolean resize(int n_words, int n_bits) {
        this.n_words = n_words;
        this.n_bits = n_bits;
        this.data = new long[n_words];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        if (this.port_DO0.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DO0.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DO0));
        }
        if (this.port_DO1.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DO1.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DO1));
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A0 = this.port_A0.getVectorOrUUU();
        StdLogicVector vector_A1 = this.port_A1.getVectorOrUUU();
        StdLogicVector vector_DI0 = this.port_DI0.getVectorOrUUU();
        StdLogicVector vector_DO0 = null;
        StdLogicVector vector_DO1 = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        int addr0 = 0;
        int addr1 = 0;
        long data0 = 0L;
        long old_data0 = 0L;
        long data1 = 0L;
        if (value_nCS.is_1()) {
            vector_DO0 = this.vector_ZZZ.copy();
            vector_DO1 = this.vector_ZZZ.copy();
        } else if (!value_nCS.is_0()) {
            vector_DO0 = this.vector_UUU.copy();
            vector_DO1 = this.vector_UUU.copy();
            if (!value_nWE.is_1()) {
                this.message("-E- DPRAM.evaluate(): write enable active but chip select undefined: data would be lost. Ignored!");
            }
        } else {
            if (vector_A1.has_UXZ()) {
                vector_DO1 = this.vector_UUU.copy();
            } else {
                addr1 = (int)vector_A1.getValue();
                data1 = this.getDataAt(addr1);
                vector_DO1 = new StdLogicVector(this.n_bits, data1);
            }
            if (value_nWE.is_1()) {
                if (vector_A0.has_UXZ()) {
                    vector_DO0 = this.vector_UUU.copy();
                } else {
                    addr0 = (int)vector_A0.getValue();
                    data0 = this.getDataAt(addr0);
                    vector_DO0 = new StdLogicVector(this.n_bits, data0);
                    this.notifyReadListeners(addr0, data0);
                }
            } else if (value_nWE.is_0()) {
                if (vector_A0.has_UXZ()) {
                    this.message("-E- DPRAM.evaluate(): write enable active but address undefined: data would be lost. Ignored!");
                    vector_DO0 = this.vector_UUU.copy();
                } else if (vector_DI0.has_UXZ()) {
                    this.message("-E- DPRAM.evaluate(): write enable active but data input undefined: data would be lost. Ignored!");
                    vector_DO0 = this.vector_UUU.copy();
                } else {
                    addr0 = (int)vector_A0.getValue();
                    data0 = vector_DI0.getValue();
                    old_data0 = this.getDataAt(addr0);
                    this.setDataAt(addr0, data0);
                    this.notifyWriteListeners(addr0, old_data0, data0);
                    vector_DO0 = new StdLogicVector(this.n_bits, data0);
                }
            } else {
                this.message("-E- DPRAM.evaluate(): write enable undefined: data would be lost. Ignored!");
                vector_DO0 = this.vector_UUU.copy();
            }
        }
        Signal signal_DO0 = this.port_DO0.getSignal();
        Signal signal_DO1 = this.port_DO1.getSignal();
        if (signal_DO0 != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DO0, time, vector_DO0, this.port_DO0));
        }
        if (signal_DO1 != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DO1, time, vector_DO1, this.port_DO1));
        }
    }
}

