/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.logic.GenericOnebitLogicObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class AddressDecoder4
extends GenericOnebitLogicObject {
    protected PortStdLogicVector port_A;
    protected PortStdLogic1164 port_nCS0;
    protected PortStdLogic1164 port_nCS1;
    protected PortStdLogic1164 port_nCS2;
    protected PortStdLogic1164 port_nCS3;
    protected StdLogicVector value_A;
    protected int _0 = 2;
    protected int _1 = 3;
    protected int _X = 1;
    protected StdLogic1164 _nCS0 = new StdLogic1164();
    protected StdLogic1164 _nCS1 = new StdLogic1164();
    protected StdLogic1164 _nCS2 = new StdLogic1164();
    protected StdLogic1164 _nCS3 = new StdLogic1164();
    protected int base0;
    protected int limit0;
    protected int base1;
    protected int limit1;
    protected int base2;
    protected int limit2;
    protected int base3;
    protected int limit3;

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_nCS0 = new PortStdLogic1164(this, "nCS0", 1, null);
        this.port_nCS1 = new PortStdLogic1164(this, "nCS1", 1, null);
        this.port_nCS2 = new PortStdLogic1164(this, "nCS2", 1, null);
        this.port_nCS3 = new PortStdLogic1164(this, "nCS3", 1, null);
        this.ports = new Port[5];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_nCS0;
        this.ports[2] = this.port_nCS1;
        this.ports[3] = this.port_nCS2;
        this.ports[4] = this.port_nCS3;
    }

    public String getFormattedBase0() {
        return this.format(this.base0);
    }

    public String getFormattedBase1() {
        return this.format(this.base1);
    }

    public String getFormattedBase2() {
        return this.format(this.base2);
    }

    public String getFormattedBase3() {
        return this.format(this.base3);
    }

    public void setFormattedBase0(String s) {
        this.base0 = this.parse(s);
    }

    public void setFormattedBase1(String s) {
        this.base1 = this.parse(s);
    }

    public void setFormattedBase2(String s) {
        this.base2 = this.parse(s);
    }

    public void setFormattedBase3(String s) {
        this.base3 = this.parse(s);
    }

    public String getFormattedLimit0() {
        return this.format(this.limit0);
    }

    public String getFormattedLimit1() {
        return this.format(this.limit1);
    }

    public String getFormattedLimit2() {
        return this.format(this.limit2);
    }

    public String getFormattedLimit3() {
        return this.format(this.limit3);
    }

    public void setFormattedLimit0(String s) {
        this.limit0 = this.parse(s);
    }

    public void setFormattedLimit1(String s) {
        this.limit1 = this.parse(s);
    }

    public void setFormattedLimit2(String s) {
        this.limit2 = this.parse(s);
    }

    public void setFormattedLimit3(String s) {
        this.limit3 = this.parse(s);
    }

    public int parse(String s) {
        StdLogicVector tmp = new StdLogicVector(this.n_bits);
        tmp.parse(s);
        return (int)tmp.getValue();
    }

    public String format(int addr) {
        StdLogicVector tmp = new StdLogicVector(this.n_bits, addr);
        return tmp.toHexString();
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.base0 + " " + this.limit0 + " " + this.base1 + " " + this.limit1 + " " + this.base2 + " " + this.limit2 + " " + this.base3 + " " + this.limit3);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
            this.base0 = Integer.parseInt(st.nextToken());
            this.limit0 = Integer.parseInt(st.nextToken());
            this.base1 = Integer.parseInt(st.nextToken());
            this.limit1 = Integer.parseInt(st.nextToken());
            this.base2 = Integer.parseInt(st.nextToken());
            this.limit2 = Integer.parseInt(st.nextToken());
            this.base3 = Integer.parseInt(st.nextToken());
            this.limit3 = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.simulator = this.parent.getSimulator();
        StdLogicVector value_A = this.port_A.getVectorOrUUU();
        long addr = value_A.getValue();
        double time = this.simulator.getSimTime() + this.delay;
        if (value_A.has_UXZ()) {
            this._nCS0.setIntValue(this._X);
            this._nCS1.setIntValue(this._X);
            this._nCS2.setIntValue(this._X);
            this._nCS3.setIntValue(this._X);
        } else {
            this._nCS0.setIntValue(addr >= (long)this.base0 && addr <= (long)this.limit0 ? this._0 : this._1);
            this._nCS1.setIntValue(addr >= (long)this.base1 && addr <= (long)this.limit1 ? this._0 : this._1);
            this._nCS2.setIntValue(addr >= (long)this.base2 && addr <= (long)this.limit2 ? this._0 : this._1);
            this._nCS3.setIntValue(addr >= (long)this.base3 && addr <= (long)this.limit3 ? this._0 : this._1);
        }
        this.setOutput(this.port_nCS0, this._nCS0, time);
        this.setOutput(this.port_nCS1, this._nCS1, time);
        this.setOutput(this.port_nCS2, this._nCS2, time);
        this.setOutput(this.port_nCS3, this._nCS3, time);
    }

    public void setOutput(Port port, StdLogic1164 value, double time) {
        Signal signal = null;
        signal = port.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, time, value, port));
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "#bits [1 .. 32]:", "width", "output delay [sec]:", "delay", "base  0 ", "formattedBase0", "limit 0 ", "formattedLimit0", "base  1 ", "formattedBase1", "limit 1 ", "formattedLimit1", "base  2 ", "formattedBase2", "limit 2 ", "formattedLimit2", "base  3 ", "formattedBase3", "limit 3 ", "formattedLimit3"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand four address ranges, where base in \nis inclusive and limit inclusive \n");
        this.propertySheet.enableUpdateButton(true);
        this.propertySheet.pack();
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "addr<" + (this.n_bits - 1) + ":0>= " + this.port_A.getVectorOrUUU().toHexString() + "\n" + "nCS0 [" + this.getFormattedBase0() + ":" + this.getFormattedLimit0() + "]\n" + "nCS1 [" + this.getFormattedBase1() + ":" + this.getFormattedLimit1() + "]\n" + "nCS2 [" + this.getFormattedBase2() + ":" + this.getFormattedLimit2() + "]\n" + "nCS3 [" + this.getFormattedBase3() + ":" + this.getFormattedLimit3() + "]\n";
    }
}

