/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class Merge3
extends GenericRtlibObject {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_B;
    protected PortStdLogicVector port_C;
    protected PortStdLogicVector port_Y;
    protected Label mergeLabel;
    protected int upper = 8;
    protected int middle = 8;
    protected int lower = 8;
    protected int n_bits = this.upper + this.middle + this.lower;

    public void constructPorts() {
        this.setBounds();
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.upper);
        this.port_B = new PortStdLogicVector((SimObject)this, "B", 0, null, this.middle);
        this.port_C = new PortStdLogicVector((SimObject)this, "C", 0, null, this.lower);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.ports = new Port[4];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_B;
        this.ports[2] = this.port_C;
        this.ports[3] = this.port_Y;
        this.vector = new StdLogicVector(this.n_bits);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.mergeLabel = new Label();
        this.mergeLabel.initialize("0 450 2 <8+8+8>");
        this.symbol.addMember(this.mergeLabel);
        this.symbol.update_bbox();
    }

    public int getUpper() {
        return this.upper;
    }

    public int getMiddle() {
        return this.middle;
    }

    public int getLower() {
        return this.lower;
    }

    public void setUpper(String s) {
        try {
            this.upper = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.upper = 8;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    public void setMiddle(String s) {
        try {
            this.middle = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.middle = 8;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    public void setLower(String s) {
        try {
            this.lower = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.lower = 8;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    private void setBounds() {
        if (this.lower < 1) {
            this.lower = 1;
        }
        if (this.middle < 1) {
            this.middle = 1;
        }
        if (this.upper < 1) {
            this.upper = 1;
        }
        if (this.lower + this.middle + this.upper > 32) {
            this.message("-E- illegal bus widths: resetting to 8/8/8!");
            this.upper = 8;
            this.middle = 8;
            this.lower = 8;
        }
        this.n_bits = this.upper + this.middle + this.lower;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_B = this.port_B.getVectorOrUUU();
        StdLogicVector vector_C = this.port_C.getVectorOrUUU();
        this.vector = StdLogicVector.concat(vector_A, StdLogicVector.concat(vector_B, vector_C));
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        Signal signal_Y = null;
        signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void updateSymbol() {
        if (this.mergeLabel != null) {
            this.mergeLabel.setText("<" + this.upper + "+" + this.middle + "+" + this.lower + ">");
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.upper + " " + this.middle + " " + this.lower + " " + this.vector.toBinString() + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.upper = Integer.parseInt(st.nextToken());
            this.middle = Integer.parseInt(st.nextToken());
            this.lower = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setValue(st.nextToken());
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output value    [00..0X10_b]:", "value", "output delay           [sec]:", "delay", "n_bits upper  [30..1]:", "upper", "n_bits middle [30..1]:", "middle", "n_bits lower  [30..1]:", "lower"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\nand the upper and lower subset indices");
        this.propertySheet.setVisible(true);
    }
}

