/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class Merge
extends GenericRtlibObject {
    protected Port port_A;
    protected Port port_B;
    protected Port port_Y;
    protected Label mergeLabel;
    protected int upper = 8;
    protected int lower = 8;
    protected int n_bits = this.upper + this.lower;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;

    public void constructPorts() {
        this.setBounds();
        this.ports = new Port[3];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Merge.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.upper));
        this.ports[1] = new Port(this, "B", 0, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Merge.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.lower));
        this.ports[2] = new Port(this, "Y", 1, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Merge.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.port_A = this.ports[0];
        this.port_B = this.ports[1];
        this.port_Y = this.ports[2];
        this.vector = new StdLogicVector(this.n_bits);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.mergeLabel = new Label();
        this.mergeLabel.initialize("0 450 2 <8+8>");
        this.symbol.addMember(this.mergeLabel);
        this.symbol.update_bbox();
    }

    public int getUpper() {
        return this.upper;
    }

    public int getLower() {
        return this.lower;
    }

    public void setUpper(String s) {
        try {
            this.upper = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.upper = 8;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    public void setLower(String s) {
        try {
            this.lower = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.lower = 8;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    private void setBounds() {
        if (this.lower < 1) {
            this.lower = 1;
        }
        if (this.lower >= this.n_bits) {
            this.lower = this.n_bits - 1;
        }
        if (this.upper < 1) {
            this.upper = 1;
        }
        if (this.upper + this.lower >= 32) {
            this.upper = this.n_bits - this.lower;
        }
        this.n_bits = this.upper + this.lower;
    }

    public void evaluate(Object arg) {
        Signal signal_A;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogicVector vector_A = (signal_A = this.port_A.getSignal()) == null ? new StdLogicVector(this.upper) : (StdLogicVector)signal_A.getValue();
        Signal signal_B = this.port_B.getSignal();
        StdLogicVector vector_B = signal_B == null ? new StdLogicVector(this.upper) : (StdLogicVector)signal_B.getValue();
        this.vector = StdLogicVector.concat(vector_A, vector_B);
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void updateSymbol() {
        if (this.mergeLabel != null) {
            this.mergeLabel.setText("<" + this.upper + "+" + this.lower + ">");
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.upper + " " + this.lower + " " + this.vector.toBinString() + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.upper = Integer.parseInt(st.nextToken());
            this.lower = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setValue(st.nextToken());
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output value    [00..0X10_b]:", "value", "output delay           [sec]:", "delay", "n_bits upper [31..lower]:", "upper", "n_bits lower [upper..1]:", "lower"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\nand the upper and lower subset indices");
        this.propertySheet.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

