/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.models.StdLogicVector;
import hades.models.rtlib.io.Expander;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.BboxRectangle;
import hades.symbols.BusPortSymbol;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import java.awt.Point;

public class ExpanderVertical
extends Expander {
    public boolean needsDynamicSymbol() {
        return true;
    }

    public void initDisplay() {
        PortLabel portLabel;
        int y;
        int x;
        PortSymbol portSymbol;
        if (SimObject.debug) {
            this.message("-#- ExpanderVertical.initDisplay...");
        }
        if (this.symbol == null) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.deleteAllMembers();
        }
        Point pos = this.symbol.getPos();
        this.symbol.move(-pos.x, -pos.y);
        BboxRectangle bbr = new BboxRectangle();
        int w = 600;
        int ymax = (1 + this.n_bits) * w;
        bbr.initialize(" 0 0 1200 " + ymax);
        Rectangle rr = new Rectangle();
        rr.initialize("  0 0 1200 " + ymax);
        InstanceLabel il = new InstanceLabel();
        il.initialize(" 1250 450 " + this.getName());
        ClassLabel cl = new ClassLabel();
        cl.initialize("1250 " + (ymax - 150) + " ExpanderVertical");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(bbr);
        this.symbol.fastAddMember(rr);
        this.symbol.fastAddMember(il);
        int i = 0;
        while (i < this.n_bits) {
            portSymbol = new PortSymbol();
            x = 1200;
            y = (this.n_bits - i) * w;
            portSymbol.initialize("" + x + " " + y + " Y" + i);
            this.symbol.fastAddMember(portSymbol);
            portLabel = new PortLabel();
            portLabel.initialize("1050 " + (y - 150) + " 3 Y" + i);
            this.symbol.fastAddMember(portLabel);
            ++i;
        }
        portSymbol = new BusPortSymbol();
        x = 600;
        y = 0;
        portSymbol.initialize("" + x + " " + y + " A");
        this.symbol.fastAddMember(portSymbol);
        portLabel = new PortLabel();
        portLabel.initialize("" + x + " " + 450 + " 2 A");
        this.symbol.fastAddMember(portLabel);
        this.symbol.update_bbox();
        this.symbol.build_sc_bbox();
        this.symbol.setTrafo(this.symbol.getTrafo());
        this.symbol.setObjectPainter(this.symbol.painter);
        this.symbol.move(pos.x, pos.y);
    }

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || this.n_bits > 32) {
            this.message("-E- Bus width out of range [1..32], using 16 instead!");
            this.n_bits = 16;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.initDisplay();
        this.updateSymbol();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        int i = 0;
        while (i < this.n_bits) {
            Port port_i = this.ports[1 + i];
            Signal signal_i = port_i.getSignal();
            if (signal_i != null) {
                simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_i, time, vector_A.getBitAt(i), (Object)port_i));
            }
            ++i;
        }
    }

    public void updateSymbol() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 1);
    }
}

