/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.WakeupEvent;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ColoredRectangle;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class Constant
extends GenericRtlibObject {
    protected Port port_Y;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;

    public void constructPorts() {
        this.ports = new Port[1];
        this.ports[0] = new Port(this, "Y", 1, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Constant.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.port_Y = this.ports[0];
    }

    protected void initValueLabel() {
        super.initValueLabel();
        this.valueLabel.setTextSource(new GenericRtlibObject.DecimalValueLabelFormatter());
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.updateSymbol();
        if (this.simulator != null) {
            this.evaluate(null);
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleWakeup(this, time, this);
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("IpinVector mousePressed!, value=" + this.vector);
        }
        long maxint = this.vector.getBitMask();
        long value = this.vector.getValue();
        value = me.isShiftDown() ? (value == 0L ? -2L : (value == -2L ? -1L : (value == -1L ? -3L : (value == -3L ? maxint : --value)))) : (value == -2L ? 0L : (value == -1L ? -2L : (value == -3L ? -1L : (value == maxint ? -3L : ++value))));
        this.vector = new StdLogicVector(this.n_bits, value);
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleInteractiveEvent(new WakeupEvent(this, time, (Object)this));
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleInteractiveEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        if (this.valueLabel == null) {
            this.initValueLabel();
            if (this.valueLabel == null) {
                return;
            }
        }
        int intValue = (int)this.vector.getValue();
        Color color = Color_DIN_IEC_62.getColor(intValue);
        this.valueLabel.setColor(color);
        this.valueLabel.setText("" + intValue);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (!(tmp instanceof ColoredRectangle)) continue;
            ((ColoredRectangle)tmp).setColor(color);
        }
        this.symbol.painter.paint(this.symbol, 1);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

