/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.arith;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.utils.ExceptionTracer;

public class UserDefinedALU
extends GenericRtlibObject {
    protected PortStdLogicVector port_OPC;
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_B;
    protected PortStdLogicVector port_Y;
    protected PortStdLogic1164 port_Cin;
    protected PortStdLogic1164 port_Cout;
    protected PortStdLogic1164 port_ZERO;
    protected PortStdLogic1164 port_NEG;
    protected PortStdLogic1164 port_EQ;
    protected PortStdLogic1164 port_OVF;
    protected StdLogicVector vector_Y;
    protected StdLogic1164 value_Cout;
    protected StdLogic1164 value_ZERO;
    protected StdLogic1164 value_NEG;
    protected StdLogic1164 value_EQ;
    protected StdLogic1164 value_OVF;
    public int n_operations = 16;
    protected int[] opcodeArray;
    protected int currentOpcode = 0;
    public final StdLogic1164 ieee_U = Const1164.__U;
    public final StdLogic1164 ieee_0 = Const1164.__0;
    public final StdLogic1164 ieee_1 = Const1164.__1;
    public static final int CONST_0 = 0;
    public static final int CONST_1 = 1;
    public static final int CONST_FFFF = 2;
    public static final int PASS_A = 3;
    public static final int PASS_B = 4;
    public static final int INCR_A = 5;
    public static final int INCR_B = 6;
    public static final int DECR_A = 7;
    public static final int DECR_B = 8;
    public static final int ADD_AB = 9;
    public static final int ADD_AB1 = 10;
    public static final int ADD_ABCin = 11;
    public static final int SUB_AB = 12;
    public static final int NOT_A = 13;
    public static final int NOT_B = 14;
    public static final int AND_AB = 15;
    public static final int OR_AB = 16;
    public static final int XOR_AB = 17;
    public static final int XNOR_AB = 18;
    public static final int SHL_A = 19;
    public static final int SRL_A = 20;
    public static final int SRA_A = 21;
    public static final int ROL_A = 22;
    public static final int ROR_A = 23;
    public static final int ROL_AC = 24;
    public static final int ROR_AC = 25;
    String[] operationLabels = new String[]{"0", "1", "-1 (FFFF)", "A", "B", "incr A", "incr B", "decr A", "decr B", "A + B", "A + B + 1", "A + B + Cin", "A - B", "NOT A", "NOT B", "A AND B", "A OR B", "A XOR B", "A XNOR B", "SHL A, A << 1", "SRL A, A >> 1", "SRA A, A >>> 1", "ROL A", "ROR A", "ROL A and carry", "ROR A and carry"};
    protected ConfigDialog configDialog = null;

    public UserDefinedALU() {
        this.opcodeArray = new int[this.n_operations];
        int i = 0;
        while (i < this.n_operations) {
            this.opcodeArray[i] = i;
            ++i;
        }
    }

    public void constructPorts() {
        this.port_OPC = new PortStdLogicVector((SimObject)this, "OPC", 0, null, 4);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_B = new PortStdLogicVector((SimObject)this, "B", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.port_Cin = new PortStdLogic1164(this, "CIN", 0, null);
        this.port_Cout = new PortStdLogic1164(this, "COUT", 1, null);
        this.port_ZERO = new PortStdLogic1164(this, "ZERO", 1, null);
        this.port_NEG = new PortStdLogic1164(this, "NEG", 1, null);
        this.port_EQ = new PortStdLogic1164(this, "EQ", 1, null);
        this.port_OVF = new PortStdLogic1164(this, "OVF", 1, null);
        this.ports = new Port[10];
        this.ports[0] = this.port_OPC;
        this.ports[1] = this.port_A;
        this.ports[2] = this.port_B;
        this.ports[3] = this.port_Y;
        this.ports[4] = this.port_Cin;
        this.ports[5] = this.port_Cout;
        this.ports[6] = this.port_ZERO;
        this.ports[7] = this.port_NEG;
        this.ports[8] = this.port_EQ;
        this.ports[9] = this.port_OVF;
        this.vector_Y = new StdLogicVector(this.n_bits);
        this.value_Cout = new StdLogic1164();
        this.value_ZERO = new StdLogic1164();
        this.value_NEG = new StdLogic1164();
        this.value_EQ = new StdLogic1164();
        this.value_OVF = new StdLogic1164();
        this.vectorOutputPort = this.port_Y;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.opcodeArray.length);
        int i = 0;
        while (i < this.opcodeArray.length) {
            ps.print(" ");
            ps.print(this.opcodeArray[i]);
            ++i;
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
            int n_opcodes = Integer.parseInt(st.nextToken());
            this.opcodeArray = new int[n_opcodes];
            int i = 0;
            while (i < n_opcodes) {
                this.opcodeArray[i] = Integer.parseInt(st.nextToken());
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-E- Error initializing " + this.toString() + ", s=" + s);
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public SimObject copy() {
        UserDefinedALU tmp = null;
        try {
            tmp = (UserDefinedALU)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setWidth(this.getWidth());
            tmp.setValue(this.getValue());
            tmp.setDelay(this.getDelay());
            tmp.setVersionId(this.getVersionId());
            tmp.opcodeArray = new int[this.opcodeArray.length];
            int i = 0;
            while (i < this.opcodeArray.length) {
                tmp.opcodeArray[i] = this.opcodeArray[i];
                ++i;
            }
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in GenericRtlibObject.copy(): " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public void configure() {
        if (this.configDialog == null) {
            this.configDialog = new ConfigDialog();
        }
        this.configDialog.getFrame().setVisible(true);
    }

    public Component getPropertySheet() {
        if (this.configDialog != null) {
            return this.configDialog.getFrame();
        }
        return null;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        StdLogicVector vector_OPC = this.port_OPC.getVectorOrUUU();
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_B = this.port_B.getVectorOrUUU();
        StdLogic1164 value_Cin = this.port_Cin.getValueOrU();
        try {
            this.currentOpcode = this.decodeOpcode(vector_OPC);
            this.calculateOutput(vector_A, vector_B, value_Cin, this.currentOpcode);
            this.updateFlags(vector_A, vector_B);
            this.scheduleOutputsAndFlags();
        }
        catch (Exception e) {
            this.message("-E- internal in " + this.toString() + ".evaluate: " + e);
            this.message(" A,B,Cin,Y: " + vector_A + " " + vector_B + " " + value_Cin + " " + this.vector_Y);
            ExceptionTracer.trace(e);
        }
    }

    public int decodeOpcode(StdLogicVector OPC) {
        int tmp = (int)OPC.getValue();
        if (tmp < 0) {
            return tmp;
        }
        if (tmp > this.opcodeArray.length) {
            return -1;
        }
        return this.opcodeArray[tmp];
    }

    protected void updateFlags(StdLogicVector A, StdLogicVector B) {
        if (this.vector_Y.has_UXZ()) {
            this.value_ZERO = this.ieee_U.copy();
            this.value_NEG = this.ieee_U.copy();
            this.value_EQ = this.ieee_U.copy();
            this.value_OVF = this.ieee_U.copy();
            return;
        }
        this.value_ZERO = this.vector_Y.getValue() == 0L ? this.ieee_1.copy() : this.ieee_0.copy();
        this.value_NEG = this.vector_Y.getBitAt(this.n_bits - 1).is_1() ? this.ieee_1.copy() : this.ieee_0.copy();
        this.value_EQ = A.equals(B) ? this.ieee_1.copy() : this.ieee_0.copy();
        this.value_OVF = StdLogicVector.get2ComplementAddOverflow(A, B);
    }

    protected void scheduleOutputsAndFlags() {
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        this.schedule(simulator, time, (Port)this.port_Y, this.vector_Y);
        this.schedule(simulator, time, (Port)this.port_Cout, this.value_Cout);
        this.schedule(simulator, time, (Port)this.port_ZERO, this.value_ZERO);
        this.schedule(simulator, time, (Port)this.port_NEG, this.value_NEG);
        this.schedule(simulator, time, (Port)this.port_EQ, this.value_EQ);
        this.schedule(simulator, time, (Port)this.port_OVF, this.value_OVF);
    }

    void schedule(SimKernel simulator, double time, Port port, StdLogic1164 v) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, v, (Object)port));
    }

    void schedule(SimKernel simulator, double time, Port port, Object value) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(new SimEvent(signal, time, value, port));
    }

    protected void calculateOutput(StdLogicVector A, StdLogicVector B, StdLogic1164 Cin, int opcode) {
        int n_bits = this.vector_Y.getWidth();
        this.value_Cout = this.ieee_0.copy();
        try {
            switch (opcode) {
                case 0: {
                    this.vector_Y = new StdLogicVector(n_bits);
                    int i = 0;
                    while (i < n_bits) {
                        this.vector_Y.setBitAt(i, this.ieee_0);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    this.vector_Y = new StdLogicVector(n_bits);
                    int i = 1;
                    while (i < n_bits) {
                        this.vector_Y.setBitAt(i, this.ieee_0);
                        ++i;
                    }
                    this.vector_Y.setBitAt(0, this.ieee_1);
                    break;
                }
                case 2: {
                    this.vector_Y = new StdLogicVector(n_bits);
                    int i = 0;
                    while (i < n_bits) {
                        this.vector_Y.setBitAt(i, this.ieee_1);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    this.vector_Y = A.copy();
                    break;
                }
                case 4: {
                    this.vector_Y = B.copy();
                    break;
                }
                case 5: {
                    this.vector_Y = A.incr();
                    break;
                }
                case 6: {
                    this.vector_Y = B.incr();
                    break;
                }
                case 7: {
                    this.vector_Y = A.decr();
                    break;
                }
                case 8: {
                    this.vector_Y = B.decr();
                    break;
                }
                case 9: {
                    this.vector_Y = A.add(B);
                    break;
                }
                case 10: {
                    this.vector_Y = A.add(B).incr();
                    break;
                }
                case 11: {
                    if (Cin.is_1()) {
                        this.vector_Y = A.add(B).incr();
                        break;
                    }
                    if (Cin.is_0()) {
                        this.vector_Y = A.add(B);
                        break;
                    }
                    this.vector_Y = this.vector_UUU.copy();
                    break;
                }
                case 12: {
                    this.vector_Y = A.sub(B);
                    break;
                }
                case 13: {
                    this.vector_Y = A.invert_bitwise();
                    break;
                }
                case 14: {
                    this.vector_Y = B.invert_bitwise();
                    break;
                }
                case 15: {
                    this.vector_Y = A.and_bitwise(B);
                    break;
                }
                case 16: {
                    this.vector_Y = A.or_bitwise(B);
                    break;
                }
                case 17: {
                    this.vector_Y = A.xor_bitwise(B);
                    break;
                }
                case 18: {
                    this.vector_Y = A.xor_bitwise(B).invert_bitwise();
                    break;
                }
                case 19: {
                    this.vector_Y = A.shl(1);
                    break;
                }
                case 20: {
                    this.vector_Y = A.shr_logical(1);
                    break;
                }
                case 21: {
                    this.vector_Y = A.shr_arithmetical(1);
                    break;
                }
                case 22: {
                    this.vector_Y = A.rol(1);
                    break;
                }
                case 23: {
                    this.vector_Y = A.ror(1);
                    break;
                }
                case 24: {
                    this.value_Cout.setIntValue(A.getBitAt(n_bits - 1).intValue());
                    this.vector_Y = A.rol(1);
                    this.vector_Y.setBitAt(0, Cin.copy());
                    break;
                }
                case 25: {
                    this.value_Cout.setIntValue(A.getBitAt(0).intValue());
                    this.vector_Y = A.ror(1);
                    this.vector_Y.setBitAt(n_bits - 1, Cin.copy());
                    break;
                }
                default: {
                    this.message("-W- UserDefinedALU: undefined (open?) ALU opcode: " + opcode + ", ignored!");
                    this.vector_Y = this.vector_UUU.copy();
                    this.value_Cout = this.ieee_U.copy();
                }
            }
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + " internal error: " + e);
        }
        this.vector = this.vector_Y;
        if (this.vector_Y.has_UXZ()) {
            this.message("-W- UserDefinedALU: output has UXZ: " + this.vector_Y);
        }
    }

    public String getCurrentOpcodeName() {
        if (this.currentOpcode < 0) {
            return "UNDEFINED";
        }
        return this.operationLabels[this.currentOpcode];
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "operation: " + this.getCurrentOpcodeName() + "\n" + "value A:   " + this.port_A.getVectorOrUUU().toHexString() + "\n" + "value B:   " + this.port_B.getVectorOrUUU().toHexString() + "\n" + "value Cin: " + this.port_Cin.getValueOrU() + "\n" + "value Y:   " + this.vector.toHexString();
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        UserDefinedALU.msg("-I- UserDefinedALU selftest...");
        UserDefinedALU alu = new UserDefinedALU();
        alu.configure();
    }

    protected class ConfigDialog
    implements ActionListener {
        protected JFrame configFrame;
        protected JPanel textFieldsPanel;
        protected JPanel choicePanel;
        protected JPanel buttonPanel;
        protected JTextField nameTF;
        protected JTextField widthTF;
        protected JTextField delayTF;
        protected JButton okButton;
        protected JButton applyButton;
        protected JButton cancelButton;
        protected JComboBox[] operationChoice;

        public ConfigDialog() {
            this.configFrame = new JFrame("Configure: UserDefinedALU " + UserDefinedALU.this.getName());
            this.buildTextFieldsPanel();
            this.buildOpcodeChoicePanel();
            this.buildButtonPanel();
            this.configFrame.getContentPane().add("North", this.textFieldsPanel);
            this.configFrame.getContentPane().add("Center", this.choicePanel);
            this.configFrame.getContentPane().add("South", this.buttonPanel);
            this.configFrame.pack();
            this.configFrame.setVisible(true);
        }

        public Frame getFrame() {
            return this.configFrame;
        }

        protected void buildTextFieldsPanel() {
            this.nameTF = new JTextField(UserDefinedALU.this.getName(), 20);
            this.widthTF = new JTextField("" + UserDefinedALU.this.getWidth(), 10);
            this.delayTF = new JTextField("" + UserDefinedALU.this.getDelay(), 20);
            JPanel lpanel = new JPanel(new GridLayout(0, 1));
            lpanel.add(new JLabel(""));
            lpanel.add(new JLabel("instance name: ", 4));
            lpanel.add(new JLabel("bus width [1..32]: ", 4));
            lpanel.add(new JLabel("delay [sec.]: ", 4));
            lpanel.add(new JLabel(""));
            JPanel tfpanel = new JPanel(new GridLayout(0, 1));
            tfpanel.add(new JLabel(""));
            tfpanel.add(this.nameTF);
            tfpanel.add(this.widthTF);
            tfpanel.add(this.delayTF);
            tfpanel.add(new JLabel(""));
            this.textFieldsPanel = new JPanel();
            this.textFieldsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.textFieldsPanel.setLayout(new BorderLayout());
            this.textFieldsPanel.add("West", lpanel);
            this.textFieldsPanel.add("East", tfpanel);
        }

        protected void buildOpcodeChoicePanel() {
            this.choicePanel = new JPanel();
            this.choicePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.choicePanel.setLayout(new GridLayout(UserDefinedALU.this.n_operations / 2 + 2, 2));
            this.choicePanel.add(new JLabel("opcode index and operation: ", 4));
            this.choicePanel.add(new JLabel(""));
            this.operationChoice = new JComboBox[UserDefinedALU.this.n_operations];
            int j = 0;
            while (j < UserDefinedALU.this.n_operations) {
                JLabel tmp_label = new JLabel("  " + j + ":", 4);
                JPanel tmp_panel = new JPanel(new FlowLayout(2, 10, 0));
                JComboBox<String> tmp_choice = new JComboBox<String>();
                int i = 0;
                while (i < UserDefinedALU.this.operationLabels.length) {
                    tmp_choice.addItem(UserDefinedALU.this.operationLabels[i]);
                    ++i;
                }
                tmp_choice.setSelectedIndex(UserDefinedALU.this.opcodeArray[j]);
                this.operationChoice[j] = tmp_choice;
                tmp_panel.add(tmp_label);
                tmp_panel.add(tmp_choice);
                this.choicePanel.add(tmp_panel);
                ++j;
            }
            this.choicePanel.add(new JLabel(""));
            this.choicePanel.add(new JLabel(""));
        }

        protected void buildButtonPanel() {
            this.cancelButton = new JButton("Cancel");
            this.applyButton = new JButton("Apply");
            this.okButton = new JButton("OK");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.buttonPanel.setLayout(new FlowLayout(1));
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.applyButton);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(new JLabel(" "));
            this.cancelButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.okButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.cancelButton) {
                this.configFrame.setVisible(false);
            } else if (source == this.applyButton) {
                this.applyValues();
            } else if (source == this.okButton) {
                this.applyValues();
                this.configFrame.setVisible(false);
            } else {
                UserDefinedALU.msg("-E- unknown event source: " + evt);
            }
        }

        public void applyValues() {
            try {
                UserDefinedALU.this.setName(this.nameTF.getText());
                UserDefinedALU.this.setWidth(this.widthTF.getText());
                UserDefinedALU.this.setDelay(this.delayTF.getText());
                int i = 0;
                while (i < UserDefinedALU.this.opcodeArray.length) {
                    UserDefinedALU.this.opcodeArray[i] = this.operationChoice[i].getSelectedIndex();
                    ++i;
                }
            }
            catch (Exception e) {
                UserDefinedALU.this.message("-E- in " + UserDefinedALU.this.toString() + ".applyValues: " + e);
                ExceptionTracer.trace(e);
            }
            UserDefinedALU.this.evaluate(null);
        }
    }
}

