/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.arith;

import hades.gui.PropertySheet;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.FatLabel;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class GenericShifter
extends GenericRtlibObject {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_Y;
    protected StdLogicVector value_A;
    protected int shiftcount = 1;
    protected Label shiftLabel;

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_Y;
        this.vectorOutputPort = this.port_Y;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.shiftLabel = new FatLabel();
        this.shiftLabel.initialize("0 1300 2 shift");
        this.symbol.addMember(this.shiftLabel);
        this.symbol.update_bbox();
    }

    public void evaluate(Object arg) {
        this.message("-E- don't call evaluate on a generic shifter!");
    }

    public int getShiftcount() {
        return this.shiftcount;
    }

    public void setShiftcount(String s) {
        try {
            this.shiftcount = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.shiftcount = 1;
        }
        if (this.shiftcount < 0 || this.shiftcount > this.n_bits) {
            this.message("-W- Shiftcount out of range, resetting (1) !");
            this.shiftcount = 1;
        }
        this.updateSymbol();
    }

    public void updateSymbol() {
        if (this.enableAnimationFlag) {
            super.updateSymbol();
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.shiftcount + " " + this.vector.toBinString() + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.shiftcount = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output value    [00..0X10_b]:", "value", "output delay           [sec]:", "delay", "shiftcount [n_bits .. 1]:", "shiftcount"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value and the shift count\n");
        this.propertySheet.setVisible(true);
    }
}

