/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.HexFormat;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class CounterRE
extends GenericGate
implements Simulatable {
    protected int n_outputs = 0;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_NRESET;
    protected PortStdLogic1164 port_ENABLE;
    protected PortStdLogic1164 port_COUT;
    private int value = 0;
    private int limit = 0;

    public CounterRE(int n_outputs) {
        this.n_outputs = n_outputs;
        this.port_CLK = new PortStdLogic1164(this, "clk", 0, null);
        this.port_NRESET = new PortStdLogic1164(this, "nreset", 0, null);
        this.port_ENABLE = new PortStdLogic1164(this, "enable", 0, null);
        this.port_COUT = new PortStdLogic1164(this, "cout", 1, null);
        this.ports = new Port[n_outputs + 4];
        int i = 0;
        while (i < n_outputs) {
            this.ports[i] = new PortStdLogic1164(this, "Q" + i, 1, null);
            ++i;
        }
        this.ports[n_outputs] = this.port_CLK;
        this.ports[n_outputs + 1] = this.port_NRESET;
        this.ports[n_outputs + 2] = this.port_ENABLE;
        this.ports[n_outputs + 3] = this.port_COUT;
        this.t_delay = 1.0E-8;
        this.setLimit((1 << n_outputs) - 1);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.scheduleOutputs();
    }

    public void evaluate(Object arg) {
        Signal s_CLK = this.port_CLK.getSignal();
        StdLogic1164 value_CLK = this.port_CLK.getValueOrU();
        StdLogic1164 value_NR = this.port_NRESET.getValueOrU();
        if (!value_NR.is_1()) {
            this.setValue(0);
            this.scheduleOutputs();
        } else if (s_CLK != null && s_CLK.hasEvent() && value_CLK.is_1() && this.port_ENABLE.getValueOrU().is_1()) {
            ++this.value;
            if (this.value > this.limit) {
                this.value = 0;
            }
            this.scheduleOutputs();
        }
    }

    private void scheduleOutputs() {
        Const1164 next_QI = null;
        int value = this.getValue();
        int mask = 1;
        int i = 0;
        while (i < this.n_outputs) {
            Port port_QI = this.ports[i];
            next_QI = (value & mask) != 0 ? Const1164.__1 : Const1164.__0;
            this.scheduleOutputValueAfter(port_QI, next_QI, this.t_delay);
            mask <<= 1;
            ++i;
        }
        next_QI = value == this.limit ? Const1164.__1 : Const1164.__0;
        this.scheduleOutputValueAfter(this.port_COUT, next_QI, this.t_delay);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_delay + " " + this.value + " " + this.limit);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_delay = Double.valueOf(st.nextToken());
            this.setValue(Integer.parseInt(st.nextToken()));
            this.setLimit(Integer.parseInt(st.nextToken()));
        }
        catch (Exception e) {
            this.message("-E- CounterRE.initialize(): " + e + " " + s);
        }
        return true;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String s) {
        this.setValue(Integer.parseInt(s.trim(), 10));
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(String s) {
        this.setLimit(Integer.parseInt(s.trim(), 10));
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay", "limit [int]:", "limit", "value [int]:", "value"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value=" + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getValue(), 8) + "\n" + "limit=" + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getLimit(), 8);
    }

    public SimObject copy() {
        CounterRE clone = (CounterRE)super.copy();
        clone.setDelay(this.getDelay());
        clone.setLimit(this.getLimit());
        clone.setValue(0);
        return clone;
    }
}

