/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.pic.TurboPicCore;
import hades.models.pic.TurboPicGUI;
import hades.models.string.PortString;
import hades.signals.PortInteger;
import hades.signals.Signal;
import hades.simulator.EventList;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.utils.IntegerFormatter;
import hades.utils.NameMangler;
import hades.utils.TimeFormatter;
import java.awt.Component;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class TurboPic16C84
extends TurboPicCore
implements Wakeable {
    public PortStdLogic1164 portClkin;
    public PortStdLogic1164 portClkout;
    public PortStdLogic1164 portMclr;
    public PortStdLogic1164[] portA;
    public PortStdLogic1164[] portB;
    public PortInteger portPC;
    public PortInteger portW;
    public PortInteger portSTATUS;
    public PortInteger portINTCON;
    public PortString portINSTR;
    double clk4Period = 1.0E-6;
    double clk8Period = 2.0 * this.clk4Period;
    double t_now = 0.0;
    double t_portdelay = 2.0E-8;
    private TurboPicGUI GUI = null;
    private String programResourceName;
    static Integer[] _integerTable = new Integer[256];

    public TurboPic16C84() {
        this.createPorts();
        this.reset();
    }

    public void createPorts() {
        this.portClkin = new PortStdLogic1164(this, "CLKIN", 0, null);
        this.portClkout = new PortStdLogic1164(this, "CLKOUT", 1, null);
        this.portMclr = new PortStdLogic1164(this, "/MCLR", 0, null);
        this.portA = new PortStdLogic1164[5];
        this.portA[0] = new PortStdLogic1164(this, "A0", 2, null);
        this.portA[1] = new PortStdLogic1164(this, "A1", 2, null);
        this.portA[2] = new PortStdLogic1164(this, "A2", 2, null);
        this.portA[3] = new PortStdLogic1164(this, "A3", 2, null);
        this.portA[4] = new PortStdLogic1164(this, "A4", 2, null);
        this.portB = new PortStdLogic1164[8];
        this.portB[0] = new PortStdLogic1164(this, "B0", 2, null);
        this.portB[1] = new PortStdLogic1164(this, "B1", 2, null);
        this.portB[2] = new PortStdLogic1164(this, "B2", 2, null);
        this.portB[3] = new PortStdLogic1164(this, "B3", 2, null);
        this.portB[4] = new PortStdLogic1164(this, "B4", 2, null);
        this.portB[5] = new PortStdLogic1164(this, "B5", 2, null);
        this.portB[6] = new PortStdLogic1164(this, "B6", 2, null);
        this.portB[7] = new PortStdLogic1164(this, "B7", 2, null);
        this.portPC = new PortInteger(this, "PC", 1, null);
        this.portW = new PortInteger(this, "W", 1, null);
        this.portSTATUS = new PortInteger(this, "STATUS", 1, null);
        this.portINTCON = new PortInteger(this, "INTCON", 1, null);
        this.portINSTR = new PortString(this, "INSTR", 1, null);
        this.ports = new Port[21];
        this.ports[0] = this.portClkin;
        this.ports[1] = this.portClkout;
        this.ports[2] = this.portMclr;
        int i = 0;
        while (i < 5) {
            this.ports[i + 3] = this.portA[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            this.ports[i2 + 8] = this.portB[i2];
            ++i2;
        }
        this.ports[16] = this.portPC;
        this.ports[17] = this.portW;
        this.ports[18] = this.portSTATUS;
        this.ports[19] = this.portINTCON;
        this.ports[20] = this.portINSTR;
    }

    public void elaborate(Object dummy) {
        System.out.println("****** elaborate ******");
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            this._cycle = 0L;
            this.reset();
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.clk4Period, "CLK");
        }
    }

    public void wakeup(Object event) {
        block4: {
            try {
                Object label = ((WakeupEvent)event).getArg();
                if ("CLK".equals(label)) {
                    this.t_now = this.simulator.getSimTime();
                    this.singleStep();
                    this.t_now = (double)this._cycle * this.clk4Period + this.clk4Period;
                    double t_next = this.t_now + this.clk8Period;
                    EventList eventList = this.simulator.getEventList();
                    while (eventList.getSimTime() > t_next) {
                        this.singleStep();
                        this.t_now = (double)this._cycle * this.clk4Period + this.clk4Period;
                        t_next = this.t_now + this.clk8Period;
                    }
                    this.simulator.scheduleWakeup(this, this.t_now, "CLK");
                    break block4;
                }
                this.message("-E- SmartPic: unknown wakeup source: " + label);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean nextExternalEventIsLate() {
        double t_next = this.simulator.getEventList().getSecondEventTime();
        if (SimObject.debug) {
            System.out.println("-SPic: " + TimeFormatter.format(t_next) + " " + TimeFormatter.format(this.t_now));
        }
        return t_next > this.t_now + this.clk8Period;
    }

    public void evaluate(Object arg) {
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            double clk4 = Double.valueOf(st.nextToken());
            this.setClockFrequency(clk4);
            this.programResourceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
            this.loadProgram(this.programResourceName);
        }
        catch (Exception e) {
            this.message("-F- could not parse initialization string '" + s + "'");
            e.printStackTrace();
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.getClockFrequency() + " " + NameMangler.encodeWithUnicodeEscapes(this.programResourceName));
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.programResourceName};
        return externals;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "clk= " + this.getClockFrequency() + "\n" + "n_instructions= " + IntegerFormatter.formatThousandGroups(this._cycle) + "\n" + "pc= " + this.__hex(this._PC, 4) + " " + "w= " + this.__hex(this._W, 4);
    }

    public void setClockFrequency(double f) {
        this.clk4Period = 4.0 * (1.0 / f);
        this.clk8Period = 2.0 * this.clk4Period;
    }

    public double getClockFrequency() {
        return 4.0 / this.clk4Period;
    }

    public int readPortA() {
        int tmp = this._PORTA_LATCH;
        if (this._TRISA > 0) {
            int i = 0;
            int mask = 1;
            while (i < 5) {
                StdLogic1164 input = this.portA[i].getValueOrU();
                tmp = input.is_1() || input.is_H() ? (tmp |= mask) : (tmp &= ~mask);
                ++i;
                mask <<= 1;
            }
        }
        return tmp;
    }

    public int readPortB() {
        int tmp = this._PORTB_LATCH;
        if (this._TRISB > 0) {
            int i = 0;
            int mask = 1;
            while (i < 8) {
                StdLogic1164 input = this.portB[i].getValueOrU();
                tmp = input.is_1() || input.is_H() ? (tmp |= mask) : (tmp &= ~mask);
                ++i;
                mask <<= 1;
            }
        }
        return tmp;
    }

    public void writePortA(int value) {
        this._PORTA_LATCH = value;
        if (SimObject.debug) {
            System.out.println("*** writePortA: " + this.__hex(value, 2) + " " + this._cycle + " " + this.t_now + " " + (double)this._cycle * this.clk4Period);
        }
        if (this._TRISA <= 255) {
            int i = 0;
            int mask = 1;
            while (i < 5) {
                PortStdLogic1164 port;
                Signal signal;
                if ((this._TRISA & mask) == 0 && (signal = (port = this.portA[i]).getSignal()) != null) {
                    Const1164 v1164 = (this._PORTA_LATCH & mask) == 0 ? Const1164.__0 : Const1164.__1;
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, v1164, (Object)port));
                }
                ++i;
                mask <<= 1;
            }
        }
    }

    public void writePortB(int value) {
        this._PORTB_LATCH = value;
        if (SimObject.debug) {
            System.out.println("*** writePortB: " + this.__hex(value, 2) + " " + this._cycle + " " + this.t_now + " " + (double)this._cycle * this.clk4Period);
        }
        if (this._TRISB <= 255) {
            int i = 0;
            int mask = 1;
            while (i < 8) {
                PortStdLogic1164 port = this.portB[i];
                Signal signal = port.getSignal();
                if (signal != null) {
                    if ((this._TRISB & mask) == 0) {
                        Const1164 v1164 = (this._PORTB_LATCH & mask) == 0 ? Const1164.__0 : Const1164.__1;
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, v1164, (Object)port));
                    } else {
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, Const1164.__Z, (Object)port));
                    }
                }
                ++i;
                mask <<= 1;
            }
        }
    }

    public void writeTrisA(int value) {
        int tmp;
        this._TRISA = tmp = value & 0xFF;
        if (SimObject.debug) {
            System.out.println("*** writeTrisB: " + this.__hex(value, 2) + " " + this._cycle + " " + this.t_now + " " + (double)this._cycle * this.clk4Period);
        }
        int i = 0;
        int mask = 1;
        while (i < 5) {
            PortStdLogic1164 port = this.portA[i];
            Signal signal = port.getSignal();
            if (signal != null) {
                if ((this._TRISA & mask) == 0) {
                    Const1164 v1164 = (this._PORTA_LATCH & mask) == 0 ? Const1164.__0 : Const1164.__1;
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, v1164, (Object)port));
                } else {
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, Const1164.__Z, (Object)port));
                }
            }
            ++i;
            mask <<= 1;
        }
    }

    public void writeTrisB(int value) {
        int tmp;
        if (SimObject.debug) {
            System.out.println("*** writeTrisB: " + this.__hex(value, 2) + " " + this._cycle + " " + this.t_now + " " + (double)this._cycle * this.clk4Period);
        }
        this._TRISB = tmp = value & 0xFF;
        int i = 0;
        int mask = 1;
        while (i < 8) {
            PortStdLogic1164 port = this.portB[i];
            Signal signal = port.getSignal();
            if (signal != null) {
                if ((this._TRISB & mask) == 0) {
                    Const1164 v1164 = (this._PORTB_LATCH & mask) == 0 ? Const1164.__0 : Const1164.__1;
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, v1164, (Object)port));
                } else {
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, this.t_now + this.t_portdelay, Const1164.__Z, (Object)port));
                }
            }
            ++i;
            mask <<= 1;
        }
    }

    public void reset() {
        super.reset();
        if (this.simulator != null) {
            this.writeTrisA(255);
            this.writeTrisB(255);
            this.writePortA(0);
            this.writePortB(0);
        }
    }

    public void singleStep() {
        try {
            if (this.isResetOrSleep) {
                return;
            }
            if (this.needCheckIRQs) {
                this.checkIRQs();
            }
            this.program[this._PC].execute();
            if (this.enableGUI) {
                this.GUI.update();
            }
            if (this.enableDebugSignals) {
                this.scheduleDebugSignals();
            }
        }
        catch (Exception e) {
            ++this.n_errors;
            if (this.n_errors > 20L) {
                throw new RuntimeException("TurboPicCore: too many errors.");
            }
            e.printStackTrace();
            System.out.println("PC= " + this.__hex(this._PC, 4) + " W= " + this.__hex(this._W, 2) + " STATUS= " + this.__hex(this._STATUS, 2) + " INTCON= " + this.__hex(this._INTCON, 2) + " " + this.program[this._PC]);
        }
    }

    public void scheduleDebugSignals() {
        Signal signalINSTR;
        Signal signalINTCON;
        Signal signalSTATUS;
        Signal signalW;
        double time = this.simulator.getSimTime();
        Signal signalPC = this.portPC.getSignal();
        if (signalPC != null) {
            this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signalPC, time, this.getInteger(this._PC), this.portPC));
        }
        if ((signalW = this.portW.getSignal()) != null) {
            this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signalW, time, this.getInteger(this._W), this.portW));
        }
        if ((signalSTATUS = this.portSTATUS.getSignal()) != null) {
            this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signalSTATUS, time, this.getInteger(this._STATUS), this.portSTATUS));
        }
        if ((signalINTCON = this.portINTCON.getSignal()) != null) {
            this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signalINTCON, time, this.getInteger(this._INTCON), this.portINTCON));
        }
        if ((signalINSTR = this.portINSTR.getSignal()) != null) {
            String mnemo = null;
            mnemo = this.program[this._PC] == null ? "UNDEFINED" : this.program[this._PC].toString();
            this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signalINSTR, time, mnemo, this.portINSTR));
        }
    }

    public Integer getInteger(int i) {
        try {
            return _integerTable[i];
        }
        catch (Exception e) {
            return new Integer(i);
        }
    }

    public Component getPropertySheet() {
        if (this.GUI == null) {
            this.createGUI();
        }
        return this.GUI.getFrame();
    }

    public void configure() {
        if (this.GUI == null) {
            this.createGUI();
        }
        this.GUI.getFrame().setVisible(true);
    }

    public void createGUI() {
        this.GUI = new TurboPicGUI(this);
    }

    static {
        int i = 0;
        while (i < 256) {
            TurboPic16C84._integerTable[i] = new Integer(i);
            ++i;
        }
    }
}

