/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

class SignalElement {
    private int[] history;
    private int historyCapacity;
    private int historyPos;
    private int historyBase;
    private String name;
    private boolean breakPerformed = false;

    public SignalElement(int newHistoryCapacity, String newName) {
        this.name = newName;
        this.historyCapacity = newHistoryCapacity;
        this.historyPos = 0;
        this.historyBase = 0;
        this.history = new int[this.historyCapacity];
        this.breakPerformed = false;
    }

    public void advance(int next) {
        this.history[this.historyPos] = next;
        this.historyPos = (this.historyPos + 1) % this.historyCapacity;
        if (this.historyPos == this.historyBase) {
            this.historyBase = (this.historyBase + 1) % this.historyCapacity;
        }
        this.breakPerformed = false;
    }

    public void advanceBreak() {
        if (!this.breakPerformed) {
            this.advance(-10);
            this.breakPerformed = true;
        }
    }

    public int getHistory(int position) {
        return this.history[(this.historyPos + this.historyCapacity - 1 - position) % this.historyCapacity];
    }

    public int getHistoryCapacity() {
        return this.historyCapacity;
    }

    public int getHistorySize() {
        return (this.historyPos + this.historyCapacity - this.historyBase) % this.historyCapacity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSimpleSignal() {
        return false;
    }
}

