/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.gui.WindowCloser;
import hades.manager.DesignManager;
import hades.models.pic.HexMemoryCanvas;
import hades.models.pic.MemoryDisassemblerView;
import hades.models.pic.MemoryView;
import hades.models.pic.PicExec;
import hades.models.pic.PicMemory;
import hades.models.pic.ShowSignals;
import hades.models.pic.WordButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jfig.gui.JTextViewer;

public class ShowPic2 {
    private PicExec pic;
    private JFrame frame;
    private JFrame signalFrame;
    private JFrame breakPointsFrame;
    private WordButton workRegButton;
    private WordButton statusRegButton;
    private WordButton pcRegButton;
    private WordButton intconRegButton;
    private JCheckBox enableUpdateCheckbox;
    private HexMemoryCanvas ram;
    private HexMemoryCanvas eeprom;
    private HexMemoryCanvas stack;
    private MemoryView ramBreakPoints;
    private MemoryView epromBreakPoints;
    private MemoryDisassemblerView eprom;
    public ShowSignals signals;
    private JCheckBoxMenuItem miWDT;
    private JMenuItem miSignals;
    private JMenuItem miBreakPoints;
    private JMenuItem miNew;
    private JMenuItem miOpen;
    private JMenuItem miReload;
    private JMenuItem miSave;
    private JMenuItem miClose;
    private JMenuItem miLoadLabels;
    private JMenuItem smiClose;
    private JMenuItem bmiClose;
    private JMenuItem miHelpAbout;
    private JMenuItem miHelpEditing;
    private JMenuItem miHelpBreakpoints;
    private JMenuItem miHelpOpcodes;
    private JMenuItem miHelpMemorymap;
    private JMenuItem miHelpStatusRegister;

    public void initializeSignals() {
        this.signals = new ShowSignals(400, 170);
        this.signals.add(this.pic.regBank.pcl, "PCL");
        this.signals.add(this.pic.workReg, "WORK");
        this.signals.add(this.pic.regBank.status, "STATUS");
        this.signals.add(this.pic.regBank.intcon, "INTCON");
        this.signals.add(this.pic.skip, "SKIP");
        this.signals.add(this.pic.nextInstruction, "Next");
        this.signals.add(this.pic.nextJump, "Jump");
        this.signals.advanceBreak();
    }

    public void initializeListeners() {
        LoadListener loadListener = new LoadListener();
        this.miOpen.addActionListener(loadListener);
        this.miReload.addActionListener(loadListener);
        this.miSave.addActionListener(new SaveListener());
        this.miLoadLabels.addActionListener(new LoadLabelsListener());
        this.miWDT.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ((ShowPic2)ShowPic2.this).pic.wdt.setEnabled(ShowPic2.this.miWDT.getState());
            }
        });
        this.miSignals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowPic2.this.signalsShow();
            }
        });
        this.miBreakPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowPic2.this.breakPointsShow();
            }
        });
        this.miNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowPic2.this.pic.por();
                ShowPic2.this.signals.advanceBreak();
                ShowPic2.this.update();
                ShowPic2.this.eprom.update();
                ShowPic2.this.epromBreakPoints.update();
                ShowPic2.this.ramBreakPoints.update();
                ShowPic2.this.signals.repaint();
            }
        });
        this.miClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowPic2.this.frame.setVisible(false);
            }
        });
        this.miHelpAbout.addActionListener(new SimpleHelpListener("/hades/models/pic/help/about.txt"));
        this.miHelpEditing.addActionListener(new SimpleHelpListener("/hades/models/pic/help/editing.txt"));
        this.miHelpBreakpoints.addActionListener(new SimpleHelpListener("/hades/models/pic/help/breakpoints.txt"));
        this.miHelpOpcodes.addActionListener(new SimpleHelpListener("/hades/models/pic/help/opcodes.txt"));
        this.miHelpMemorymap.addActionListener(new SimpleHelpListener("/hades/models/pic/help/memorymap.txt"));
        this.miHelpStatusRegister.addActionListener(new SimpleHelpListener("/hades/models/pic/help/statusregister.txt"));
        try {
            this.smiClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowPic2.this.signalFrame.setVisible(false);
                }
            });
            this.bmiClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowPic2.this.breakPointsFrame.setVisible(false);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void prepareMainWindow() {
        this.pcRegButton = new WordButton("PC:", this.pic.regBank.pcl);
        this.workRegButton = new WordButton("Work:", this.pic.workReg);
        this.statusRegButton = new WordButton("Status:", this.pic.regBank.status);
        this.intconRegButton = new WordButton("Intcon:", this.pic.regBank.intcon);
        this.enableUpdateCheckbox = new JCheckBox("Update display", true);
        this.enableUpdateCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ShowPic2.this.signals.setEnabled(ShowPic2.this.enableUpdateCheckbox.isSelected());
                ShowPic2.this.update();
                if (!ShowPic2.this.enableUpdateCheckbox.isSelected()) {
                    ShowPic2.this.signals.advanceBreak();
                }
            }
        });
        this.ram = new HexMemoryCanvas(this.pic.regBank, 10, 8);
        this.eeprom = new HexMemoryCanvas(this.pic.eeprom, 4, 8);
        this.stack = new HexMemoryCanvas(this.pic.stack, 2, 4);
        this.eprom = new MemoryDisassemblerView("Program memory:", this.pic.eprom, this.pic.epromBreakPoints, this.pic.regBank.pcl, 25);
        this.eprom.setBackground(new Color(230, 230, 230));
        JPanel epromPane = new JPanel(new BorderLayout());
        epromPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        epromPane.add("North", new JLabel("Program memory:", 2));
        epromPane.add("Center", this.eprom);
        int H_NEVER = 31;
        JScrollPane ramPane = new JScrollPane(this.ram);
        ramPane.setHorizontalScrollBarPolicy(H_NEVER);
        Dimension ramDim = this.ram.getMinimumSize(8);
        ramPane.setPreferredSize(new Dimension(ramDim.width + 20, ramDim.height));
        JScrollPane eepromPane = new JScrollPane(this.eeprom);
        eepromPane.setPreferredSize(this.eeprom.getMinimumSize(4));
        eepromPane.setHorizontalScrollBarPolicy(H_NEVER);
        JScrollPane stackPane = new JScrollPane(this.stack);
        stackPane.setPreferredSize(this.stack.getMinimumSize(4));
        stackPane.setHorizontalScrollBarPolicy(H_NEVER);
        JLabel regfileLabel = new JLabel("Register file:", 2);
        JLabel eepromLabel = new JLabel("EEPROM memory:", 11);
        JLabel stackLabel = new JLabel("Stack:", 2);
        Box box = Box.createVerticalBox();
        try {
            box.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
        catch (Throwable t) {
            // empty catch block
        }
        box.add(Box.createVerticalStrut(5));
        box.add(regfileLabel);
        box.add(ramPane);
        box.add(Box.createVerticalStrut(5));
        box.add(eepromLabel);
        box.add(eepromPane);
        box.add(Box.createVerticalStrut(5));
        box.add(stackLabel);
        box.add(stackPane);
        box.add(Box.createVerticalStrut(5));
        box.add(this.workRegButton);
        box.add(this.statusRegButton);
        box.add(this.pcRegButton);
        box.add(this.intconRegButton);
        box.add(Box.createGlue());
        box.add(Box.createVerticalStrut(1));
        this.frame = new JFrame("PIC 16C84");
        this.frame.setBackground(Color.lightGray);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("Center", epromPane);
        this.frame.getContentPane().add("West", box);
        this.frame.getContentPane().add("South", this.enableUpdateCheckbox);
        JMenuBar mb = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        this.miNew = new JMenuItem("New");
        this.miOpen = new JMenuItem("Open...");
        this.miReload = new JMenuItem("Reload...");
        this.miLoadLabels = new JMenuItem("Load labels...");
        this.miSave = new JMenuItem("Save as...");
        this.miClose = new JMenuItem("Close");
        filemenu.add(this.miNew);
        filemenu.add(this.miOpen);
        filemenu.add(this.miReload);
        filemenu.add(this.miLoadLabels);
        filemenu.addSeparator();
        filemenu.add(this.miSave);
        filemenu.addSeparator();
        filemenu.add(this.miClose);
        JMenu debugmenu = new JMenu("Debug");
        this.miBreakPoints = new JMenuItem("Breakpoints...");
        this.miSignals = new JMenuItem("Signals...");
        debugmenu.add(this.miBreakPoints);
        debugmenu.add(this.miSignals);
        JMenu componentsmenu = new JMenu("Components");
        this.miWDT = new JCheckBoxMenuItem("Watchdog-Timer");
        componentsmenu.add(this.miWDT);
        JMenu helpmenu = new JMenu("Help");
        this.miHelpAbout = new JMenuItem("About...");
        this.miHelpEditing = new JMenuItem("Editing...");
        this.miHelpBreakpoints = new JMenuItem("Breakpoints...");
        this.miHelpOpcodes = new JMenuItem("PIC16C8x opcodes...");
        this.miHelpMemorymap = new JMenuItem("PIC16C8x memory map...");
        this.miHelpStatusRegister = new JMenuItem("PIC16C8x status register...");
        helpmenu.add(this.miHelpAbout);
        helpmenu.addSeparator();
        helpmenu.add(this.miHelpEditing);
        helpmenu.add(this.miHelpBreakpoints);
        helpmenu.addSeparator();
        helpmenu.add(this.miHelpOpcodes);
        helpmenu.add(this.miHelpMemorymap);
        helpmenu.add(this.miHelpStatusRegister);
        mb.add(filemenu);
        mb.add(debugmenu);
        mb.add(componentsmenu);
        mb.add(helpmenu);
        this.frame.setJMenuBar(mb);
        this.frame.addWindowListener(new WindowCloser(this.frame));
        this.frame.pack();
    }

    public void prepareSignalWindow() {
        this.initializeSignals();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.signalFrame = new JFrame("PIC 16C84 - Signals");
        this.signalFrame.setBackground(Color.lightGray);
        this.signalFrame.getContentPane().setLayout(gridbag);
        constr.gridx = 0;
        constr.gridy = 0;
        constr.gridwidth = 1;
        gridbag.setConstraints(this.signals, constr);
        this.signalFrame.getContentPane().add(this.signals);
        JMenuBar smb = new JMenuBar();
        JMenu sfilemenu = new JMenu("File");
        this.smiClose = new JMenuItem("Close");
        sfilemenu.add(this.smiClose);
        smb.add(sfilemenu);
        this.signalFrame.setJMenuBar(smb);
        this.signalFrame.addWindowListener(new WindowCloser(this.signalFrame));
        this.signalFrame.setSize(430, 250);
    }

    public void prepareBreakPointsWindow() {
        this.ramBreakPoints = new MemoryView("Register-Breakpoints:", (PicMemory)this.pic.regBankBreakPoints, 8, 8, 8, false);
        this.epromBreakPoints = new MemoryView("Eprom-Breakpoints:", (PicMemory)this.pic.epromBreakPoints, 8, 8, 8, false);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.breakPointsFrame = new JFrame("PIC 16C84 - Breakpoints");
        this.breakPointsFrame.setBackground(Color.lightGray);
        this.breakPointsFrame.getContentPane().setLayout(gridbag);
        constr.gridx = 0;
        constr.gridy = 0;
        constr.gridwidth = 1;
        gridbag.setConstraints(this.epromBreakPoints, constr);
        this.breakPointsFrame.getContentPane().add(this.epromBreakPoints);
        constr.gridx = 1;
        constr.gridy = 0;
        constr.gridwidth = 1;
        gridbag.setConstraints(this.ramBreakPoints, constr);
        this.breakPointsFrame.getContentPane().add(this.ramBreakPoints);
        JMenuBar bmb = new JMenuBar();
        JMenu bfilemenu = new JMenu("File");
        this.bmiClose = new JMenuItem("Close");
        bfilemenu.add(this.bmiClose);
        bmb.add(bfilemenu);
        this.breakPointsFrame.setJMenuBar(bmb);
        this.breakPointsFrame.addWindowListener(new WindowCloser(this.breakPointsFrame));
        this.breakPointsFrame.setSize(520, 260);
    }

    public ShowPic2(PicExec newPic) {
        this.pic = newPic;
        this.prepareMainWindow();
        this.prepareSignalWindow();
        try {
            this.prepareBreakPointsWindow();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.initializeListeners();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Frame getSignalFrame() {
        return this.signalFrame;
    }

    public void signalsShow() {
        this.signals.advanceBreak();
        this.signalFrame.setVisible(true);
    }

    public void breakPointsShow() {
        this.breakPointsFrame.setVisible(true);
    }

    public void update() {
        if (this.enableUpdateCheckbox.isSelected()) {
            this.workRegButton.smartUpdate();
            this.pcRegButton.smartUpdate();
            this.statusRegButton.smartUpdate();
            this.intconRegButton.smartUpdate();
            this.eprom.smartUpdate();
            this.ram.smartUpdate();
            this.stack.smartUpdate();
            this.eeprom.smartUpdate();
        }
    }

    public void load(String name, String dir) {
        this.pic.eprom.load(name, dir);
    }

    public void save(String name, String dir) {
        this.pic.eprom.save(name, dir);
    }

    public static void main(String[] argv) {
        PicExec pic = new PicExec();
        ShowPic2 showPic = new ShowPic2(pic);
        showPic.frame.setVisible(true);
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = null;
            String dir = null;
            DesignManager DM = DesignManager.getDesignManager();
            String answer = DM.selectFileOrURLName("Save PIC program memory", "name.rom", ".rom", 1);
            if (answer != null) {
                name = DesignManager.getName(answer);
                dir = DesignManager.getDirectoryName(answer);
                System.out.println("-#- save as: " + name + " " + dir);
            }
            if (name != null) {
                ShowPic2.this.save(name, dir);
            }
        }
    }

    class LoadLabelsListener
    implements ActionListener {
        private String name;
        private String dir;

        LoadLabelsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DesignManager DM = DesignManager.getDesignManager();
                String answer = DM.selectFileOrURLName("Load PIC program labels ", "name.lbl", ".lbl", 0);
                if (answer != null) {
                    this.name = DesignManager.getName(answer);
                    this.dir = DesignManager.getDirectoryName(answer);
                    System.out.println("-#- load labels: " + this.name + " " + this.dir);
                }
                if (this.name != null) {
                    FileInputStream FIS = new FileInputStream(this.dir + File.separator + this.name);
                    ((ShowPic2)ShowPic2.this).eprom.eprom.loadLBL(FIS);
                    ShowPic2.this.eprom.repaint();
                    FIS.close();
                }
            }
            catch (Exception t) {
                System.err.println("-E- ShowPic2.LoadLabelsListener: " + t);
            }
        }
    }

    class LoadListener
    implements ActionListener {
        private String name;
        private String dir;

        LoadListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Open...")) {
                DesignManager DM = DesignManager.getDesignManager();
                String answer = DM.selectFileOrURLName("Load PIC program (ROM/HEX)", "name.hex", new String[]{".hex", ".rom"}, 0);
                if (answer != null) {
                    this.name = DesignManager.getName(answer);
                    this.dir = DesignManager.getDirectoryName(answer);
                    System.out.println("-#- load: " + this.name + " " + this.dir);
                }
            } else if (e.getActionCommand().equals("Reload...")) {
                System.out.println("-#- ShowPic2: reloading program...");
            } else {
                System.out.println("-E- ShowPic2: reloading program...");
                return;
            }
            if (this.name != null) {
                ShowPic2.this.load(this.name, this.dir);
                ShowPic2.this.eprom.update();
            }
        }
    }

    class SimpleHelpListener
    implements ActionListener {
        private String helpFileName = null;

        public SimpleHelpListener(String s) {
            this.helpFileName = s;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                JTextViewer helpViewer = new JTextViewer(this.helpFileName, 30, 80);
                helpViewer.parse(DesignManager.getDesignManager().getInputStream(this, this.helpFileName));
                helpViewer.setVisible(true);
            }
            catch (Exception e) {
                System.err.println("-E- in SimpleHelpListener: " + e);
            }
        }
    }

    class RomHexFilter
    implements FilenameFilter {
        RomHexFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.endsWith(".rom") || name.endsWith(".hex")) {
                return true;
            }
            return new File(dir, name).isDirectory();
        }
    }
}

