/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.MemoryDisassemblerView;
import hades.models.pic.PicDecode;
import hades.models.pic.PicEprom;
import hades.models.pic.PicEpromBreakPoints;
import hades.models.pic.PicPcReg;
import hades.utils.HexFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

class ShowDisassemblerCanvas
extends JComponent
implements KeyListener,
MouseListener {
    private int WIDTH = 420;
    private int HEIGHT = 200;
    private PicEprom eprom;
    private PicEpromBreakPoints breakPoints;
    private PicPcReg pcreg;
    private MemoryDisassemblerView memDisView;
    private JScrollBar scrollbar;
    private int factor;
    private PicDecode decode;
    private int adrWidth;
    private int lines;
    private int memorySize;
    protected boolean editMode;
    protected int editAdr;
    protected int editVal;
    protected long editMask;
    public static final int LINE_HEIGHT = 15;
    public static final int LINE_BASELINE = 12;
    public static final int LINE_BPFIELD_XWIDTH = 30;

    public ShowDisassemblerCanvas(MemoryDisassemblerView _memDisView, PicEpromBreakPoints _breakPoints, PicPcReg _pcreg, JScrollBar _scrollbar, int adrFactor, PicDecode _decode, int _lines) {
        this.memDisView = _memDisView;
        this.eprom = _memDisView.eprom;
        this.breakPoints = _breakPoints;
        this.pcreg = _pcreg;
        this.scrollbar = _scrollbar;
        this.factor = adrFactor;
        this.decode = _decode;
        this.lines = _lines;
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setFont(new Font("Monospaced", 0, 12));
        this.HEIGHT = this.lines * 15;
        this.memorySize = (this.eprom.getMemorySize() - 1) * this.factor;
        this.adrWidth = 0;
        while (this.memorySize > 0) {
            this.memorySize >>= 4;
            ++this.adrWidth;
        }
        if (this.adrWidth < 2) {
            this.adrWidth = 2;
        }
        this.memorySize = this.eprom.getMemorySize();
        this.setBackground(Color.white);
        this.editMode = false;
        this.editMask = (1 << (int)((long)this.eprom.getWordWidth())) - 1;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public int getAddress(int yPixels) {
        return this.scrollbar.getValue() + yPixels / 15;
    }

    public void toggleBreakpoint(int adr) {
        if (this.breakPoints == null) {
            System.err.println("-E- toggleBreakpoint: no break point memory set!");
            return;
        }
        if (this.breakPoints.readMemory(adr) != 0) {
            this.breakPoints.writeMemory(adr, 0);
        } else {
            this.breakPoints.writeMemory(adr, 1);
        }
    }

    public void startEdit(int yPixels) {
        this.editMode = true;
        this.editAdr = this.getAddress(yPixels);
        this.editVal = this.eprom.readMemory(this.editAdr);
    }

    public void stopEdit(boolean apply) {
        if (apply) {
            this.eprom.writeMemory(this.editAdr, this.editVal);
            this.memDisView.smartUpdate();
        }
        this.editMode = false;
    }

    public int getEditVal() {
        return this.editVal;
    }

    public void setEditVal(int newEditVal) {
        this.editVal = newEditVal;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public void update(Graphics g) {
        g.clearRect(0, 0, this.WIDTH, this.HEIGHT);
        this.paint(g);
    }

    public void paint(Graphics g) {
        int startAdr = this.scrollbar.getValue();
        int y = 12;
        int n_addr = 3;
        int n_data = 4;
        int n_label = 16;
        int char_width = g.getFontMetrics().stringWidth("M");
        int x_breakpoint = 2;
        int x_addr = x_breakpoint + 2 * char_width;
        int x_data = x_addr + n_addr * char_width + char_width;
        int x_label = x_data + n_data * char_width + char_width;
        int x_disassembly = x_label + n_label * char_width + char_width;
        int data = 0;
        boolean isBreakPoint = false;
        int pc = -1;
        if (this.pcreg != null) {
            pc = this.pcreg.readPc();
        }
        int adr = startAdr;
        while (adr < startAdr + this.lines) {
            if (this.breakPoints != null && this.breakPoints.readMemory(adr) != 0) {
                isBreakPoint = true;
                g.setColor(Color.red);
                g.drawString("# ", x_breakpoint, y);
            } else {
                isBreakPoint = false;
                g.setColor(Color.black);
                g.drawString(". ", x_breakpoint, y);
            }
            g.drawString(HexFormat.getHexString(adr, n_addr), x_addr, y);
            if (this.editMode && adr == this.editAdr) {
                data = this.editVal;
                g.setColor(Color.blue);
            } else {
                data = this.eprom.readMemory(adr);
            }
            this.decode.decode(data);
            g.drawString(HexFormat.getHexString(data, n_data), x_data, y);
            if (adr == pc) {
                g.setColor(Color.green);
            } else if (isBreakPoint) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(this.getLabel(adr, n_label), x_label, y);
            g.drawString(this._right(this.decode.disassemble(), ' ', 20), x_disassembly, y);
            y += 15;
            ++adr;
        }
    }

    final String getLabel(int addr, int width) {
        String s = this.eprom.getLabel(addr);
        String t = this._right(s, ' ', width);
        return t.substring(0, width);
    }

    final String getLabelDummy(int adr, int width) {
        int i = (int)(100.0 * Math.random());
        if (i < 20) {
            return this._left("label" + i, ' ', width);
        }
        return this._left("", ' ', width);
    }

    final String _left(String str, char fill, int count) {
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < count - str.length()) {
            tmp.append(fill);
            ++i;
        }
        tmp.append(str);
        return tmp.toString();
    }

    final String _right(String str, char fill, int count) {
        StringBuffer tmp = new StringBuffer(str);
        int i = 0;
        while (i < count - str.length()) {
            tmp.append(fill);
            ++i;
        }
        return tmp.toString();
    }

    public void keyPressed(KeyEvent kev) {
    }

    public void keyReleased(KeyEvent kev) {
    }

    public void keyTyped(KeyEvent kev) {
        if (this.editMode) {
            char ch = kev.getKeyChar();
            int editVal = this.getEditVal();
            long longVal = (long)editVal & this.editMask;
            switch (ch) {
                case '\u001b': {
                    this.stopEdit(false);
                    this.repaint();
                    break;
                }
                case '\n': 
                case '\r': {
                    this.stopEdit(true);
                    this.repaint();
                    break;
                }
                case '\b': 
                case '\u007f': {
                    longVal = longVal >> 4 & this.editMask >> 4;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    longVal = (longVal << 4) + (long)(ch - 48) & this.editMask;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    longVal = (longVal << 4) + 10L + (long)(ch - 97) & this.editMask;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    longVal = (longVal << 4) + 10L + (long)(ch - 65) & this.editMask;
                    break;
                }
            }
            int newEditVal = (int)(longVal & this.editMask);
            if (newEditVal != editVal) {
                this.setEditVal(newEditVal);
                this.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mev) {
    }

    public void mouseEntered(MouseEvent mev) {
    }

    public void mouseExited(MouseEvent mev) {
    }

    public void mousePressed(MouseEvent mev) {
        this.requestFocus();
        if (mev.getX() < 30) {
            this.toggleBreakpoint(this.getAddress(mev.getY()));
        } else {
            this.stopEdit(false);
            this.startEdit(mev.getY());
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mev) {
    }
}

