/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicMemory;
import hades.models.pic.PicWordReg;

public class PicStack
implements PicMemory {
    public PicWordReg[] stack;
    public int stackPtr = 0;
    public int stackSize = 0;
    public int wordWidth = 0;
    public PicBreakPoint bp;

    public PicStack(PicBreakPoint newBp) {
        this(newBp, 8, 13);
    }

    public PicStack(PicBreakPoint newBp, int newSize, int bitWidth) {
        this.bp = newBp;
        this.wordWidth = bitWidth;
        this.stackSize = newSize;
        this.stack = new PicWordReg[this.stackSize];
        int i = 0;
        while (i < this.stackSize) {
            this.stack[i] = new PicWordReg(this.bp, bitWidth);
            ++i;
        }
        this.por();
    }

    public void por() {
        int i = 0;
        while (i < this.stackSize) {
            this.stack[i].write(0);
            ++i;
        }
        this.reset();
    }

    public void reset() {
        this.stackPtr = 0;
    }

    public void push(int value) {
        if (this.stackPtr > 7) {
            System.err.println("-E- PicStack overflow!");
        }
        this.stackPtr %= this.stackSize;
        this.stack[this.stackPtr].write(value);
        this.stackPtr = (this.stackPtr + 1) % this.stackSize;
    }

    public int pop() {
        this.stackPtr = (this.stackPtr + (this.stackSize - 1)) % this.stackSize;
        return this.stack[this.stackPtr].read();
    }

    public int getWordWidth() {
        return this.wordWidth;
    }

    public int getMemorySize() {
        return this.stackSize + 1;
    }

    public int readMemoryOld(int address) {
        if (address < this.stackSize) {
            return this.stack[address].read();
        }
        return this.stackPtr;
    }

    public int readMemory(int address) {
        if (address < this.stackPtr) {
            return this.stack[address].read();
        }
        return -1;
    }

    public void writeMemory(int address, int word) {
        if (address < this.stackSize) {
            this.stack[address].write(word);
        } else {
            this.stackPtr = word;
        }
    }

    public int getStackPointer() {
        return this.stackPtr;
    }
}

