/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicAlu;
import hades.models.pic.PicBitReg;
import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicByteReg;
import hades.models.pic.PicClocking;
import hades.models.pic.PicDecode;
import hades.models.pic.PicEeprom;
import hades.models.pic.PicEprom;
import hades.models.pic.PicEpromBreakPoints;
import hades.models.pic.PicReg;
import hades.models.pic.PicRegBank;
import hades.models.pic.PicRegBankBreakPoints;
import hades.models.pic.PicStack;
import hades.models.pic.PicWdt;
import hades.models.pic.PicWordReg;

public class PicExec {
    public static final int ALUACTION = 0;
    public static final int BITACTION = 1;
    public static final int JUMPACTION = 2;
    public static final int LITERALACTION = 3;
    private static int NOP = 0;
    public PicEprom eprom = new PicEprom();
    public PicAlu alu;
    public PicDecode decode;
    public PicRegBank regBank;
    public PicByteReg workReg;
    public PicClocking clocking;
    public PicStack stack;
    public PicEeprom eeprom;
    public PicWdt wdt;
    public PicBreakPoint breakPoint;
    public PicRegBankBreakPoints regBankBreakPoints;
    public PicEpromBreakPoints epromBreakPoints = new PicEpromBreakPoints();
    public PicWordReg nextInstruction;
    public PicWordReg nextJump;
    public PicBitReg skip;
    public int operand = 0;
    public int action = 0;
    public int result = 0;
    public PicBitReg sleep;

    public PicExec() {
        this.breakPoint = new PicBreakPoint();
        this.buildRegBank(this.breakPoint, this.epromBreakPoints);
        this.regBankBreakPoints = new PicRegBankBreakPoints(this.regBank);
        this.eeprom = new PicEeprom(64, 8, this.regBank.eedata, this.regBank.eeadr, (PicReg)this.regBank.eecon1);
        this.regBank.eecon1.setEeprom(this.eeprom);
        this.decode = new PicDecode(this.regBank.status);
        this.alu = new PicAlu(this.regBank.status);
        this.workReg = new PicByteReg(this.breakPoint);
        this.clocking = new PicClocking();
        this.wdt = new PicWdt(this.regBank.option, this.regBank.status, this);
        this.skip = new PicBitReg();
        this.skip.setBit(true);
        this.nextInstruction = new PicWordReg(this.breakPoint, 14);
        this.nextInstruction.write(NOP);
        this.nextJump = new PicWordReg(this.breakPoint, 13);
        this.nextJump.write(0);
        this.stack = new PicStack(this.breakPoint, 8, 13);
        this.sleep = new PicBitReg();
        this.por();
    }

    public void buildRegBank(PicBreakPoint breakPoint, PicEpromBreakPoints epromBreakPoints) {
        this.regBank = new PicRegBank(breakPoint, epromBreakPoints);
    }

    public void por() {
        this.eprom.por();
        this.epromBreakPoints.por();
        this.alu.por();
        this.decode.por();
        this.regBank.por();
        this.regBankBreakPoints.por();
        this.eeprom.por();
        this.workReg.por();
        this.clocking.por();
        this.stack.por();
        this.wdt.por();
        this.breakPoint.por();
        this.nextInstruction.write(NOP);
        this.nextJump.write(0);
        this.skip.setBit(true);
        this.operand = 0;
        this.action = 0;
        this.result = 0;
        this.sleep.setBit(false);
    }

    public void reset() {
        this.eprom.reset();
        this.epromBreakPoints.reset();
        this.alu.reset();
        this.decode.reset();
        this.regBank.reset();
        this.regBankBreakPoints.reset();
        this.eeprom.reset();
        this.workReg.reset();
        this.clocking.reset();
        this.stack.reset();
        this.wdt.reset();
        this.nextInstruction.write(NOP);
        this.nextJump.write(0);
        this.skip.setBit(true);
        this.operand = 0;
        this.action = 0;
        this.result = 0;
        this.sleep.setBit(false);
    }

    public void fetchNextInstruction(int nextInstr) {
        if (this.skip.getBit()) {
            this.nextInstruction.write(NOP);
        } else if (nextInstr == -1) {
            this.nextInstruction.write(this.eprom.readMemory(this.regBank.pcl.readPc()));
        } else {
            this.nextInstruction.write(nextInstr);
        }
    }

    public void incPc() {
        if (this.skip.getBit()) {
            this.regBank.pcl.writePc(this.nextJump.read());
        } else {
            this.regBank.pcl.writeAll(this.regBank.pcl.readAll() + 1);
        }
    }

    public void firstCycle() {
        this.incPc();
        this.decode.decode(this.nextInstruction.read());
        this.action = this.decode.getInstruction();
    }

    public void secondCycle() {
        this.skip.setBit(false);
        this.alu.setSkip(false);
        if (this.action == 0) {
            this.operand = this.regBank.read(this.decode.getRegister());
        } else if (this.action == 1) {
            this.operand = this.regBank.read(this.decode.getRegister());
        } else if (this.action == 2) {
            this.operand = this.decode.getAddress();
        } else if (this.action == 3) {
            this.operand = this.decode.getLiteral();
        }
    }

    public void thirdCycle() {
        this.result = 0;
        if (this.action == 0) {
            int operation = this.decode.getAluOperation();
            if (!(operation == 0 & this.decode.getDestination() == 0)) {
                this.result = this.alu.alu(operation, this.operand, this.workReg.read());
            }
        } else if (this.action == 1) {
            this.result = this.alu.bitAlu(this.decode.getBitOperation(), this.operand, this.decode.getBitNumber());
        } else if (this.action != 2 && this.action == 3) {
            this.result = this.alu.literalAlu(this.decode.getAluOperation(), this.operand, this.workReg.read());
        }
        if (this.alu.getSkip()) {
            this.skip.setBit(true);
            this.nextJump.write(this.regBank.pcl.readPc() + 1);
        }
        this.regBank.tmr0.internInc();
    }

    public void fourthCycle() {
        block28: {
            block26: {
                block27: {
                    if (this.action != 0) break block26;
                    int operation = this.decode.getAluOperation();
                    if (!(operation == 0 & this.decode.getDestination() == 0)) break block27;
                    switch (this.decode.getRegister() & 0x7F) {
                        case 0: 
                        case 32: 
                        case 64: 
                        case 96: {
                            break;
                        }
                        case 101: 
                        case 102: 
                        case 103: {
                            this.regBank.reg[128 + (this.decode.getRegister() & 7)].write(this.workReg.read());
                            break;
                        }
                        case 98: {
                            this.regBank.option.write(this.workReg.read());
                            break;
                        }
                        case 100: {
                            this.wdt.reset();
                            break;
                        }
                        case 8: {
                            this.nextJump.write(this.stack.pop());
                            this.skip.setBit(true);
                            break;
                        }
                        case 9: {
                            this.nextJump.write(this.stack.pop());
                            this.skip.setBit(true);
                            this.regBank.intcon.setBit(7, true);
                            break;
                        }
                        case 99: {
                            if (!this.regBank.intcon.couldBeIntr()) {
                                this.wdt.reset();
                                this.regBank.status.setBit(4, true);
                                this.regBank.status.setBit(3, false);
                                this.sleep.setBit(true);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block28;
                }
                if (this.decode.getDestination() == 0) {
                    this.workReg.write(this.result);
                } else {
                    this.regBank.reg[this.decode.getRegister()].write(this.result);
                }
                break block28;
            }
            if (this.action == 1) {
                this.regBank.reg[this.decode.getRegister()].write(this.result);
            } else if (this.action == 2) {
                if (this.decode.getJumpOperation() == 0) {
                    this.stack.push(this.regBank.pcl.readPc());
                }
                this.nextJump.write(this.operand);
                this.skip.setBit(true);
            } else if (this.action == 3) {
                this.workReg.write(this.result);
                if (this.decode.getBitOperation() == 1) {
                    this.nextJump.write(this.stack.pop());
                    this.skip.setBit(true);
                }
            }
        }
        if (!this.skip.getBit()) {
            if (this.regBank.intcon.isIntr()) {
                this.regBank.intcon.setBit(7, false);
                this.regBank.pcl.writeAll(this.regBank.pcl.readAll() - 1);
                this.skip.setBit(false);
                this.fetchNextInstruction(8196);
            } else {
                this.fetchNextInstruction(-1);
            }
            if (this.regBank.tmr0Int.getBit()) {
                this.regBank.intcon.tmr0Intr();
            }
            this.regBank.tmr0Int.setBit(false);
            if (this.regBank.extInt.getBit()) {
                this.regBank.intcon.extIntr();
            }
            this.regBank.extInt.setBit(false);
            if (this.regBank.rbInt.getBit()) {
                this.regBank.intcon.rbIntr();
            }
            this.regBank.rbInt.setBit(false);
        } else {
            this.fetchNextInstruction(-1);
        }
    }

    public void advance() {
        if (!this.sleep.getBit()) {
            this.clocking.clock();
        }
    }

    public void clock() {
        switch (this.clocking.getState()) {
            case 1: {
                this.firstCycle();
                break;
            }
            case 2: {
                this.secondCycle();
                break;
            }
            case 3: {
                this.thirdCycle();
                break;
            }
            case 4: {
                this.fourthCycle();
                break;
            }
        }
    }
}

