/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.manager.DesignManager;
import hades.models.pic.PicMemory;
import hades.models.pic.PicReg;
import hades.utils.IntelHexFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class PicEeprom
implements PicMemory {
    protected int bits;
    protected long maxWord;
    protected int bytes;
    protected long[] eeprom;
    protected String filename;
    protected PicReg eedata;
    protected PicReg eeadr;
    protected PicReg eecon1;
    protected boolean nextWrite;

    public PicEeprom(int size, int bitsPerWord, PicReg newEedata, PicReg newEeadr, PicReg newEecon1) {
        if (bitsPerWord > 30) {
            bitsPerWord = 30;
        }
        this.bits = bitsPerWord;
        this.maxWord = 1 << this.bits;
        this.bytes = size;
        this.eeprom = new long[size];
        this.filename = new String();
        this.eedata = newEedata;
        this.eeadr = newEeadr;
        this.eecon1 = newEecon1;
        this.por();
    }

    public void por() {
        this.reset();
    }

    public void reset() {
        this.eecon1.setBit(3, this.nextWrite);
        this.nextWrite = false;
    }

    public boolean resize(int i, int j) {
        return false;
    }

    public int getMemorySize() {
        return this.bytes;
    }

    public int getWordWidth() {
        return this.bits;
    }

    public int readMemory(int address) {
        return (int)(this.eeprom[address % this.bytes] % this.maxWord);
    }

    public void writeMemory(int address, int word) {
        this.eeprom[address % this.bytes] = (long)word % this.maxWord;
    }

    public void setFilename(String name) {
        this.filename = name;
    }

    public void setFilename(String name, String dir) {
        this.filename = dir + name;
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void load(String name, String dir) {
        block14: {
            error = false;
            fis = null;
            try {
                block13: {
                    fis = new FileInputStream(new File(dir, name));
                    if (name.toLowerCase().endsWith(".hex")) {
                        error = this.loadHEX(fis);
                        break block13;
                    }
                    error = this.loadROM(fis);
                }
                var7_5 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_7 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (Exception e) {
                    error = true;
                    var7_6 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (!error) {
            this.setFilename(dir + name);
        }
    }

    public boolean load(Object parent, String resourcename) {
        InputStream is = DesignManager.getDesignManager().getInputStream(parent, resourcename);
        if (resourcename.toLowerCase().endsWith(".hex")) {
            return this.loadHEX(is);
        }
        return this.loadROM(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadROM(InputStream is) {
        String line;
        BufferedReader br = null;
        boolean error = false;
        int adr = 0;
        int word = 0;
        br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            void var7_7;
            StringTokenizer st = new StringTokenizer((String)var7_7, " \t,");
            while (!error && st.hasMoreTokens()) {
                try {
                    String token = st.nextToken();
                    if (token.endsWith(":")) {
                        adr = Integer.parseInt(token.substring(0, token.length() - 1), 16);
                        continue;
                    }
                    word = Integer.parseInt(token, 16);
                    this.writeMemory(adr, word);
                    ++adr;
                }
                catch (NumberFormatException ex) {
                    error = true;
                }
            }
        }
        Object var11_11 = null;
        if (br == null) return error;
        try {
            br.close();
            return error;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return error;
        {
            catch (Exception e) {
                System.out.println("-E- in PicEeprom.load(): " + e);
                Object var11_12 = null;
                if (br == null) return error;
                try {
                    br.close();
                    return error;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return error;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public boolean loadHEX(InputStream is) {
        IntelHexFile intelHex = new IntelHexFile();
        boolean error = false;
        try {
            intelHex.parsePic16Bit(is, this.eeprom);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = true;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, String dir) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        int adr = 0;
        int index = 0;
        int max = this.getMemorySize();
        boolean error = false;
        try {
            fw = new FileWriter(new File(dir, name));
            bw = new BufferedWriter(fw);
            adr = 0;
            while (adr < max) {
                String line = Integer.toHexString(adr) + ":";
                index = 0;
                while (index + adr < max && index < 8) {
                    line = line + " " + Integer.toHexString(this.readMemory(adr + index));
                    ++index;
                }
                bw.write(line);
                bw.newLine();
                adr += 8;
            }
        }
        catch (Exception e) {
            System.out.println("-E- in PicEeprom.save(): " + e);
            error = true;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!error) {
            this.filename = dir + name;
        }
    }

    public void writeEeprom() {
        if (this.eecon1.getBit(2)) {
            this.nextWrite = true;
        }
    }

    public void readEeprom() {
        this.eedata.write((int)this.eeprom[this.eeadr.read() % this.bytes] % (int)this.maxWord);
    }

    public void wakeup() {
        if (this.nextWrite) {
            this.eeprom[this.eeadr.readAll() % this.bytes] = (long)this.eedata.readAll() % this.maxWord;
            this.eecon1.setBit(4, true);
            this.eecon1.setBit(1, false);
            this.nextWrite = false;
        }
    }
}

