/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicByteReg;
import hades.models.pic.PicDecode;
import hades.utils.HexFormat;
import hades.utils.IntelHexFile;
import java.io.FileInputStream;

public class PicDisassembler {
    public static void usage() {
        System.out.println("Usage: java hades.models.pic.PicDisassembler <filename> [options]\nExample: java hades.models.pic.PicDisassembler  rs232send.hex\nOptions include: \n  -noaddr        don't print address field\n  -noregs        don't print register names like PORTA\n  -decimal       print addresses/literals in decimal, too\n  -ascii         print addresses/literals in ascii, too \n  -labels        generate synthetic labels at goto/call targets\n");
        System.exit(1);
    }

    public static void main(String[] argv) {
        boolean enable_addr = true;
        boolean enable_regs = true;
        boolean enable_decimal = false;
        boolean enable_ascii = false;
        boolean enable_labels = false;
        try {
            if (argv.length < 1) {
                PicDisassembler.usage();
            }
            int i = 1;
            while (i < argv.length) {
                if (argv[i].equals("-noaddr")) {
                    enable_addr = false;
                }
                if (argv[i].equals("-noregs")) {
                    enable_regs = false;
                }
                if (argv[i].equals("-ascii")) {
                    enable_decimal = true;
                }
                if (argv[i].equals("-decimal")) {
                    enable_decimal = true;
                }
                if (argv[i].equals("-labels")) {
                    enable_labels = true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            PicDisassembler.usage();
        }
        try {
            System.out.println("; hades.models.pic.PicDisassembler: " + argv[0]);
            FileInputStream hexfile = new FileInputStream(argv[0]);
            IntelHexFile parser = new IntelHexFile();
            long[] romdata = new long[1024];
            parser.parsePic16Bit(hexfile, romdata);
            PicDecode decoder = new PicDecode(new PicByteReg(null));
            StringBuffer sb = null;
            int i = 0;
            while (i < romdata.length) {
                decoder.decode((int)romdata[i]);
                sb = new StringBuffer();
                if (enable_addr) {
                    sb.append(HexFormat.getHexString(i, 4));
                }
                sb.append("  ");
                sb.append(decoder.disassemble());
                if (enable_decimal) {
                    // empty if block
                }
                if (enable_labels) {
                    // empty if block
                }
                if (enable_regs) {
                    // empty if block
                }
                if (enable_ascii) {
                    // empty if block
                }
                System.out.println(sb.toString());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("-E- PicDisassembler: " + e);
        }
        System.exit(0);
    }
}

