/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.utils.HexFormat;
import hades.utils.IntelHexFile;
import hades.utils.ShellSort;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PicAssembler {
    private boolean debug = false;
    Hashtable symbolTable;
    Hashtable symbolTypeTable;
    Hashtable opcodeArgsTable;
    Vector rawTokens;
    int[] instructionMemory;
    Hashtable labelTargetTable;
    Vector patchAddressVector;
    Vector patchLabelVector;
    int current_addr = 0;
    int max_addr = 0;
    String sourcefilename = null;
    public static final int T_UNDEFINED = -2;
    public static final int T_UNKNOWN = 1;
    public static final int T_OPCODE = 2;
    public static final int T_ORG = 3;
    public static final int T_EQU = 4;
    public static final int T_LABEL = 5;
    public static final int T_SHORTHAND = 6;
    public static final int T_INCLUDE = 11;
    public static final int T_LIST = 12;

    public PicAssembler() {
        this.createSymbolTable();
        this.createPicMetaSymbols();
        this.createPic16xxOpcodeSymbols();
        this.createPic16C84RegisterNameSymbols();
        this.createPicInstructionMemory();
    }

    public int getMemorySize() {
        return 1024;
    }

    public int getNOP() {
        return 0;
    }

    public void createPicInstructionMemory() {
        int n_words = this.getMemorySize();
        int nop = this.getNOP();
        this.instructionMemory = new int[n_words];
        int i = 0;
        while (i < n_words) {
            this.instructionMemory[i] = nop;
            ++i;
        }
    }

    public void createSymbolTable() {
        this.symbolTable = new Hashtable();
        this.symbolTypeTable = new Hashtable();
        this.opcodeArgsTable = new Hashtable();
    }

    public void createPicMetaSymbols() {
        try {
            this.addSymbol2("include", "include", 11);
            this.addSymbol2("list", "list", 12);
            this.addSymbol2("org", "org", 3);
            this.addSymbol2("equ", "equ", 4);
            this.addSymbol("=", "assign", 4);
        }
        catch (Exception e) {
            PicAssembler.msg("" + e);
        }
    }

    public void createPic16xxOpcodeSymbols() {
        try {
            this.addOpcodeSymbol("nop", "0x0000", 0);
            this.addOpcodeSymbol("return", "0x0008", 0);
            this.addOpcodeSymbol("retfie", "0x0009", 0);
            this.addOpcodeSymbol("sleep", "0x0063", 0);
            this.addOpcodeSymbol("clrwdt", "0x0064", 0);
            this.addOpcodeSymbol("movwf", "0x0080", 1);
            this.addOpcodeSymbol("clrw", "0x0100", 0);
            this.addOpcodeSymbol("clrf", "0x0180", 1);
            this.addOpcodeSymbol("subwf", "0x0200", 2);
            this.addOpcodeSymbol("decf", "0x0300", 2);
            this.addOpcodeSymbol("iorwf", "0x0400", 2);
            this.addOpcodeSymbol("andwf", "0x0500", 2);
            this.addOpcodeSymbol("xorwf", "0x0600", 2);
            this.addOpcodeSymbol("addwf", "0x0700", 2);
            this.addOpcodeSymbol("movf", "0x0800", 2);
            this.addOpcodeSymbol("comf", "0x0900", 2);
            this.addOpcodeSymbol("incf", "0x0a00", 2);
            this.addOpcodeSymbol("decfsz", "0x0b00", 2);
            this.addOpcodeSymbol("rrf", "0x0c00", 2);
            this.addOpcodeSymbol("rlf", "0x0d00", 2);
            this.addOpcodeSymbol("swapf", "0x0e00", 2);
            this.addOpcodeSymbol("incfsz", "0x0f00", 2);
            this.addOpcodeSymbol("bcf", "0x1000", 2);
            this.addOpcodeSymbol("bsf", "0x1400", 2);
            this.addOpcodeSymbol("btfsc", "0x1800", 2);
            this.addOpcodeSymbol("btfss", "0x1c00", 2);
            this.addOpcodeSymbol("call", "0x2000", 1);
            this.addOpcodeSymbol("goto", "0x2800", 1);
            this.addOpcodeSymbol("movlw", "0x3000", 1);
            this.addOpcodeSymbol("retlw", "0x3400", 1);
            this.addOpcodeSymbol("iorlw", "0x3800", 1);
            this.addOpcodeSymbol("andlw", "0x3900", 1);
            this.addOpcodeSymbol("xorlw", "0x3a00", 1);
            this.addOpcodeSymbol("sublw", "0x3c00", 1);
            this.addOpcodeSymbol("addlw", "0x3e00", 1);
        }
        catch (Exception e) {
            PicAssembler.msg("" + e);
        }
    }

    public void createPic16C84RegisterNameSymbols() {
        try {
            this.addSymbol2("indf", "0x00", 6);
            this.addSymbol2("tmr0", "0x01", 6);
            this.addSymbol2("pcl", "0x02", 6);
            this.addSymbol2("status", "0x03", 6);
            this.addSymbol2("fsr", "0x04", 6);
            this.addSymbol2("porta", "0x05", 6);
            this.addSymbol2("portb", "0x06", 6);
            this.addSymbol2("-noreg-", "0x07", 6);
            this.addSymbol2("eedata", "0x08", 6);
            this.addSymbol2("eeadr", "0x09", 6);
            this.addSymbol2("pclath", "0x0a", 6);
            this.addSymbol2("intcon", "0x0b", 6);
            this.addSymbol2("option", "0x01", 6);
            this.addSymbol2("option_reg", "0x01", 6);
            this.addSymbol2("trisa", "0x05", 6);
            this.addSymbol2("trisb", "0x06", 6);
            this.addSymbol2("eecon1", "0x08", 6);
            this.addSymbol2("eecon2", "0x09", 6);
            this.addSymbol("W", "0", 6);
            this.addSymbol("F", "1", 6);
            this.addSymbol("C", "0", 6);
            this.addSymbol("DC", "1", 6);
            this.addSymbol("Z", "2", 6);
            this.addSymbol("RP0", "5", 6);
            this.addSymbol("RP1", "6", 6);
            this.addSymbol("IRP", "7", 6);
            this.addSymbol("RBIF", "0", 6);
            this.addSymbol("INTF", "1", 6);
            this.addSymbol("T0IF", "2", 6);
            this.addSymbol("RBIE", "3", 6);
            this.addSymbol("INTE", "4", 6);
            this.addSymbol("T0IE", "5", 6);
            this.addSymbol("EEIE", "6", 6);
            this.addSymbol("GIE", "7", 6);
            this.addSymbol("RA0", "0", 6);
            this.addSymbol("RA1", "1", 6);
            this.addSymbol("RA2", "2", 6);
            this.addSymbol("RA3", "3", 6);
            this.addSymbol("RA4", "4", 6);
            this.addSymbol("RB0", "0", 6);
            this.addSymbol("RB1", "1", 6);
            this.addSymbol("RB2", "2", 6);
            this.addSymbol("RB3", "3", 6);
            this.addSymbol("RB4", "4", 6);
            this.addSymbol("RB5", "5", 6);
            this.addSymbol("RB6", "6", 6);
            this.addSymbol("RB7", "7", 6);
            this.addSymbol("PS0", "0", 6);
            this.addSymbol("PS1", "1", 6);
            this.addSymbol("PS2", "2", 6);
            this.addSymbol("PSA", "3", 6);
            this.addSymbol("T0SE", "4", 6);
            this.addSymbol("T0CS", "5", 6);
            this.addSymbol("INTEDG", "6", 6);
            this.addSymbol("nRBPU", "7", 6);
            this.addSymbol("RD", "0", 6);
            this.addSymbol("WR", "1", 6);
            this.addSymbol("WREN", "2", 6);
            this.addSymbol("WRERR", "3", 6);
            this.addSymbol("EEIF", "4", 6);
            int i = 0;
            while (i <= 47) {
                this.addSymbol("reg_" + HexFormat.getHexString(i, 2), "" + i, 6);
                ++i;
            }
        }
        catch (Exception e) {
            PicAssembler.msg("" + e);
        }
    }

    public void addSymbol(String key, Object value, int type) throws Exception {
        if (key == null) {
            throw new Exception("Trying to define a null symbol with value " + value);
        }
        if (value == null) {
            throw new Exception("Null value for symbol " + key);
        }
        if (this.symbolTable.containsKey(key)) {
            throw new Exception("Second definition for symbol " + key);
        }
        this.symbolTable.put(key, value);
        this.symbolTypeTable.put(key, new Integer(type));
    }

    public void addSymbol2(String key, Object value, int type) throws Exception {
        this.addSymbol(key, value, type);
        this.addSymbol(key.toUpperCase(), value, type);
    }

    public void addOpcodeSymbol(String key, String value, int n_args) throws Exception {
        Integer iv = new Integer(this.parseNumber(value));
        this.addSymbol(key, iv, 2);
        this.addSymbol(key.toUpperCase(), iv, 2);
        this.opcodeArgsTable.put(key, new Integer(n_args));
    }

    public int getSymbolType(String key) {
        if (this.symbolTypeTable.containsKey(key)) {
            return (Integer)this.symbolTypeTable.get(key);
        }
        return -2;
    }

    public boolean isOpcodeSymbol(String key) {
        return this.getSymbolType(key) == 2;
    }

    public boolean isEquSymbol(String key) {
        return this.getSymbolType(key) == 4;
    }

    public boolean isSymbol(String key) {
        return this.symbolTable.containsKey(key);
    }

    public String getSymbol(String key) {
        return (String)this.symbolTable.get(key);
    }

    public String printSymbolType(String key) {
        int type = this.getSymbolType(key);
        switch (type) {
            case -2: {
                return "T_UNDEFINED";
            }
            case 1: {
                return "T_UNKNOWN  ";
            }
            case 2: {
                return "T_OPCODE   ";
            }
            case 3: {
                return "T_ORG      ";
            }
            case 4: {
                return "T_EQU      ";
            }
            case 5: {
                return "T_LABEL    ";
            }
            case 6: {
                return "T_SHORTHAND";
            }
            case 11: {
                return "T_INCLUDE  ";
            }
            case 12: {
                return "T_LIST     ";
            }
        }
        return "T_UNDEFINED";
    }

    public void dumpSymbolTable(PrintStream ps) {
        ps.println("Symbol table dump: ");
        Enumeration e = this.symbolTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ps.println(key + " " + this.symbolTable.get(key) + " " + this.printSymbolType(key));
        }
    }

    public void defineLabel(String label, int address) throws Exception {
        if (this.symbolTable.get(label) != null) {
            if (this.getSymbolType(label) != 5) {
                throw new Exception("Illegal redefinition as a label: " + label);
            }
            if (this.getLabelAddress(label) >= 0) {
                throw new Exception("Redefining label address from " + this.getLabelAddress(label) + " to " + address);
            }
        }
        this.symbolTable.put(label, new Integer(address));
        this.symbolTypeTable.put(label, new Integer(5));
    }

    public int getLabelAddress(String label) throws Exception {
        if (this.getSymbolType(label) != 5) {
            throw new Exception("Not a label: " + label);
        }
        return (Integer)this.symbolTable.get(label);
    }

    public void parse(BufferedReader reader) {
        this.tokenize(reader);
        this.codegen();
        this.patchLabels();
    }

    public void writeRom(PrintWriter writer) throws Exception {
        PicAssembler.msg("# writing ROM data for PIC16C84 at " + new Date());
        int last_addr = 0;
        int NOP2 = this.getNOP();
        int i = 0;
        while (i < this.instructionMemory.length) {
            if (this.instructionMemory[i] != NOP2) {
                last_addr = i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 <= last_addr) {
            int addr = i2;
            int data = this.instructionMemory[i2];
            writer.println(HexFormat.getHexString(addr, 4) + ": " + HexFormat.getHexString(data, 4));
            ++i2;
        }
        this.writeRawLabels(writer);
        writer.flush();
        writer.close();
    }

    public void writeHex(PrintWriter writer) throws Exception {
        PicAssembler.msg("# writing HEX data for PIC16C84 at " + new Date());
        int last_addr = 0;
        int NOP2 = this.getNOP();
        int i = 0;
        while (i < this.instructionMemory.length) {
            if (this.instructionMemory[i] != NOP2) {
                last_addr = i;
            }
            ++i;
        }
        long[] hexMemory = new long[last_addr + 1];
        int i2 = 0;
        while (i2 <= last_addr) {
            hexMemory[i2] = this.instructionMemory[i2];
            ++i2;
        }
        try {
            new IntelHexFile().writeHexFile16Bit(writer, hexMemory);
        }
        catch (Exception e) {
            PicAssembler.msg("-E- Internal error while writing HEX file: " + e);
            e.printStackTrace();
        }
    }

    public void writeLabels(PrintWriter writer) throws Exception {
        PicAssembler.msg("# writing LBL data for PIC16C84 at " + new Date());
        this.writeRawLabels(writer);
        writer.flush();
        writer.close();
    }

    public void writeRawLabels(PrintWriter writer) throws Exception {
        Enumeration E = this.symbolTable.keys();
        while (E.hasMoreElements()) {
            String label = (String)E.nextElement();
            if (this.getSymbolType(label) != 5) continue;
            writer.println("#label " + HexFormat.getHexString(this.getLabelAddress(label), 4) + " " + label);
        }
    }

    public void writeSymbolTable(PrintWriter writer) throws Exception {
        int n_keys = this.symbolTable.size();
        String[] keys = new String[n_keys];
        int j = 0;
        Enumeration e = this.symbolTable.keys();
        while (e.hasMoreElements()) {
            keys[j] = (String)e.nextElement();
            ++j;
        }
        ShellSort.shellSort(keys);
        int i = 0;
        while (i < n_keys) {
            String key = keys[i];
            writer.println(this.flushLeft(key, 40) + " " + this.flushLeft(this.symbolTable.get(key), 20) + " " + this.printSymbolType(key));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public String flushLeft(Object o, int fieldsize) {
        String s = null;
        s = o instanceof String ? (String)o : o.toString();
        if (s.length() >= fieldsize) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        while (sb.length() < fieldsize) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void patchLabels() {
        if (this.debug) {
            PicAssembler.msg("-#- patchLabels...");
        }
        int n_patches = this.patchAddressVector.size();
        int addr = -1;
        String label = null;
        int i = 0;
        while (i < n_patches) {
            try {
                Object tmp;
                addr = (Integer)this.patchAddressVector.elementAt(i);
                label = (String)this.patchLabelVector.elementAt(i);
                if (this.debug) {
                    PicAssembler.msg("-I- patching at " + addr + " with " + label);
                }
                String s_offset = null;
                s_offset = this.isSymbol(label) ? ((tmp = this.symbolTable.get(label)) instanceof String ? (String)tmp : (tmp instanceof Integer ? "" + (Integer)tmp : tmp.toString())) : label;
                int i_offset = this.parseNumber(s_offset) & 0x3FF;
                int n = addr;
                this.instructionMemory[n] = this.instructionMemory[n] + i_offset;
            }
            catch (Exception e) {
                PicAssembler.msg("-E- patchLabels: " + e.getMessage());
                PicAssembler.msg("    at address " + addr + ", symbol/label is '" + label + "'");
            }
            ++i;
        }
    }

    public void codegen() {
        this.labelTargetTable = new Hashtable();
        this.patchAddressVector = new Vector();
        this.patchLabelVector = new Vector();
        this.current_addr = 0;
        Enumeration E = this.rawTokens.elements();
        while (E.hasMoreElements()) {
            String[] tokens = (String[])E.nextElement();
            try {
                if (tokens.length < 1) continue;
                if (tokens.length == 1) {
                    if (this.isOpcodeSymbol(tokens[0])) {
                        this.handleOpcode(tokens);
                        continue;
                    }
                    this.addStandaloneLabel(tokens);
                    continue;
                }
                if (this.isOpcodeSymbol(tokens[0])) {
                    this.handleOpcode(tokens);
                    continue;
                }
                if (this.isOpcodeSymbol(tokens[1])) {
                    this.handleLabelAndOpcode(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 3) {
                    this.handleOrgExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 12) {
                    this.handleListExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 11) {
                    this.handleIncludeExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[1]) == 4) {
                    this.handleEquExpression(tokens);
                    continue;
                }
                PicAssembler.msg("-W- don't know how to handle: ");
                this.printLineTokens(tokens);
            }
            catch (Exception e) {
                PicAssembler.msg("-E- codegen: " + e.getMessage());
                this.printLineTokens(tokens);
            }
        }
    }

    public void addStandaloneLabel(String[] tokens) throws Exception {
        String label;
        if (this.debug) {
            PicAssembler.msg("-I- addStandaloneLabel '" + tokens[0] + "' at " + HexFormat.getHexString(this.current_addr, 4));
        }
        if ((label = tokens[0]).endsWith(":")) {
            label = label.substring(0, label.length() - 1);
        }
        this.defineLabel(label, this.current_addr);
    }

    public void handleOpcode(String[] tokens) throws Exception {
        if (this.debug) {
            PicAssembler.msg("handleOpcode, addr= " + this.current_addr + " " + tokens[0]);
        }
        int new_instruction = 57005;
        String s_opcode = tokens[0];
        String s_register = null;
        String s_bitnumber = null;
        String s_literal = null;
        String s_wflag = null;
        int i_opcode = (Integer)this.symbolTable.get(s_opcode);
        int n_reqd_args = (Integer)this.opcodeArgsTable.get(s_opcode);
        int i_register = 0;
        int i_bitnumber = 0;
        int i_literal = 0;
        int i_wflag = 0;
        if (i_opcode >= 12288) {
            s_literal = this.isSymbol(tokens[1]) ? this.getSymbol(tokens[1]) : tokens[1];
            i_literal = this.parseNumber(s_literal);
            new_instruction = i_opcode + i_literal;
        } else if (i_opcode >= 8192) {
            new_instruction = i_opcode + 0;
            this.patchAddressVector.addElement(new Integer(this.current_addr));
            this.patchLabelVector.addElement(tokens[1]);
        } else if (i_opcode >= 4096) {
            s_register = this.isSymbol(tokens[1]) ? this.getSymbol(tokens[1]) : tokens[1];
            s_bitnumber = this.isSymbol(tokens[2]) ? this.getSymbol(tokens[2]) : tokens[2];
            i_register = this.parseNumber(s_register);
            i_bitnumber = this.parseNumber(s_bitnumber);
            new_instruction = i_opcode + i_register + (i_bitnumber << 7);
        } else if (n_reqd_args == 0) {
            new_instruction = i_opcode;
        } else if (n_reqd_args == 1) {
            s_register = this.isSymbol(tokens[1]) ? this.getSymbol(tokens[1]) : tokens[1];
            i_register = this.parseNumber(s_register);
            new_instruction = i_opcode + i_register;
        } else {
            s_register = this.isSymbol(tokens[1]) ? this.getSymbol(tokens[1]) : tokens[1];
            s_wflag = tokens.length == 3 ? (this.isSymbol(tokens[2]) ? this.getSymbol(tokens[2]) : tokens[2]) : "1";
            i_register = this.parseNumber(s_register);
            i_wflag = this.parseNumber(s_wflag);
            new_instruction = i_opcode + i_register + (i_wflag << 7);
        }
        this.instructionMemory[this.current_addr] = new_instruction;
        ++this.current_addr;
        ++this.max_addr;
    }

    public void handleLabelAndOpcode(String[] tokens) throws Exception {
        if (this.debug) {
            PicAssembler.msg("-I- handleLabelAndOpcode...");
            this.printLineTokens(tokens);
        }
        this.defineLabel(tokens[0], this.current_addr);
        String[] shiftedTokens = new String[tokens.length - 1];
        int i = 0;
        while (i < shiftedTokens.length) {
            shiftedTokens[i] = tokens[i + 1];
            ++i;
        }
        this.handleOpcode(shiftedTokens);
    }

    public void handleListExpression(String[] tokens) throws Exception {
        PicAssembler.msg("-W- Ignoring 'list' directive: ");
    }

    public void handleIncludeExpression(String[] tokens) throws Exception {
        if (tokens[1].indexOf("p16c84.inc") <= 0) {
            PicAssembler.msg("-E- #include <file> not supported for: " + tokens[1]);
            throw new Exception("Cannot include file " + tokens[1]);
        }
        PicAssembler.msg("-W- Cannot include 'p16c84.inc', but PIC16C84 constants are predefined!");
    }

    public void handleOrgExpression(String[] tokens) throws Exception {
        if (this.debug) {
            PicAssembler.msg("-W- handleOrgExpression not fully supported!");
            this.printLineTokens(tokens);
        }
        int addr = -1;
        addr = this.isSymbol(tokens[1]) ? this.parseNumber(this.getSymbol(tokens[1])) : this.parseNumber(tokens[1]);
        this.current_addr = addr;
        if (this.instructionMemory[addr] != this.getNOP()) {
            PicAssembler.msg("-W- ORG directive overwrites memory at " + HexFormat.getHexString(addr, 4));
        }
    }

    public void handleEquExpression(String[] tokens) throws Exception {
        if (this.debug) {
            PicAssembler.msg("-W- handleEquExpression not fully supported!");
            this.printLineTokens(tokens);
        }
        if (this.isSymbol(tokens[2])) {
            this.addSymbol(tokens[0], this.getSymbol(tokens[2]), 1);
        } else {
            this.addSymbol(tokens[0], tokens[2], 1);
        }
    }

    public void tokenize(BufferedReader reader) {
        Vector<String[]> allTokens = new Vector<String[]>();
        String line = null;
        String[] tokens = null;
        try {
            while ((line = reader.readLine()) != null) {
                tokens = this.tokenizeLine(line = this.stripComments(line));
                if (tokens.length < 1) continue;
                allTokens.addElement(tokens);
            }
        }
        catch (Exception e) {
            PicAssembler.msg("-E- internal error: " + e);
        }
        this.rawTokens = allTokens;
    }

    public void dumpRawTokens(Vector rawTokens) {
        Enumeration e = rawTokens.elements();
        while (e.hasMoreElements()) {
            String[] lineTokens = (String[])e.nextElement();
            this.printLineTokens(lineTokens);
        }
    }

    public String[] tokenizeLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t;,");
        int n_tokens = tokenizer.countTokens();
        String[] tokens = new String[n_tokens];
        int i = 0;
        while (i < n_tokens) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    public void printLineTokens(String[] tokens) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            sb.append(tokens[i] + " ");
            ++i;
        }
        PicAssembler.msg(sb.toString());
    }

    public String stripComments(String line) {
        int firstSemicolon = line.indexOf(59);
        if (firstSemicolon >= 0) {
            line = line.substring(0, firstSemicolon).trim();
        }
        return line;
    }

    public int parseNumber(String s) {
        String t = s.trim().toLowerCase();
        int value = 0;
        try {
            value = t.startsWith("0b") ? Integer.parseInt(t.substring(2), 2) : (t.startsWith("0d") ? Integer.parseInt(t.substring(2), 10) : (t.startsWith("0x") ? Integer.parseInt(t.substring(2), 16) : (t.startsWith("b'") ? Integer.parseInt(t.substring(2, t.length() - 1), 2) : (t.startsWith("d'") ? Integer.parseInt(t.substring(2, t.length() - 1), 10) : (t.startsWith("x'") ? Integer.parseInt(t.substring(2, t.length() - 1), 16) : (t.startsWith("h'") ? Integer.parseInt(t.substring(2, t.length() - 1), 16) : (t.startsWith("'") ? (int)s.trim().charAt(1) : (t.startsWith(".") ? Integer.parseInt(t.substring(1)) : (t.endsWith("h") ? Integer.parseInt(t.substring(0, t.length() - 1), 16) : (t.endsWith("b") ? Integer.parseInt(t.substring(0, t.length() - 1), 2) : Integer.parseInt(t)))))))))));
            return value;
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("wrong number format or undefined symbol: '" + s + "'");
        }
    }

    public void setOptions(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-debug")) {
                this.debug = true;
            }
            ++i;
        }
    }

    public void setFilename(String sourcefilename) {
        this.sourcefilename = sourcefilename;
    }

    public String getFilename() {
        return this.sourcefilename;
    }

    public void getReader() {
    }

    public PrintWriter getPrintWriter(String suffix) throws Exception {
        String fname = null;
        String asm_name = this.getFilename();
        fname = asm_name.endsWith(".asm") ? asm_name.substring(0, asm_name.length() - 4) + suffix : this.getFilename() + suffix;
        return new PrintWriter(new FileWriter(fname));
    }

    public void usage() {
        PicAssembler.msg("Usage:  <java> hades.models.pic.PicAssembler <filename.asm> [options]\nwhere <java> specifies the JVM and CLASSPATH to use, and \noptions include:\n-symbols    write <filename.sym> symbol table\n-rom        write <filename.rom> rom data instead of .HEX data\n-debug      enable verbose output\n \nExample: <java> hades.models.pic.PicAssembler yourpath/yourfile.asm\nwhich creates yourpath/yourfile.hex\n");
        System.exit(1);
    }

    public void copyright() {
        PicAssembler.msg("Hades Assembler for Arizona Microchip PIC controllers\n(C) 1999-2005 FNH, University of Hamburg, Informatik\n ");
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] argv) {
        block9: {
            PicAssembler asm = new PicAssembler();
            asm.copyright();
            if (argv.length < 1) {
                asm.usage();
            }
            asm.setFilename(argv[0]);
            asm.setOptions(argv);
            BufferedReader reader = null;
            asm.parse(new BufferedReader(new FileReader(argv[0])));
            asm.writeRom(asm.getPrintWriter(".rom"));
            asm.writeHex(asm.getPrintWriter(".hex"));
            asm.writeLabels(asm.getPrintWriter(".lbl"));
            asm.writeSymbolTable(asm.getPrintWriter(".sym"));
            Object var5_3 = null;
            try {
                reader.close();
            }
            catch (Exception ee) {}
            break block9;
            {
                catch (Exception e) {
                    System.out.println("-E- got an exception: " + e);
                    e.printStackTrace();
                    asm.usage();
                    Object var5_4 = null;
                    try {
                        reader.close();
                    }
                    catch (Exception ee) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    reader.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

