/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicByteReg;
import hades.models.pic.PicCalc;
import hades.models.pic.PicCalcADDWF;
import hades.models.pic.PicCalcANDWF;
import hades.models.pic.PicCalcCLR;
import hades.models.pic.PicCalcCOMF;
import hades.models.pic.PicCalcDECF;
import hades.models.pic.PicCalcDECFSZ;
import hades.models.pic.PicCalcINCF;
import hades.models.pic.PicCalcINCFSZ;
import hades.models.pic.PicCalcIORWF;
import hades.models.pic.PicCalcMOVF;
import hades.models.pic.PicCalcMOVLW;
import hades.models.pic.PicCalcMOVWF;
import hades.models.pic.PicCalcRLF;
import hades.models.pic.PicCalcRRF;
import hades.models.pic.PicCalcSUBWF;
import hades.models.pic.PicCalcSWAPF;
import hades.models.pic.PicCalcXORWF;

public class PicAlu {
    private PicCalc[] calcReg;
    private PicCalc[] calcLiteral;
    private PicByteReg statusReg;
    private boolean skip = false;
    private int op1 = 0;
    private int op2 = 0;
    private int result = 0;
    private int opcode = 0;

    public PicAlu(PicByteReg _statusReg) {
        this.statusReg = _statusReg;
        this.calcReg = new PicCalc[16];
        this.calcLiteral = new PicCalc[16];
        this.calcReg[0] = new PicCalcMOVWF(this.statusReg);
        this.calcReg[1] = new PicCalcCLR(this.statusReg);
        this.calcReg[2] = new PicCalcSUBWF(this.statusReg);
        this.calcReg[3] = new PicCalcDECF(this.statusReg);
        this.calcReg[4] = new PicCalcIORWF(this.statusReg);
        this.calcReg[5] = new PicCalcANDWF(this.statusReg);
        this.calcReg[6] = new PicCalcXORWF(this.statusReg);
        this.calcReg[7] = new PicCalcADDWF(this.statusReg);
        this.calcReg[8] = new PicCalcMOVF(this.statusReg);
        this.calcReg[9] = new PicCalcCOMF(this.statusReg);
        this.calcReg[10] = new PicCalcINCF(this.statusReg);
        this.calcReg[11] = new PicCalcDECFSZ(this.statusReg);
        this.calcReg[12] = new PicCalcRRF(this.statusReg);
        this.calcReg[13] = new PicCalcRLF(this.statusReg);
        this.calcReg[14] = new PicCalcSWAPF(this.statusReg);
        this.calcReg[15] = new PicCalcINCFSZ(this.statusReg);
        this.calcLiteral[0] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[1] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[2] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[3] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[4] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[5] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[6] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[7] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[8] = new PicCalcIORWF(this.statusReg);
        this.calcLiteral[9] = new PicCalcANDWF(this.statusReg);
        this.calcLiteral[10] = new PicCalcXORWF(this.statusReg);
        this.calcLiteral[11] = new PicCalcMOVLW(this.statusReg);
        this.calcLiteral[12] = new PicCalcSUBWF(this.statusReg);
        this.calcLiteral[13] = new PicCalcSUBWF(this.statusReg);
        this.calcLiteral[14] = new PicCalcADDWF(this.statusReg);
        this.calcLiteral[15] = new PicCalcADDWF(this.statusReg);
        this.por();
    }

    public void por() {
        this.reset();
    }

    public void reset() {
        this.skip = false;
        this.op1 = 0;
        this.op2 = 0;
        this.result = 0;
        this.opcode = 0;
    }

    public void setSkip(boolean newSkip) {
        this.skip = newSkip;
    }

    public boolean getSkip() {
        return this.skip;
    }

    public int alu(int instruction, int operand1, int operand2) {
        this.opcode = instruction & 0xF;
        this.op1 = operand1 & 0xFF;
        this.op2 = operand2 & 0xFF;
        this.skip = false;
        if (this.op1 < 0 || this.op2 < 0) {
            return -2;
        }
        this.result = this.calcReg[this.opcode].calc(this.op1, this.op2);
        this.skip = this.calcReg[this.opcode].getSkip();
        this.result = this.result + 256 & 0xFF;
        return this.result;
    }

    public int literalAlu(int instruction, int operand1, int operand2) {
        this.opcode = instruction & 0xF;
        this.op1 = operand1 & 0xFF;
        this.op2 = operand2 & 0xFF;
        this.skip = false;
        if (this.op1 < 0 || this.op2 < 0) {
            return -2;
        }
        this.result = this.calcLiteral[this.opcode].calc(this.op1, this.op2);
        this.result = this.result + 256 & 0xFF;
        return this.result;
    }

    public int bitAlu(int instruction, int operand, int bitNumber) {
        this.opcode = instruction;
        this.op1 = operand;
        this.skip = false;
        if (this.opcode == 0) {
            this.result = this.op1 & ~(1 << bitNumber);
        } else if (this.opcode == 1) {
            this.result = this.op1 | 1 << bitNumber;
        } else if (this.opcode == 2) {
            this.result = this.op1;
            this.skip = (this.op1 & 1 << bitNumber) == 0;
        } else if (this.opcode == 3) {
            this.result = this.op1;
            this.skip = (this.op1 & 1 << bitNumber) != 0;
        }
        return this.result;
    }
}

