/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.gui.MemoryHexEditorField;
import hades.gui.PropertySheet;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.models.pic.PicMemory;
import hades.models.pic.PicNoReg;
import hades.models.pic.PicReg;
import hades.models.pic.PicRegBank;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import jfig.gui.ImageHelper;

public class HexMemoryCanvas
extends MemoryHexEditorField {
    protected PicMemory memory;
    protected boolean[] noRegMap = null;

    public HexMemoryCanvas(PicMemory memory, int n_rows, int n_words_per_row) {
        super(new MemoryWrapper(memory), n_words_per_row);
        this.memory = memory;
        if (memory instanceof PicRegBank) {
            PicReg[] regs = ((PicRegBank)memory).reg;
            this.noRegMap = new boolean[regs.length];
            int i = 0;
            while (i < regs.length) {
                if (regs[i] instanceof PicNoReg) {
                    this.noRegMap[i] = true;
                }
                ++i;
            }
        }
    }

    public void smartUpdate() {
        this.repaint(50L);
    }

    public long getData(int addr) {
        addr = this.clip(addr, 0, this.memory.getMemorySize() - 1);
        try {
            if (this.noRegMap != null && this.noRegMap[addr]) {
                return -1L;
            }
            return this.memory.readMemory(addr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void setData(int addr, long value) {
        addr = this.clip(addr, 0, this.memory.getMemorySize() - 1);
        this.memory.writeMemory(addr, (int)value);
        this.notifyListeners(addr, value);
    }

    public static void main(String[] argv) {
        PicMemory mem = new PicMemory(){
            int[] data = new int[1024];

            public int getWordWidth() {
                return 8;
            }

            public int getMemorySize() {
                return 1024;
            }

            public int readMemory(int address) {
                return this.data[address];
            }

            public void writeMemory(int address, int word) {
                this.data[address] = word;
            }
        };
        Frame f = new Frame("HexMemoryCanvas Demo");
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
        ImageHelper.setVisibleParent(f);
        HexMemoryCanvas mhe = new HexMemoryCanvas(mem, 16, 8);
        mhe.setBackground(Color.black);
        mhe.setDataColor(Color.yellow);
        mhe.setAddrColor(Color.green);
        mhe.setTextFont(new Font("SansSerif", 0, 12));
        mhe.setReadHighlightAddress(15);
        mhe.setWriteHighlightAddress(14);
        f.setLayout(new FlowLayout());
        f.add(mhe);
        f.pack();
        mhe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemoryHexEditorField.msg("-I- action event: " + evt.getActionCommand());
            }
        });
    }

    private static class MemoryWrapper
    implements Memory {
        private PicMemory memoryObject = null;

        MemoryWrapper(PicMemory memoryObject) {
            this.memoryObject = memoryObject;
        }

        public int getBitsPerWord() {
            return this.memoryObject.getWordWidth();
        }

        public int getSize() {
            return this.memoryObject.getMemorySize();
        }

        public long getDataAt(int address) {
            return this.memoryObject.readMemory(address);
        }

        public void setDataAt(int address, long value) {
            this.memoryObject.writeMemory(address, (int)(value & 0xFFFFFFFFFFFFFFFFL));
        }

        public void setSize(int n_words) {
        }

        public void setBitsPerWord(int n_bits) {
        }

        public int getAddrOffset() {
            return 0;
        }

        public boolean canChangeSize() {
            return false;
        }

        public boolean resize(int n_words, int n_bits) {
            return false;
        }

        public long[] getDataArray() {
            return null;
        }

        public void setDataArray(long[] data) {
        }

        public boolean parse(BufferedReader reader) {
            return true;
        }

        public boolean merge(BufferedReader reader) {
            return true;
        }

        public boolean save(PrintWriter pw) {
            return true;
        }

        public String getResourcename() {
            return null;
        }

        public void setResourcename(String name) {
        }

        public PropertySheet getConfigDialog() {
            return null;
        }

        public void addMemoryListener(MemoryListener ML) {
        }

        public void removeMemoryListener(MemoryListener ML) {
        }
    }
}

