/*
 * Decompiled with CFR 0.152.
 */
package hades.models.microjava;

import hades.manager.DesignManager;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.MR;
import hades.models.rtlib.memory.MREditorFrame;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import hades.utils.ValidName;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class MROM
extends MR {
    protected PortStdLogicVector port_ALU;
    protected PortStdLogicVector port_BusA;
    private static String[] d_names = new String[]{"JOPC", "JMPZ", "JMPN", "wrPC", "wrCPP", "wrLV", "wrSP", "wrTOS", "wrA", "wrB", "wrMWR", "wrMAR", "rdB", "rdMRR", "s", "m16", "m8", "RD", "WR"};
    static String[] labels = new String[]{"              Bus_A            write C bus        rd B bus              ", "              1.PC                                                      ", "              2.CPP                                    IFU              ", "       n      3.LV  J J J                                               ", "       e    A 4.SP  O M M     C     T       M M     M                   ", "       x    L 5.A   P P P   P P L S O       W A     R   1     R W       ", "addr   t    U 6.TOS C Z N   C P V P S   A B R R   B R s 6 8   D R   name"};

    public MROM() {
        this.cache_read_addr = -13;
    }

    public void setDSize() {
        this.D_SIZE = d_names.length;
    }

    public boolean initialize(String s) {
        boolean rt;
        block2: {
            rt = super.initialize(s);
            this.resourcename = "microcode.rom";
            if (!rt) break block2;
            try {
                InputStream inputStream = DesignManager.getDesignManager().getInputStream(this, this.resourcename);
                this.parse(new BufferedReader(new InputStreamReader(inputStream)));
            }
            catch (Exception e) {
                this.message("-F- Internal: " + e);
                this.message("    resourcename=" + this.resourcename);
                rt = false;
            }
        }
        return rt;
    }

    public void createTypesAndFieldsAndMemory() {
        this.n_words = 1024;
        this.n_fields = 3 + this.D_SIZE;
        this.alabel = new String[this.n_words];
        this.flength = new int[this.n_fields];
        this.flabel = new String[this.n_fields];
        this.fseparator = new boolean[this.n_fields];
        int f = 0;
        this.createField(f++, 9, "next");
        this.createField(f++, 4, "ALU");
        this.createField(f++, 3, "BusA");
        int j = 0;
        while (j < this.D_SIZE) {
            this.createField(f++, 1, d_names[j]);
            ++j;
        }
        this.fdata = new int[this.n_words][this.n_fields];
        int i = 0;
        while (i < this.n_words) {
            this.alabel[i] = "" + i;
            ++i;
        }
        this.fseparator[1] = true;
        this.fseparator[2] = true;
        this.fseparator[3] = true;
        this.fseparator[6] = true;
        this.fseparator[11] = true;
        this.fseparator[15] = true;
        this.fseparator[20] = true;
    }

    public void setData(int addr, int field, int value) {
        this.fdata[addr][field] = value & MR.lengthMask[this.flength[field]];
        this.cache_read_addr = -12;
    }

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, 10);
        this.port_X = new PortStdLogicVector((SimObject)this, "X", 1, null, 10);
        this.port_ALU = new PortStdLogicVector((SimObject)this, "ALU", 1, null, 4);
        this.port_BusA = new PortStdLogicVector((SimObject)this, "BusA", 1, null, 3);
        this.port_D = new PortStdLogic1164[this.D_SIZE];
        int i = 0;
        while (i < this.D_SIZE) {
            this.port_D[i] = new PortStdLogic1164(this, "D" + i, 1, null);
            ++i;
        }
        this.ports = new Port[this.D_SIZE + 4];
        i = 0;
        while (i < this.D_SIZE) {
            this.ports[i] = this.port_D[i];
            ++i;
        }
        this.ports[i++] = this.port_X;
        this.ports[i++] = this.port_ALU;
        this.ports[i++] = this.port_BusA;
        this.ports[i++] = this.port_A;
    }

    public boolean parseRedundant(BufferedReader reader) throws Exception {
        block8: {
            if (reader == null) {
                return false;
            }
            String line = null;
            int addr = 0;
            LineNumberReader br = null;
            try {
                br = new LineNumberReader(reader);
                line = br.readLine();
                if (!line.startsWith("#MicroROM data")) {
                    this.message("-E- Not a microcode data file! ");
                    this.message("...expected '#MicroROM data' on line 1,");
                    this.message("...but got '" + line + "'");
                    return true;
                }
                line = br.readLine();
                StringTokenizer st = new StringTokenizer(line);
                this.n_words = Integer.parseInt(st.nextToken());
                this.n_fields = Integer.parseInt(st.nextToken());
                line = br.readLine();
                st = new StringTokenizer(line);
                while ((line = br.readLine()) != null) {
                    if (line != null) {
                        if (line.startsWith("#") || line.startsWith(";")) continue;
                        st = new StringTokenizer(line, " \t\r:");
                        addr = Integer.parseInt(st.nextToken(), 16);
                        int f = 0;
                        while (f < this.n_fields) {
                            this.setData(addr, f, Integer.parseInt(st.nextToken(), 16));
                            ++f;
                        }
                        this.setStateLabel(addr, ValidName.decodeUnicodeEscapes(st.nextToken()));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.message("-E- Not a valid microcode file: " + e);
                if (br != null) {
                    this.message("on line " + br.getLineNumber() + " '" + line + "'");
                    break block8;
                }
                this.message("error near input '" + line + "'");
            }
        }
        return true;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        if (vector_A.has_UXZ()) {
            int addr = -1;
            this.cache_read_addr = -12;
        } else {
            int addr = (int)vector_A.getValue();
            this.notifyReadListeners(addr, 0L);
            int i = 0;
            while (i < this.D_SIZE) {
                if (this.checkChange(addr, i + 3)) {
                    this.scheduleSingleOutput(this.port_D[i], this.getData(addr, i + 3), time);
                }
                ++i;
            }
            if (this.checkChange(addr, 0)) {
                this.schedulePortOutput(this.port_X, this.getData(addr, 0), time);
            }
            if (this.checkChange(addr, 1)) {
                this.schedulePortOutput(this.port_ALU, this.getData(addr, 1), time);
            }
            if (this.checkChange(addr, 2)) {
                this.schedulePortOutput(this.port_BusA, this.getData(addr, 2), time);
            }
            this.cache_read_addr = addr;
        }
        if (this.enableAnimationFlag && this.symbol != null && this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    boolean checkChange(int addr, int field) {
        boolean b;
        if (this.cache_read_addr < 0) {
            b = true;
        } else {
            boolean bl = b = this.getData(addr, field) != this.getData(this.cache_read_addr, field);
        }
        if (SimObject.debug) {
            System.out.println("-F- checkChange: " + addr + " " + this.cache_read_addr + " " + field + " " + b);
        }
        return b;
    }

    public void configure() {
        if (this.MEF == null) {
            int n_lines = Math.min(this.n_words, 32);
            this.MEF = new MREditorFrame(this, n_lines, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
            this.MEF.setLabels(labels);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }
}

