/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.MemoryHexEditorField;
import hades.models.mcs4.MemoryWrapper;
import hades.models.mcs4.i4002;
import hades.models.rtlib.memory.RAM;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

class i4002EditorFrame
extends JDialog {
    private i4002 chip;
    private MemoryHexEditorField[] regFields;
    private MemoryHexEditorField[] statusRegFields;

    public i4002EditorFrame(i4002 chip) {
        super(chip.getEditor().getFrame(), chip.getName());
        this.chip = chip;
        this.init();
        this.constructDialog();
    }

    private void init() {
        RAM[] registers = this.chip.getRegister();
        i4002.InternalRam[] statusRegs = this.chip.getStatusRegisters();
        this.regFields = new MemoryHexEditorField[registers.length];
        this.statusRegFields = new MemoryHexEditorField[statusRegs.length];
        int i = 0;
        while (i < registers.length) {
            RAM register = registers[i];
            this.regFields[i] = new MemoryHexEditorField(register, 1);
            register.addMemoryListener(new MemoryWrapper(this.regFields[i]));
            i4002.InternalRam statusChar = statusRegs[i];
            this.statusRegFields[i] = new MemoryHexEditorField(statusChar, 1);
            statusChar.addMemoryListener(new MemoryWrapper(this.statusRegFields[i]));
            ++i;
        }
    }

    private void constructDialog() {
        this.getContentPane().setLayout(new GridBagLayout());
        int i = 0;
        while (i < this.regFields.length) {
            JLabel fieldName = new JLabel("Register " + i);
            this.getContentPane().add((Component)fieldName, new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
            this.getContentPane().add((Component)this.regFields[i], new GridBagConstraints(i, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            JLabel statusName = new JLabel("Status " + i);
            this.getContentPane().add((Component)statusName, new GridBagConstraints(i, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.statusRegFields[i], new GridBagConstraints(i, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++i;
        }
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                i4002EditorFrame.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)closeButton, new GridBagConstraints(this.regFields.length - 1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

