/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcs4.AbstractIntel4000;
import hades.models.mcs4.Instruction;
import hades.models.mcs4.InstructionSet;
import hades.models.mcs4.InternalState;
import hades.models.mcs4.i4002EditorFrame;
import hades.models.rtlib.memory.RAM;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class i4002
extends AbstractIntel4000 {
    public String type = "4002-1";
    private int id = 0;
    private PortStdLogic1164 port_SYNC;
    private PortStdLogic1164 port_O0;
    private PortStdLogic1164 port_O1;
    private PortStdLogic1164 port_O2;
    private PortStdLogic1164 port_O3;
    private PortStdLogic1164 port_CM;
    private PortStdLogic1164 port_P0;
    private InternalRam[] regs = new InternalRam[4];
    private InternalRam[] statusRegs = new InternalRam[4];
    private InstructionSet instructions = InstructionSet.getInstance();
    private Instruction memoryInstruction;
    private StdLogicVector register = new StdLogicVector(2);
    private StdLogicVector address = new StdLogicVector(4);
    private StdLogicVector dataBuffer = new StdLogicVector(4);
    private StdLogicVector oBuffer = new StdLogicVector(4);
    private i4002EditorFrame configFrame = null;
    private boolean chipSelected = false;
    private boolean srcCycle = false;
    private int resetCounter = 0;

    public i4002() {
        this.port_SYNC = new PortStdLogic1164(this, "SYNC", 0, null);
        this.port_O0 = new PortStdLogic1164(this, "O0", 1, null);
        this.port_O1 = new PortStdLogic1164(this, "O1", 1, null);
        this.port_O2 = new PortStdLogic1164(this, "O2", 1, null);
        this.port_O3 = new PortStdLogic1164(this, "O3", 1, null);
        this.port_CM = new PortStdLogic1164(this, "CM", 0, null);
        this.port_P0 = new PortStdLogic1164(this, "P0", 0, null);
        this.ports[7] = this.port_SYNC;
        this.ports[8] = this.port_O0;
        this.ports[9] = this.port_O1;
        this.ports[10] = this.port_O2;
        this.ports[11] = this.port_O3;
        this.ports[13] = this.port_CM;
        this.ports[14] = this.port_P0;
        int i = 0;
        while (i < this.regs.length) {
            this.regs[i] = new InternalRam();
            this.regs[i].resize(16, 4);
            this.statusRegs[i] = new InternalRam();
            this.statusRegs[i].resize(4, 4);
            ++i;
        }
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.chipSelected = false;
        this.srcCycle = false;
        this.memoryInstruction = null;
        int i = 0;
        while (i < this.regs.length) {
            this.regs[i].initializeWithZeroes();
            this.statusRegs[i].initializeWithZeroes();
            ++i;
        }
        this.oBuffer.setValue(0L);
        this.sendIO();
    }

    private void setId() {
        this.id = "4002-1".equals(this.type) ? (this.port_P0.getValueOrU().is_1H() ? 0 : 1) : (this.port_P0.getValueOrU().is_1H() ? 2 : 3);
    }

    private void sendIO() {
        int i = 0;
        while (i < 4) {
            if (this.ports[i + 8].getSignal() != null) {
                this.createEvent((PortStdLogic1164)this.ports[i + 8], this.oBuffer.getBitAt(i));
            }
            ++i;
        }
    }

    protected void stateChanged(InternalState state) {
        if (this.resetCounter > 0) {
            if (this.resetCounter == 1) {
                this.register.setValue(0L);
                this.address.setValue(0L);
                this.dataBuffer.setValue(0L);
                this.oBuffer.setValue(0L);
                this.sendIO();
                this.srcCycle = false;
                this.chipSelected = false;
                this.setHasOutputData(false);
                this.memoryInstruction = null;
            }
            if (this.resetCounter < 17) {
                int i = 0;
                while (i < 4) {
                    this.regs[i].setDataAt(this.resetCounter, 0L);
                    ++i;
                }
            } else if (this.resetCounter < 21) {
                this.statusRegs[1].setDataAt(this.resetCounter - 16, 0L);
            } else if (this.resetCounter < 25) {
                this.statusRegs[2].setDataAt(this.resetCounter - 20, 0L);
            } else if (this.resetCounter < 29) {
                this.statusRegs[3].setDataAt(this.resetCounter - 24, 0L);
            } else {
                this.statusRegs[4].setDataAt(this.resetCounter - 28, 0L);
            }
        } else if (state == InternalState.X2) {
            if (this.memoryInstruction == InstructionSet.SBM || this.memoryInstruction == InstructionSet.RDM || this.memoryInstruction == InstructionSet.ADM) {
                this.setHasOutputData(true);
                this.dataBuffer.setValue(this.regs[(int)this.register.getValue()].getDataAt((int)this.address.getValue()));
            } else if (this.memoryInstruction == InstructionSet.RD0 || this.memoryInstruction == InstructionSet.RD1 || this.memoryInstruction == InstructionSet.RD2 || this.memoryInstruction == InstructionSet.RD3) {
                this.setHasOutputData(true);
                int charNr = this.memoryInstruction.getOPA() & 3;
                this.dataBuffer.setValue(this.statusRegs[(int)this.register.getValue()].getDataAt(charNr));
            }
        } else if (state == InternalState.X3) {
            this.setHasOutputData(false);
            this.memoryInstruction = null;
        }
    }

    protected void receiveData(InternalState state) {
        if (this.port_SYNC.getValueOrU().is_0()) {
            state = InternalState.X3;
            this.setState(state);
        }
        if (state == InternalState.M2 && this.port_CM.getValueOrU().is_0() && this.chipSelected) {
            Integer opaCode = new Integer((int)this.receiveData().getValue());
            this.memoryInstruction = this.instructions.getMemoryInstruction(opaCode);
        } else if (state == InternalState.X2) {
            if (this.port_CM.getValueOrU().is_0()) {
                boolean bl = this.chipSelected = this.receiveData().getValue() >> 2 == (long)this.id;
                if (this.chipSelected) {
                    this.srcCycle = true;
                    this.register.setValue(this.receiveData().getValue() & 3L);
                }
            }
            if (this.memoryInstruction == InstructionSet.WMP) {
                this.oBuffer.setValue(this.receiveData().getValue());
                this.sendIO();
            } else if (this.memoryInstruction == InstructionSet.WRM) {
                this.regs[(int)this.register.getValue()].setDataAt((int)this.address.getValue(), this.receiveData().getValue());
            } else if (this.memoryInstruction == InstructionSet.WR0 || this.memoryInstruction == InstructionSet.WR1 || this.memoryInstruction == InstructionSet.WR2 || this.memoryInstruction == InstructionSet.WR3) {
                int charNr = this.memoryInstruction.getOPA() & 3;
                InternalRam statusTmp = this.statusRegs[(int)this.register.getValue()];
                statusTmp.setDataAt(charNr, this.receiveData().getValue());
            }
        } else if (state == InternalState.X3 && this.srcCycle) {
            if (this.getReset().is_0()) {
                if (this.resetCounter < 32) {
                    ++this.resetCounter;
                }
            } else if (this.resetCounter > 0) {
                this.resetCounter = 0;
            } else {
                this.address.setValue(this.receiveData().getValue());
                this.srcCycle = false;
            }
        }
    }

    protected StdLogicVector getOutputData() {
        return this.dataBuffer;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        st.nextToken();
        if (st.hasMoreTokens()) {
            this.setType(st.nextToken());
        }
        return true;
    }

    public void write(PrintWriter ps) {
        super.write(ps);
        ps.print(" " + this.type);
    }

    public void configure() {
        if (this.configFrame == null) {
            this.configFrame = new i4002EditorFrame(this);
        }
        if (!this.configFrame.isVisible()) {
            this.configFrame.pack();
            this.configFrame.setVisible(true);
        }
        this.propertySheet = PropertySheet.getPropertySheet(this, null);
        this.propertySheet.setVisible(true);
    }

    RAM[] getRegister() {
        return this.regs;
    }

    InternalRam[] getStatusRegisters() {
        return this.statusRegs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
        this.setId();
    }

    public void evaluate(Object arg) {
        if (this.port_P0.hasEvent()) {
            this.setId();
        }
        super.evaluate(arg);
    }

    private class InternalRam
    extends RAM {
        private InternalRam() {
        }

        public long getDataAt(int address) {
            long data = super.getDataAt(address);
            this.notifyReadListeners(address, data);
            return data;
        }

        public void setDataAt(int address, long value) {
            long oldValue = this.getDataAt(address);
            super.setDataAt(address, value);
            this.notifyWriteListeners(address, oldValue, value);
        }

        public void initializeWithZeroes() {
            super.initializeWithZeroes();
            this.notifyReadListeners(-1, 0L);
            this.notifyWriteListeners(-1, 0L, 0L);
        }
    }
}

