/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.utils.HexFormat;
import hades.utils.IntelHexFile;
import hades.utils.ShellSort;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MCS4Assembler {
    private boolean debug = false;
    Hashtable symbolTable;
    Hashtable symbolTypeTable;
    Hashtable opcodeArgsTable;
    Vector rawTokens;
    int[] instructionMemory;
    Hashtable labelTargetTable;
    Vector patchAddressVector;
    Vector patchLabelVector;
    Vector patchTypeVector;
    int current_addr = 0;
    int max_addr = 0;
    String sourcefilename = null;
    public static final int T_UNDEFINED = -2;
    public static final int T_UNKNOWN = 1;
    public static final int T_OPCODE = 2;
    public static final int T_ORG = 3;
    public static final int T_EQU = 4;
    public static final int T_LABEL = 5;
    public static final int T_SHORTHAND = 6;
    public static final int T_DATA = 7;
    public static final int T_INCLUDE = 11;
    public static final int T_LIST = 12;
    public static final String T_ADDRESS_8 = "AAAA AAAA";
    public static final String T_ADDRESS_12 = "AAAA AAAA AAAA";

    public MCS4Assembler() {
        this.createSymbolTable();
        this.createMetaSymbols();
        this.createMCS4OpcodeSymbols();
        this.createMCS4RegisterNameSymbols();
        this.createMCS4InstructionMemory();
    }

    public int getMemorySize() {
        return 1024;
    }

    public int getNOP() {
        return 0;
    }

    public void createMCS4InstructionMemory() {
        int n_words = this.getMemorySize();
        int nop = this.getNOP();
        this.instructionMemory = new int[n_words];
        int i = 0;
        while (i < n_words) {
            this.instructionMemory[i] = nop;
            ++i;
        }
    }

    public void createSymbolTable() {
        this.symbolTable = new Hashtable();
        this.symbolTypeTable = new Hashtable();
        this.opcodeArgsTable = new Hashtable();
    }

    public void createMetaSymbols() {
        try {
            this.addSymbol2("include", "include", 11);
            this.addSymbol2("list", "list", 12);
            this.addSymbol2("org", "org", 3);
            this.addSymbol2("equ", "equ", 4);
            this.addSymbol("=", "assign", 4);
            this.addSymbol2("data", "data", 7);
        }
        catch (Exception e) {
            MCS4Assembler.msg("" + e);
        }
    }

    public void createMCS4OpcodeSymbols() {
        try {
            this.addOpcodeSymbol("nop", "0x00", 1, 0);
            this.addOpcodeSymbol("jcn", "0x10", 2, 0);
            this.addOpcodeSymbol("fim", "0x20", 2, 0);
            this.addOpcodeSymbol("src", "0x21", 1, 0);
            this.addOpcodeSymbol("fin", "0x30", 1, 0);
            this.addOpcodeSymbol("jin", "0x31", 1, 0);
            this.addOpcodeSymbol("jun", "0x40", 2, 0);
            this.addOpcodeSymbol("jms", "0x50", 2, 0);
            this.addOpcodeSymbol("inc", "0x60", 1, 0);
            this.addOpcodeSymbol("isz", "0x70", 2, 0);
            this.addOpcodeSymbol("add", "0x80", 1, 0);
            this.addOpcodeSymbol("sub", "0x90", 1, 0);
            this.addOpcodeSymbol("ld", "0xa0", 1, 0);
            this.addOpcodeSymbol("xch", "0xb0", 1, 0);
            this.addOpcodeSymbol("bbl", "0xc0", 1, 0);
            this.addOpcodeSymbol("ldm", "0xd0", 1, 0);
            this.addOpcodeSymbol("wrm", "0xE0", 1, 0);
            this.addOpcodeSymbol("wmp", "0xE1", 1, 0);
            this.addOpcodeSymbol("wrr", "0xE2", 1, 0);
            this.addOpcodeSymbol("wpm", "0xE3", 1, 0);
            this.addOpcodeSymbol("wr0", "0xE4", 1, 0);
            this.addOpcodeSymbol("wr1", "0xE5", 1, 0);
            this.addOpcodeSymbol("wr2", "0xE6", 1, 0);
            this.addOpcodeSymbol("wr3", "0xE7", 1, 0);
            this.addOpcodeSymbol("sbm", "0xE8", 1, 0);
            this.addOpcodeSymbol("rdm", "0xE9", 1, 0);
            this.addOpcodeSymbol("rdr", "0xEA", 1, 0);
            this.addOpcodeSymbol("adm", "0xEB", 1, 0);
            this.addOpcodeSymbol("rd0", "0xEC", 1, 0);
            this.addOpcodeSymbol("rd1", "0xED", 1, 0);
            this.addOpcodeSymbol("rd2", "0xEE", 1, 0);
            this.addOpcodeSymbol("rd3", "0xEF", 1, 0);
            this.addOpcodeSymbol("clb", "0xF0", 1, 0);
            this.addOpcodeSymbol("clc", "0xF1", 1, 0);
            this.addOpcodeSymbol("iac", "0xF2", 1, 0);
            this.addOpcodeSymbol("cmc", "0xF3", 1, 0);
            this.addOpcodeSymbol("cma", "0xF4", 1, 0);
            this.addOpcodeSymbol("ral", "0xF5", 1, 0);
            this.addOpcodeSymbol("rar", "0xF6", 1, 0);
            this.addOpcodeSymbol("tcc", "0xF7", 1, 0);
            this.addOpcodeSymbol("dac", "0xF8", 1, 0);
            this.addOpcodeSymbol("tcs", "0xF9", 1, 0);
            this.addOpcodeSymbol("stc", "0xFA", 1, 0);
            this.addOpcodeSymbol("daa", "0xFB", 1, 0);
            this.addOpcodeSymbol("kbp", "0xFC", 1, 0);
            this.addOpcodeSymbol("dcl", "0xFD", 1, 0);
        }
        catch (Exception e) {
            MCS4Assembler.msg("" + e);
        }
    }

    public void createMCS4RegisterNameSymbols() {
        try {
            this.addSymbol2("r0r1", "0x00", 6);
            this.addSymbol2("r2r3", "0x01", 6);
            this.addSymbol2("r4r5", "0x02", 6);
            this.addSymbol2("r6r7", "0x03", 6);
            this.addSymbol2("r8r9", "0x04", 6);
            this.addSymbol2("rArB", "0x05", 6);
            this.addSymbol2("rCrD", "0x06", 6);
            this.addSymbol2("rErF", "0x07", 6);
            this.addSymbol2("r10r11", "0x05", 6);
            this.addSymbol2("r12r13", "0x06", 6);
            this.addSymbol2("r14r15", "0x07", 6);
            this.addSymbol("R0", "0", 6);
            this.addSymbol("R1", "1", 6);
            this.addSymbol("R2", "2", 6);
            this.addSymbol("R3", "3", 6);
            this.addSymbol("R4", "4", 6);
            this.addSymbol("R5", "5", 6);
            this.addSymbol("R6", "6", 6);
            this.addSymbol("R7", "7", 6);
            this.addSymbol("R8", "8", 6);
            this.addSymbol("R9", "9", 6);
            this.addSymbol("RA", "10", 6);
            this.addSymbol("RB", "11", 6);
            this.addSymbol("RC", "12", 6);
            this.addSymbol("RD", "13", 6);
            this.addSymbol("RE", "14", 6);
            this.addSymbol("RF", "15", 6);
            this.addSymbol("R10", "10", 6);
            this.addSymbol("R11", "11", 6);
            this.addSymbol("R12", "12", 6);
            this.addSymbol("R13", "13", 6);
            this.addSymbol("R14", "14", 6);
            this.addSymbol("R15", "15", 6);
            this.addSymbol("NT", "1", 6);
            this.addSymbol("C", "2", 6);
            this.addSymbol("Z", "4", 6);
            this.addSymbol("T", "9", 6);
            this.addSymbol("NC", "10", 6);
            this.addSymbol("NZ", "12", 6);
            int i = 0;
            while (i <= 47) {
                this.addSymbol("reg_" + HexFormat.getHexString(i, 2), "" + i, 6);
                ++i;
            }
        }
        catch (Exception e) {
            MCS4Assembler.msg("" + e);
        }
    }

    public void addSymbol(String key, Object value, int type) throws Exception {
        if (key == null) {
            throw new Exception("Trying to define a null symbol with value " + value);
        }
        if (value == null) {
            throw new Exception("Null value for symbol " + key);
        }
        if (this.symbolTable.containsKey(key)) {
            throw new Exception("Second definition for symbol " + key);
        }
        this.symbolTable.put(key, value);
        this.symbolTypeTable.put(key, new Integer(type));
    }

    public void addSymbol2(String key, Object value, int type) throws Exception {
        this.addSymbol(key, value, type);
        this.addSymbol(key.toUpperCase(), value, type);
    }

    public void addOpcodeSymbol(String key, String value, int n_bytes, int n_args) throws Exception {
        Integer iv = new Integer(this.parseNumber(value));
        this.addSymbol(key, iv, 2);
        this.addSymbol(key.toUpperCase(), iv, 2);
        this.opcodeArgsTable.put(key, new Integer(n_args));
        this.opcodeArgsTable.put(key.toUpperCase(), new Integer(n_args));
    }

    public int getSymbolType(String key) {
        if (this.symbolTypeTable.containsKey(key)) {
            return (Integer)this.symbolTypeTable.get(key);
        }
        return -2;
    }

    public boolean isOpcodeSymbol(String key) {
        return this.getSymbolType(key) == 2;
    }

    public boolean isEquSymbol(String key) {
        return this.getSymbolType(key) == 4;
    }

    public boolean isSymbol(String key) {
        return this.symbolTable.containsKey(key);
    }

    public String getSymbol(String key) {
        return (String)this.symbolTable.get(key);
    }

    public String printSymbolType(String key) {
        int type = this.getSymbolType(key);
        switch (type) {
            case -2: {
                return "T_UNDEFINED";
            }
            case 1: {
                return "T_UNKNOWN  ";
            }
            case 2: {
                return "T_OPCODE   ";
            }
            case 3: {
                return "T_ORG      ";
            }
            case 4: {
                return "T_EQU      ";
            }
            case 5: {
                return "T_LABEL    ";
            }
            case 6: {
                return "T_SHORTHAND";
            }
            case 11: {
                return "T_INCLUDE  ";
            }
            case 12: {
                return "T_LIST     ";
            }
        }
        return "T_UNDEFINED";
    }

    public void dumpSymbolTable(PrintStream ps) {
        ps.println("Symbol table dump: ");
        Enumeration e = this.symbolTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ps.println(key + " " + this.symbolTable.get(key) + " " + this.printSymbolType(key));
        }
    }

    public void defineLabel(String label, int address) throws Exception {
        if (this.symbolTable.get(label) != null) {
            if (this.getSymbolType(label) != 5) {
                throw new Exception("Illegal redefinition as a label: " + label);
            }
            if (this.getLabelAddress(label) >= 0) {
                throw new Exception("Redefining label address from " + this.getLabelAddress(label) + " to " + address);
            }
        }
        this.symbolTable.put(label, new Integer(address));
        this.symbolTypeTable.put(label, new Integer(5));
    }

    public int getLabelAddress(String label) throws Exception {
        if (this.getSymbolType(label) != 5) {
            throw new Exception("Not a label: " + label);
        }
        return (Integer)this.symbolTable.get(label);
    }

    public void parse(BufferedReader reader) {
        this.tokenize(reader);
        this.codegen();
        this.patchLabels();
    }

    public void writeRom(PrintWriter writer) throws Exception {
        MCS4Assembler.msg("# ROM data for i4004 at " + new Date());
        int last_addr = 0;
        int NOP2 = this.getNOP();
        int i = 0;
        while (i < this.instructionMemory.length) {
            if (this.instructionMemory[i] != NOP2) {
                last_addr = i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 <= last_addr) {
            int addr = i2;
            int data = this.instructionMemory[i2];
            writer.println(HexFormat.getHexString(addr, 4) + ": " + HexFormat.getHexString(data, 2));
            ++i2;
        }
        this.writeRawLabels(writer);
        writer.flush();
        writer.close();
    }

    public void writeHex(PrintWriter writer) throws Exception {
        MCS4Assembler.msg("# HEX data for i4004 at " + new Date());
        int last_addr = 0;
        int NOP2 = this.getNOP();
        int i = 0;
        while (i < this.instructionMemory.length) {
            if (this.instructionMemory[i] != NOP2) {
                last_addr = i;
            }
            ++i;
        }
        long[] hexMemory = new long[last_addr + 1];
        int i2 = 0;
        while (i2 <= last_addr) {
            hexMemory[i2] = this.instructionMemory[i2];
            ++i2;
        }
        try {
            new IntelHexFile().writeHexFile16Bit(writer, hexMemory);
        }
        catch (Exception e) {
            MCS4Assembler.msg("-E- Internal error while writing HEX file: " + e);
            e.printStackTrace();
        }
    }

    public void writeLabels(PrintWriter writer) throws Exception {
        MCS4Assembler.msg("# LBL data for i4004 at " + new Date());
        this.writeRawLabels(writer);
        writer.flush();
        writer.close();
    }

    public void writeRawLabels(PrintWriter writer) throws Exception {
        Hashtable<String, String> atable = new Hashtable<String, String>();
        Enumeration e = this.symbolTable.keys();
        while (e.hasMoreElements()) {
            String label = (String)e.nextElement();
            if (this.getSymbolType(label) != 5) continue;
            String addr = HexFormat.getHexString(this.getLabelAddress(label), 4);
            atable.put(addr, label);
        }
        int n_keys = atable.size();
        String[] keys = new String[n_keys];
        int j = 0;
        Enumeration e2 = atable.keys();
        while (e2.hasMoreElements()) {
            keys[j] = (String)e2.nextElement();
            ++j;
        }
        ShellSort.shellSort(keys);
        j = 0;
        while (j < keys.length) {
            String label = (String)atable.get(keys[j]);
            if (this.getSymbolType(label) == 5) {
                writer.println("#label " + HexFormat.getHexString(this.getLabelAddress(label), 4) + " " + label);
            }
            ++j;
        }
    }

    public void writeSymbolTable(PrintWriter writer) throws Exception {
        int n_keys = this.symbolTable.size();
        String[] keys = new String[n_keys];
        int j = 0;
        Enumeration e = this.symbolTable.keys();
        while (e.hasMoreElements()) {
            keys[j] = (String)e.nextElement();
            ++j;
        }
        ShellSort.shellSort(keys);
        int i = 0;
        while (i < n_keys) {
            String key = keys[i];
            writer.println(this.flushLeft(key, 40) + " " + this.flushLeft(this.symbolTable.get(key), 20) + " " + this.printSymbolType(key));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public String flushLeft(Object o, int fieldsize) {
        String s = null;
        s = o instanceof String ? (String)o : o.toString();
        if (s.length() >= fieldsize) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        while (sb.length() < fieldsize) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void patchLabels() {
        if (this.debug) {
            MCS4Assembler.msg("-#- patchLabels...");
        }
        int n_patches = this.patchAddressVector.size();
        int i = 0;
        while (i < n_patches) {
            block7: {
                int addr = (Integer)this.patchAddressVector.elementAt(i);
                String label = (String)this.patchLabelVector.elementAt(i);
                String type = (String)this.patchTypeVector.elementAt(i);
                try {
                    Object tmp;
                    if (this.debug) {
                        MCS4Assembler.msg("-I- patching at " + addr + " with " + label);
                    }
                    String s_offset = null;
                    s_offset = this.isSymbol(label) ? ((tmp = this.symbolTable.get(label)) instanceof String ? (String)tmp : (tmp instanceof Integer ? "" + (Integer)tmp : tmp.toString())) : label;
                    int i_offset = this.parseNumber(s_offset) & 0x3FF;
                    if (type.equals(T_ADDRESS_8)) {
                        this.instructionMemory[addr + 1] = i_offset & 0xFF;
                        break block7;
                    }
                    if (type.equals(T_ADDRESS_12)) {
                        int n = addr;
                        this.instructionMemory[n] = this.instructionMemory[n] + ((i_offset & 0xF00) >>> 8);
                        this.instructionMemory[addr + 1] = i_offset & 0xFF;
                        break block7;
                    }
                    throw new RuntimeException("-E- Unknown patch type: " + type);
                }
                catch (Exception e) {
                    System.err.println("-E- internal: " + addr + " " + label + " " + type);
                }
            }
            ++i;
        }
    }

    public void codegen() {
        this.labelTargetTable = new Hashtable();
        this.patchAddressVector = new Vector();
        this.patchLabelVector = new Vector();
        this.patchTypeVector = new Vector();
        this.current_addr = 0;
        Enumeration E = this.rawTokens.elements();
        while (E.hasMoreElements()) {
            String[] tokens = (String[])E.nextElement();
            try {
                if (tokens.length < 1) continue;
                if (tokens.length == 1) {
                    if (this.isOpcodeSymbol(tokens[0])) {
                        this.handleOpcode(tokens);
                        continue;
                    }
                    this.addStandaloneLabel(tokens);
                    continue;
                }
                if (this.isOpcodeSymbol(tokens[0])) {
                    this.handleOpcode(tokens);
                    continue;
                }
                if (this.isOpcodeSymbol(tokens[1])) {
                    this.handleLabelAndOpcode(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 3) {
                    this.handleOrgExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 7) {
                    this.handleDataExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 12) {
                    this.handleListExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[0]) == 11) {
                    this.handleIncludeExpression(tokens);
                    continue;
                }
                if (this.getSymbolType(tokens[1]) == 4) {
                    this.handleEquExpression(tokens);
                    continue;
                }
                MCS4Assembler.msg("-W- don't know how to handle: ");
                this.printLineTokens(tokens);
            }
            catch (Exception e) {
                MCS4Assembler.msg("-E- codegen: " + e);
                this.printLineTokens(tokens);
                e.printStackTrace();
            }
        }
    }

    public void addStandaloneLabel(String[] tokens) throws Exception {
        String label;
        if (this.debug) {
            MCS4Assembler.msg("-I- addStandaloneLabel '" + tokens[0] + "' at " + HexFormat.getHexString(this.current_addr, 4));
        }
        if ((label = tokens[0]).endsWith(":")) {
            label = label.substring(0, label.length() - 1);
        }
        this.defineLabel(label, this.current_addr);
    }

    public int getRRR(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getRRRR(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getCCCC(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getA12(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getAAAA(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getDDDD(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public int getD4(String token) {
        String resolved = this.isSymbol(token) ? this.getSymbol(token) : token;
        return this.parseNumber(resolved);
    }

    public void handleDataExpression(String[] tokens) throws Exception {
        if (this.debug) {
            MCS4Assembler.msg("handleData, addr= " + this.current_addr + " " + tokens[0]);
        }
        this.instructionMemory[this.current_addr] = this.getDDDD(tokens[1]);
        ++this.current_addr;
    }

    public void handleOpcode(String[] tokens) throws Exception {
        if (this.debug) {
            MCS4Assembler.msg("handleOpcode, addr= " + this.current_addr + " " + tokens[0]);
        }
        String s_opcode = tokens[0];
        int opcode = (Integer)this.symbolTable.get(s_opcode);
        int rrr = 0;
        int rrrr = 0;
        int dddd = 0;
        if (opcode == 0) {
            this.instructionMemory[this.current_addr] = opcode;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 16) {
            int cccc = this.getCCCC(tokens[1]);
            this.patchAddressVector.addElement(new Integer(this.current_addr));
            this.patchLabelVector.addElement(tokens[2]);
            this.patchTypeVector.addElement(T_ADDRESS_8);
            this.instructionMemory[this.current_addr] = opcode | cccc;
            this.instructionMemory[this.current_addr + 1] = 0;
            this.current_addr += 2;
            this.max_addr += 2;
        } else if (opcode == 32) {
            rrr = this.getRRR(tokens[1]);
            dddd = this.getDDDD(tokens[2]);
            this.instructionMemory[this.current_addr] = opcode | rrr << 1;
            this.instructionMemory[this.current_addr + 1] = dddd;
            this.current_addr += 2;
            this.max_addr += 2;
        } else if (opcode == 33) {
            rrr = this.getRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrr << 1 | 1;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 48) {
            rrr = this.getRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrr << 1;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 49) {
            rrr = this.getRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrr << 1 | 1;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 64) {
            this.patchAddressVector.addElement(new Integer(this.current_addr));
            this.patchLabelVector.addElement(tokens[1]);
            this.patchTypeVector.addElement(T_ADDRESS_12);
            this.instructionMemory[this.current_addr] = opcode;
            this.instructionMemory[this.current_addr + 1] = 0;
            this.current_addr += 2;
            this.max_addr += 2;
        } else if (opcode == 80) {
            this.patchAddressVector.addElement(new Integer(this.current_addr));
            this.patchLabelVector.addElement(tokens[1]);
            this.patchTypeVector.addElement(T_ADDRESS_12);
            this.instructionMemory[this.current_addr] = opcode;
            this.instructionMemory[this.current_addr + 1] = 0;
            this.current_addr += 2;
            this.max_addr += 2;
        } else if (opcode == 96) {
            rrrr = this.getRRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 112) {
            rrrr = this.getRRRR(tokens[1]);
            this.patchAddressVector.addElement(new Integer(this.current_addr));
            this.patchLabelVector.addElement(tokens[1]);
            this.patchTypeVector.addElement(T_ADDRESS_12);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            this.instructionMemory[this.current_addr + 1] = 0;
            this.current_addr += 2;
            this.max_addr += 2;
        } else if (opcode == 128) {
            rrrr = this.getRRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 144) {
            rrrr = this.getRRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 160) {
            rrrr = this.getRRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 176) {
            rrrr = this.getRRRR(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | rrrr;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 192) {
            dddd = this.getDDDD(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | dddd;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode == 208) {
            dddd = this.getDDDD(tokens[1]);
            this.instructionMemory[this.current_addr] = opcode | dddd;
            ++this.current_addr;
            ++this.max_addr;
        } else if (opcode >= 224) {
            this.instructionMemory[this.current_addr] = opcode;
            ++this.current_addr;
            ++this.max_addr;
        }
    }

    public void handleLabelAndOpcode(String[] tokens) throws Exception {
        if (this.debug) {
            MCS4Assembler.msg("-I- handleLabelAndOpcode...");
            this.printLineTokens(tokens);
        }
        this.defineLabel(tokens[0], this.current_addr);
        String[] shiftedTokens = new String[tokens.length - 1];
        int i = 0;
        while (i < shiftedTokens.length) {
            shiftedTokens[i] = tokens[i + 1];
            ++i;
        }
        this.handleOpcode(shiftedTokens);
    }

    public void handleListExpression(String[] tokens) throws Exception {
        MCS4Assembler.msg("-W- Ignoring 'list' directive: ");
    }

    public void handleIncludeExpression(String[] tokens) throws Exception {
        if (tokens[1].indexOf("p16c84.inc") <= 0) {
            MCS4Assembler.msg("-E- #include <file> not supported for: " + tokens[1]);
            throw new Exception("Cannot include file " + tokens[1]);
        }
        MCS4Assembler.msg("-W- Cannot include 'p16c84.inc', but PIC16C84 constants are predefined!");
    }

    public void handleOrgExpression(String[] tokens) throws Exception {
        if (this.debug) {
            MCS4Assembler.msg("-W- handleOrgExpression not fully supported!");
            this.printLineTokens(tokens);
        }
        int addr = -1;
        addr = this.isSymbol(tokens[1]) ? this.parseNumber(this.getSymbol(tokens[1])) : this.parseNumber(tokens[1]);
        this.current_addr = addr;
        if (this.instructionMemory[addr] != this.getNOP()) {
            MCS4Assembler.msg("-W- ORG directive overwrites memory at " + HexFormat.getHexString(addr, 4));
        }
    }

    public void handleEquExpression(String[] tokens) throws Exception {
        if (this.debug) {
            MCS4Assembler.msg("-W- handleEquExpression not fully supported!");
            this.printLineTokens(tokens);
        }
        if (this.isSymbol(tokens[2])) {
            this.addSymbol(tokens[0], this.getSymbol(tokens[2]), 1);
        } else {
            this.addSymbol(tokens[0], tokens[2], 1);
        }
    }

    public void tokenize(BufferedReader reader) {
        Vector<String[]> allTokens = new Vector<String[]>();
        String line = null;
        String[] tokens = null;
        try {
            while ((line = reader.readLine()) != null) {
                tokens = this.tokenizeLine(line = this.stripComments(line));
                if (tokens.length < 1) continue;
                allTokens.addElement(tokens);
            }
        }
        catch (Exception e) {
            MCS4Assembler.msg("-E- internal error: " + e);
        }
        this.rawTokens = allTokens;
    }

    public void dumpRawTokens(Vector rawTokens) {
        Enumeration e = rawTokens.elements();
        while (e.hasMoreElements()) {
            String[] lineTokens = (String[])e.nextElement();
            this.printLineTokens(lineTokens);
        }
    }

    public String[] tokenizeLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t;,");
        int n_tokens = tokenizer.countTokens();
        String[] tokens = new String[n_tokens];
        int i = 0;
        while (i < n_tokens) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    public void printLineTokens(String[] tokens) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            sb.append(tokens[i] + " ");
            ++i;
        }
        MCS4Assembler.msg(sb.toString());
    }

    public String stripComments(String line) {
        int firstSemicolon = line.indexOf(59);
        if (firstSemicolon >= 0) {
            line = line.substring(0, firstSemicolon).trim();
        }
        return line;
    }

    public int parseNumber(String s) {
        String t = s.trim().toLowerCase();
        if (t.startsWith("0b")) {
            return Integer.parseInt(t.substring(2), 2);
        }
        if (t.startsWith("0d")) {
            return Integer.parseInt(t.substring(2), 10);
        }
        if (t.startsWith("0x")) {
            return Integer.parseInt(t.substring(2), 16);
        }
        if (t.startsWith("b'")) {
            return Integer.parseInt(t.substring(2, t.length() - 1), 2);
        }
        if (t.startsWith("d'")) {
            return Integer.parseInt(t.substring(2, t.length() - 1), 10);
        }
        if (t.startsWith("x'")) {
            return Integer.parseInt(t.substring(2, t.length() - 1), 16);
        }
        if (t.startsWith("h'")) {
            return Integer.parseInt(t.substring(2, t.length() - 1), 16);
        }
        if (t.startsWith("'")) {
            return s.trim().charAt(1);
        }
        if (t.startsWith(".")) {
            return Integer.parseInt(t.substring(1));
        }
        if (t.endsWith("h")) {
            return Integer.parseInt(t.substring(0, t.length() - 1), 16);
        }
        if (t.endsWith("b")) {
            return Integer.parseInt(t.substring(0, t.length() - 1), 2);
        }
        return Integer.parseInt(t);
    }

    public void setOptions(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-debug")) {
                this.debug = true;
            }
            ++i;
        }
    }

    public void setFilename(String sourcefilename) {
        this.sourcefilename = sourcefilename;
    }

    public String getFilename() {
        return this.sourcefilename;
    }

    public void getReader() {
    }

    public PrintWriter getPrintWriter(String suffix) throws Exception {
        String fname = null;
        String asm_name = this.getFilename();
        fname = asm_name.endsWith(".asm") ? asm_name.substring(0, asm_name.length() - 4) + suffix : this.getFilename() + suffix;
        return new PrintWriter(new FileWriter(fname));
    }

    public void usage() {
        MCS4Assembler.msg("Usage:  <java> hades.models.pic.MCS4Assembler <filename.asm> [options]\nwhere <java> specifies the JVM and CLASSPATH to use, and \noptions include:\n-symbols    write <filename.sym> symbol table\n-rom        write <filename.rom> rom data instead of .HEX data\n-debug      enable verbose output\n \nExample: <java> hades.models.pic.MCS4Assembler yourpath/yourfile.asm\nwhich creates yourpath/yourfile.hex\n");
        System.exit(1);
    }

    public void copyright() {
        MCS4Assembler.msg("Hades Assembler for the Intel MCS4 (i4004) system\n(C) 2003 FNH, University of Hamburg, Informatik\n ");
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] argv) {
        block9: {
            MCS4Assembler asm = new MCS4Assembler();
            asm.copyright();
            if (argv.length < 1) {
                asm.usage();
            }
            asm.setFilename(argv[0]);
            asm.setOptions(argv);
            BufferedReader reader = null;
            asm.parse(new BufferedReader(new FileReader(argv[0])));
            asm.writeRom(asm.getPrintWriter(".rom"));
            asm.writeHex(asm.getPrintWriter(".hex"));
            asm.writeLabels(asm.getPrintWriter(".lbl"));
            asm.writeSymbolTable(asm.getPrintWriter(".sym"));
            Object var5_3 = null;
            try {
                reader.close();
            }
            catch (Exception ee) {}
            break block9;
            {
                catch (Exception e) {
                    System.out.println("-E- got an exception: " + e);
                    e.printStackTrace();
                    asm.usage();
                    Object var5_4 = null;
                    try {
                        reader.close();
                    }
                    catch (Exception ee) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    reader.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

