/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.mcs4.Instruction;
import java.util.HashMap;

class InstructionSet {
    private static InstructionSet instructions = null;
    private HashMap instructionSet = new HashMap();
    public static final Instruction NOP = new Instruction(new Integer(0), new Integer(0), "NOP");
    public static final Instruction JCN = new Instruction(new Integer(1), "JCN", true, 5);
    public static final Instruction FIM = new Instruction(new Integer(2), "FIM", true, 7);
    public static final Instruction SRC = new Instruction(new Integer(2), "SRC", 2);
    public static final Instruction FIN = new Instruction(new Integer(3), "FIN", true, 2);
    public static final Instruction JIN = new Instruction(new Integer(3), "JIN", 2);
    public static final Instruction JUN = new Instruction(new Integer(4), "JUN", true, 4);
    public static final Instruction JMS = new Instruction(new Integer(5), "JMS", true, 4);
    public static final Instruction INC = new Instruction(new Integer(6), "INC", 1);
    public static final Instruction ISZ = new Instruction(new Integer(7), "ISZ", true, 6);
    public static final Instruction ADD = new Instruction(new Integer(8), "ADD", 1);
    public static final Instruction SUB = new Instruction(new Integer(9), "SUB", 1);
    public static final Instruction LD = new Instruction(new Integer(10), "LD", 1);
    public static final Instruction XCH = new Instruction(new Integer(11), "XCH", 1);
    public static final Instruction BBL = new Instruction(new Integer(12), "BBL", 3);
    public static final Instruction LDM = new Instruction(new Integer(13), "LDM", 3);
    public static final Instruction WRM = new Instruction(new Integer(14), new Integer(0), "WRM");
    public static final Instruction WMP = new Instruction(new Integer(14), new Integer(1), "WMP");
    public static final Instruction WRR = new Instruction(new Integer(14), new Integer(2), "WRR");
    public static final Instruction WPM = new Instruction(new Integer(14), new Integer(3), "WPM");
    public static final Instruction WR0 = new Instruction(new Integer(14), new Integer(4), "WR0");
    public static final Instruction WR1 = new Instruction(new Integer(14), new Integer(5), "WR1");
    public static final Instruction WR2 = new Instruction(new Integer(14), new Integer(6), "WR2");
    public static final Instruction WR3 = new Instruction(new Integer(14), new Integer(7), "WR3");
    public static final Instruction SBM = new Instruction(new Integer(14), new Integer(8), "SBM");
    public static final Instruction RDM = new Instruction(new Integer(14), new Integer(9), "RDM");
    public static final Instruction RDR = new Instruction(new Integer(14), new Integer(10), "RDR");
    public static final Instruction ADM = new Instruction(new Integer(14), new Integer(11), "ADM");
    public static final Instruction RD0 = new Instruction(new Integer(14), new Integer(12), "RD0");
    public static final Instruction RD1 = new Instruction(new Integer(14), new Integer(13), "RD1");
    public static final Instruction RD2 = new Instruction(new Integer(14), new Integer(14), "RD2");
    public static final Instruction RD3 = new Instruction(new Integer(14), new Integer(15), "RD3");
    public static final Instruction CLB = new Instruction(new Integer(15), new Integer(0), "CLB");
    public static final Instruction CLC = new Instruction(new Integer(15), new Integer(1), "CLC");
    public static final Instruction IAC = new Instruction(new Integer(15), new Integer(2), "IAC");
    public static final Instruction CMC = new Instruction(new Integer(15), new Integer(3), "CMC");
    public static final Instruction CMA = new Instruction(new Integer(15), new Integer(4), "CMA");
    public static final Instruction RAL = new Instruction(new Integer(15), new Integer(5), "RAL");
    public static final Instruction RAR = new Instruction(new Integer(15), new Integer(6), "RAR");
    public static final Instruction TCC = new Instruction(new Integer(15), new Integer(7), "TCC");
    public static final Instruction DAC = new Instruction(new Integer(15), new Integer(8), "DAC");
    public static final Instruction TCS = new Instruction(new Integer(15), new Integer(9), "TCS");
    public static final Instruction STC = new Instruction(new Integer(15), new Integer(10), "STC");
    public static final Instruction DAA = new Instruction(new Integer(15), new Integer(11), "DAA");
    public static final Instruction KBP = new Instruction(new Integer(15), new Integer(12), "KBP");
    public static final Instruction DCL = new Instruction(new Integer(15), new Integer(13), "DCL");

    private InstructionSet() {
        this.add(NOP);
        this.add(JCN);
        this.add(FIM, new Integer(0));
        this.add(SRC, new Integer(1));
        this.add(FIN, new Integer(0));
        this.add(JIN, new Integer(1));
        this.add(JUN);
        this.add(JMS);
        this.add(INC);
        this.add(ISZ);
        this.add(ADD);
        this.add(SUB);
        this.add(LD);
        this.add(XCH);
        this.add(BBL);
        this.add(LDM);
        this.add(WRM);
        this.add(WMP);
        this.add(WRR);
        this.add(WPM);
        this.add(WR0);
        this.add(WR1);
        this.add(WR2);
        this.add(WR3);
        this.add(SBM);
        this.add(RDM);
        this.add(RDR);
        this.add(ADM);
        this.add(RD0);
        this.add(RD1);
        this.add(RD2);
        this.add(RD3);
        this.add(CLB);
        this.add(CLC);
        this.add(IAC);
        this.add(CMC);
        this.add(CMA);
        this.add(RAL);
        this.add(RAR);
        this.add(TCC);
        this.add(DAC);
        this.add(TCS);
        this.add(STC);
        this.add(DAA);
        this.add(KBP);
        this.add(DCL);
    }

    private void add(Instruction instruction) {
        this.add(instruction, instruction.getOPR(), instruction.getOPA());
    }

    private void add(Instruction instruction, Integer opaDiff) {
        int i = 0;
        while (i < 8) {
            Integer opaCode = new Integer((i << 1) + opaDiff);
            this.add(instruction, instruction.getOPR(), opaCode);
            ++i;
        }
    }

    private void add(Instruction instruction, Integer oprCode, Integer opaCode) {
        int keyValue = oprCode << 4;
        if (opaCode != null) {
            keyValue += opaCode.intValue();
        }
        this.instructionSet.put(new Integer(keyValue), instruction);
    }

    Instruction findInstruction(Integer oprCode, Integer opaCode) {
        int keyValue = oprCode << 4;
        Integer key = new Integer(keyValue += opaCode.intValue());
        if (this.instructionSet.containsKey(key)) {
            return (Instruction)this.instructionSet.get(key);
        }
        key = new Integer(keyValue &= 0xF0);
        if (this.instructionSet.containsKey(key)) {
            return (Instruction)this.instructionSet.get(key);
        }
        return NOP;
    }

    Instruction getMemoryInstruction(Integer opaCode) {
        return this.findInstruction(WRM.getOPR(), opaCode);
    }

    boolean isMemoryInstruction(Integer oprCode) {
        return WRM.getOPR().equals(oprCode);
    }

    static InstructionSet getInstance() {
        if (instructions == null) {
            instructions = new InstructionSet();
        }
        return instructions;
    }
}

