/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcs4.AddressStack;
import hades.models.mcs4.AluRegion;
import hades.models.mcs4.Instruction;
import hades.models.mcs4.InstructionSet;
import hades.models.mcs4.InternalState;
import hades.models.mcs4.ScratchPad;
import hades.models.mcs4.i4004EditorFrame;
import hades.models.mcs4.i4004InternalReg;

class ExecutionUnit {
    private i4004InternalReg oprRegister = new i4004InternalReg("OPR Register", 4);
    private i4004InternalReg opaRegister = new i4004InternalReg("OPA Register", 4);
    private i4004InternalReg commandLine = new i4004InternalReg("Command Line", 4);
    private i4004InternalReg data = new i4004InternalReg("Internal Databus", 4, true);
    private AddressStack addressStack = new AddressStack();
    private ScratchPad registers = new ScratchPad();
    private AluRegion arith = new AluRegion();
    private InternalState cycleClock = InternalState.X3;
    private Instruction instruction = InstructionSet.NOP;
    private InstructionSet instructionSet = InstructionSet.getInstance();
    private boolean hasOutputData;
    private boolean needsInputData;
    private boolean needs2word = false;
    private boolean notifyMemory = false;
    private int cycle2word = 1;
    private int resetCounter = 0;
    private StdLogicVector temp = new StdLogicVector(4, 0L);
    private StdLogicVector conditionMask = new StdLogicVector(4, 0L);
    private StdLogic1164 test = new StdLogic1164();
    private i4004EditorFrame frame;

    ExecutionUnit() {
    }

    void elaborate() {
        this.hasOutputData = false;
        this.needsInputData = false;
        this.needs2word = false;
        this.cycle2word = 1;
        this.oprRegister.setValue(0L);
        this.opaRegister.setValue(0L);
        this.commandLine.setValue(1L);
        this.conditionMask.setValue(0L);
        this.instruction = InstructionSet.NOP;
        this.addressStack.elaborate();
        this.registers.elaborate();
        this.arith.elaborate();
        this.test.setIntValue(3);
        this.resetCounter = 0;
        if (this.frame != null && this.frame.isShowing()) {
            this.frame.instructionChanged(this.instruction);
        }
    }

    private void setOPR(long oprData) {
        this.oprRegister.setValue(oprData);
    }

    private void setOPA(long opaData) {
        this.opaRegister.setValue(opaData);
    }

    private void setCommandLine(long clData) {
        this.commandLine.setValue(clData);
    }

    void setTest(int value) {
        this.test.setIntValue(value);
    }

    boolean isTestSet() {
        return this.test.intValue() == 2;
    }

    void reset(boolean reset) {
        if (!reset) {
            this.resetCounter = 0;
        } else if (this.resetCounter < 8) {
            ++this.resetCounter;
        }
    }

    boolean isReset() {
        return this.resetCounter != 0;
    }

    void setData(StdLogicVector data) {
        this.data.setValue(data.getValue());
        if (this.cycleClock == InternalState.M1) {
            if ((this.instruction == InstructionSet.FIM || this.instruction == InstructionSet.FIN) && this.cycle2word == 2) {
                this.temp.setValue(this.opaRegister.getValue());
                int register = (int)this.temp.subset(3, 1).getValue() * 2 + 1;
                this.registers.setRegister(data.getValue(), register);
            } else {
                this.setOPR(data.getValue());
            }
        } else if (this.cycleClock == InternalState.M2) {
            if ((this.instruction == InstructionSet.FIM || this.instruction == InstructionSet.FIN) && this.cycle2word == 2) {
                this.temp.setValue(this.opaRegister.getValue());
                int register = (int)this.temp.subset(3, 1).getValue() * 2;
                this.registers.setRegister(data.getValue(), register);
            } else {
                this.setOPA(data.getValue());
            }
        } else if (this.cycleClock == InternalState.X2) {
            if (this.instruction == InstructionSet.RDM || this.instruction == InstructionSet.RDR || this.instruction == InstructionSet.RD0 || this.instruction == InstructionSet.RD1 || this.instruction == InstructionSet.RD2 || this.instruction == InstructionSet.RD3) {
                this.arith.setAccu(data.getValue());
            } else if (this.instruction == InstructionSet.SBM || this.instruction == InstructionSet.ADM) {
                this.arith.setTempReg(data.getValue());
                if (this.instruction == InstructionSet.SBM) {
                    this.arith.calculate(2);
                } else {
                    this.arith.calculate(1);
                }
            }
        }
    }

    void setState(InternalState state) {
        this.cycleClock = state;
        if (this.frame != null && this.frame.isShowing()) {
            this.frame.stateChanged(this.cycleClock);
        }
        if (this.isReset()) {
            if (this.cycleClock == InternalState.A1) {
                if (this.resetCounter == 1) {
                    this.setData(new StdLogicVector(4, 0L));
                    this.arith.setCarry(this.data.getValue());
                    this.arith.setAccu(this.data.getValue());
                    this.arith.setTempReg(this.data.getValue());
                    this.addressStack.setLowAddress(this.data.getValue());
                    this.addressStack.setMiddleAddress(this.data.getValue());
                    this.addressStack.setHighAddress(this.data.getValue());
                } else if (this.resetCounter < 5) {
                    this.addressStack.pushAddress();
                }
                this.registers.setRegister(this.data.getValue(), (this.resetCounter - 1) * 2);
                this.registers.setRegister(this.data.getValue(), (this.resetCounter - 1) * 2 + 1);
            }
        } else {
            this.execute();
        }
    }

    boolean hasOutputData() {
        return this.hasOutputData;
    }

    boolean needsInputData() {
        return this.needsInputData;
    }

    boolean isNotifyMemory() {
        return this.notifyMemory;
    }

    i4004InternalReg getOutputData() {
        return this.data;
    }

    i4004InternalReg getCommandLine() {
        return this.commandLine;
    }

    private void execute() {
        if (this.cycleClock == InternalState.A1) {
            this.hasOutputData = true;
            if (this.needs2word) {
                this.cycle2word = 2;
            }
            if (this.instruction == InstructionSet.FIN && this.cycle2word == 2) {
                this.data.setValue(this.registers.getRegister(0).getValue());
            } else {
                this.data.setValue(this.addressStack.getLowAddress().getValue());
            }
        } else if (this.cycleClock == InternalState.A2) {
            if (this.instruction == InstructionSet.FIN && this.cycle2word == 2) {
                this.data.setValue(this.registers.getRegister(1).getValue());
            } else {
                this.data.setValue(this.addressStack.getMiddleAddress().getValue());
            }
        } else if (this.cycleClock == InternalState.A3) {
            this.data.setValue(this.addressStack.getHighAddress().getValue());
        } else if (this.cycleClock == InternalState.M1) {
            this.hasOutputData = false;
            this.addressStack.incrementPC();
        } else if (this.cycleClock == InternalState.M2) {
            Integer oprCode = new Integer((int)this.oprRegister.getValue());
            if (this.instructionSet.isMemoryInstruction(oprCode)) {
                this.notifyMemory = true;
            }
        } else if (this.cycleClock == InternalState.X1) {
            this.notifyMemory = false;
            this.hasOutputData = false;
            Integer oprCode = new Integer((int)this.oprRegister.getValue());
            Integer opaCode = new Integer((int)this.opaRegister.getValue());
            if (!this.needs2word) {
                this.instruction = this.instructionSet.findInstruction(oprCode, opaCode);
                this.needs2word = this.instruction.is2word();
                if (this.frame != null && this.frame.isShowing()) {
                    this.frame.instructionChanged(this.instruction);
                }
            }
            this.executeX1();
        } else if (this.cycleClock == InternalState.X2) {
            this.executeX2();
        } else if (this.cycleClock == InternalState.X3) {
            this.notifyMemory = false;
            this.hasOutputData = false;
            this.needsInputData = false;
            this.executeX3();
            if (this.cycle2word == 2) {
                this.cycle2word = 1;
                this.needs2word = false;
            }
        }
    }

    private void executeX1() {
        if (this.instruction == InstructionSet.JCN) {
            if (this.cycle2word == 1) {
                this.temp.setValue(this.opaRegister.getValue());
                this.conditionMask.setValue(0L);
                this.conditionMask.setBitAt(3, this.temp.getBitAt(3));
                this.temp = this.temp.and_bitwise(new StdLogicVector(4, 1L));
                if (this.temp.has_1() && this.isTestSet()) {
                    this.conditionMask.setBitAt(0, 3);
                }
                this.temp.setValue(this.opaRegister.getValue());
                this.temp = this.temp.and_bitwise(new StdLogicVector(4, 2L));
                if (this.temp.has_1() && this.arith.isCarrySet()) {
                    this.conditionMask.setBitAt(1, 3);
                }
                this.data.setValue(0L);
                this.arith.setCarry(this.data.getValue());
            } else if (this.conditionMask.has_1()) {
                this.data.setValue(this.oprRegister.getValue());
                this.addressStack.setMiddleAddress(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.JIN) {
            this.temp.setValue(this.opaRegister.getValue());
            int register = (int)this.temp.subset(3, 1).getValue() * 2;
            this.data.setValue(this.registers.getRegister(register).getValue());
            this.addressStack.setLowAddress(this.data.getValue());
        } else if (this.instruction == InstructionSet.JUN || this.instruction == InstructionSet.JMS) {
            if (this.cycle2word == 1) {
                this.data.setValue(this.opaRegister.getValue());
                this.arith.setTempReg(this.data.getValue());
            } else {
                if (this.instruction == InstructionSet.JMS) {
                    this.addressStack.pushAddress();
                }
                this.data.setValue(this.opaRegister.getValue());
                this.addressStack.setLowAddress(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.INC || this.instruction == InstructionSet.ISZ) {
            if (this.cycle2word == 1) {
                this.data.setValue(this.registers.getRegister((int)this.opaRegister.getValue()).getValue());
                this.arith.setAccu(this.data.getValue());
            } else if (this.arith.isCarrySet()) {
                this.data.setValue(this.opaRegister.getValue());
                this.addressStack.setLowAddress(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.ADD || this.instruction == InstructionSet.SUB || this.instruction == InstructionSet.XCH) {
            this.data.setValue(this.registers.getRegister((int)this.opaRegister.getValue()).getValue());
            this.arith.setTempReg(this.data.getValue());
            if (this.instruction == InstructionSet.ADD) {
                this.arith.calculate(1);
            } else if (this.instruction == InstructionSet.SUB) {
                this.arith.calculate(2);
            }
        } else if (this.instruction == InstructionSet.LD) {
            this.data.setValue(this.registers.getRegister((int)this.opaRegister.getValue()).getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.BBL || this.instruction == InstructionSet.LDM) {
            if (this.instruction == InstructionSet.BBL) {
                this.addressStack.pullAddress();
            }
            this.data.setValue(this.opaRegister.getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.CLB || this.instruction == InstructionSet.CLC || this.instruction == InstructionSet.IAC || this.instruction == InstructionSet.DAC) {
            this.data.setValue(0L);
            if (this.instruction == InstructionSet.CLB) {
                this.arith.setAccu(this.data.getValue());
            }
            this.arith.setCarry(this.data.getValue());
        } else if (this.instruction == InstructionSet.CMC) {
            if (this.arith.isCarrySet()) {
                this.data.setValue(0L);
            } else {
                this.data.setValue(1L);
            }
            this.arith.setCarry(this.data.getValue());
        } else if (this.instruction == InstructionSet.CMA) {
            this.data.setValue(this.arith.getAccu().getValue());
            this.arith.setTempReg(this.data.getValue());
        } else if (this.instruction == InstructionSet.RAL || this.instruction == InstructionSet.RAR) {
            if (this.instruction == InstructionSet.RAL) {
                this.arith.calculate(3);
            } else {
                this.arith.calculate(4);
            }
            this.data.setValue(this.arith.getResult().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.TCC) {
            this.data.setValue(this.arith.getCarry().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.TCS) {
            this.data.setValue(0L);
            this.arith.setAccu(this.data.getValue());
            this.arith.setTempReg(this.data.getValue());
            this.arith.calculate(2);
        } else if (this.instruction == InstructionSet.STC) {
            this.data.setValue(1L);
            this.arith.setCarry(this.data.getValue());
        } else if (this.instruction == InstructionSet.DAA) {
            this.arith.calculate(5);
            this.data.setValue(this.arith.getResult().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.KBP) {
            this.data.setValue(this.arith.getAccu().getValue());
            this.setOPA(this.data.getValue());
        } else if (this.instruction == InstructionSet.DCL) {
            this.data.setValue(this.arith.getAccu().getValue());
            this.setCommandLine(this.data.getValue());
        }
    }

    private void executeX2() {
        if (this.instruction == InstructionSet.JCN) {
            if (this.cycle2word == 1) {
                this.data.setValue(15L);
                this.arith.setTempReg(this.data.getValue());
                this.arith.calculate(1);
            } else if (this.conditionMask.has_1()) {
                this.data.setValue(this.opaRegister.getValue());
                this.addressStack.setLowAddress(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.SRC) {
            this.notifyMemory = true;
            this.hasOutputData = true;
            this.temp.setValue(this.opaRegister.getValue());
            int register = (int)this.temp.subset(3, 1).getValue() * 2;
            this.data.setValue(this.registers.getRegister(register).getValue());
        } else if (this.instruction == InstructionSet.JIN) {
            this.temp.setValue(this.opaRegister.getValue());
            int register = (int)this.temp.subset(3, 1).getValue() * 2 + 1;
            this.data.setValue(this.registers.getRegister(register).getValue());
            this.addressStack.setMiddleAddress(this.data.getValue());
        } else if ((this.instruction == InstructionSet.JUN || this.instruction == InstructionSet.JMS) && this.cycle2word == 2) {
            this.data.setValue(this.oprRegister.getValue());
            this.addressStack.setMiddleAddress(this.data.getValue());
        } else if (this.instruction == InstructionSet.INC || this.instruction == InstructionSet.ISZ) {
            if (this.cycle2word == 1) {
                this.data.setValue(1L);
                this.arith.setTempReg(this.data.getValue());
                this.arith.calculate(1);
            } else if (this.arith.isCarrySet()) {
                this.data.setValue(this.oprRegister.getValue());
                this.addressStack.setMiddleAddress(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.ADD || this.instruction == InstructionSet.SUB) {
            this.data.setValue(this.arith.getResult().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.XCH) {
            this.data.setValue(this.arith.getAccu().getValue());
            this.registers.setRegister(this.data.getValue(), (int)this.opaRegister.getValue());
        } else if (this.instruction == InstructionSet.WRM || this.instruction == InstructionSet.WMP || this.instruction == InstructionSet.WRR || this.instruction == InstructionSet.WPM || this.instruction == InstructionSet.WR0 || this.instruction == InstructionSet.WR1 || this.instruction == InstructionSet.WR2 || this.instruction == InstructionSet.WR3) {
            this.hasOutputData = true;
            this.data.setValue(this.arith.getAccu().getValue());
        } else if (this.instruction == InstructionSet.RDM || this.instruction == InstructionSet.RDR || this.instruction == InstructionSet.RD0 || this.instruction == InstructionSet.RD1 || this.instruction == InstructionSet.RD2 || this.instruction == InstructionSet.RD3 || this.instruction == InstructionSet.SBM || this.instruction == InstructionSet.ADM) {
            this.needsInputData = true;
        } else if (this.instruction == InstructionSet.IAC || this.instruction == InstructionSet.DAC) {
            this.data.setValue(1L);
            this.arith.setTempReg(this.data.getValue());
            if (this.instruction == InstructionSet.IAC) {
                this.arith.calculate(1);
            } else {
                this.arith.calculate(2);
            }
        } else if (this.instruction == InstructionSet.CMA) {
            this.data.setValue(15L);
            this.arith.setAccu(this.data.getValue());
            this.arith.calculate(2);
        } else if (this.instruction == InstructionSet.TCC) {
            this.data.setValue(0L);
            this.arith.setCarry(this.data.getValue());
        } else if (this.instruction == InstructionSet.TCS) {
            this.data.setValue(this.arith.getResult().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.KBP) {
            Long value = null;
            this.temp.setValue(this.opaRegister.getValue());
            int i = 0;
            while (i < this.temp.getWidth()) {
                if (this.temp.getBitAt(i).is_1()) {
                    value = value == null ? new Long(i + 1) : new Long(15L);
                }
                ++i;
            }
            if (value == null) {
                value = new Long(0L);
            }
            this.data.setValue(value);
            this.arith.setAccu(this.data.getValue());
        }
    }

    private void executeX3() {
        if (this.instruction == InstructionSet.JCN) {
            if (this.cycle2word == 1) {
                this.temp.setValue(this.opaRegister.getValue());
                this.temp = this.temp.and_bitwise(new StdLogicVector(4, 4L));
                if (this.temp.has_1() && !this.arith.isCarrySet()) {
                    this.conditionMask.setBitAt(2, 3);
                }
                this.temp.setValue(this.opaRegister.getValue());
                this.conditionMask = this.conditionMask.getBitAt(3).intValue() == 2 ? this.conditionMask.and_bitwise(this.temp) : this.conditionMask.invert_bitwise().and_bitwise(this.temp);
            } else {
                this.data.setValue(0L);
                this.arith.setCarry(this.data.getValue());
            }
        } else if (this.instruction == InstructionSet.SRC) {
            this.hasOutputData = true;
            this.temp.setValue(this.opaRegister.getValue());
            int register = (int)this.temp.subset(3, 1).getValue() * 2 + 1;
            this.data.setValue(this.registers.getRegister(register).getValue());
        } else if ((this.instruction == InstructionSet.JUN || this.instruction == InstructionSet.JMS) && this.cycle2word == 2) {
            this.data.setValue(this.arith.getTempReg().getValue());
            this.addressStack.setHighAddress(this.data.getValue());
        } else if ((this.instruction == InstructionSet.INC || this.instruction == InstructionSet.ISZ) && this.cycle2word == 1) {
            this.data.setValue(this.arith.getResult().getValue());
            this.registers.setRegister(this.data.getValue(), (int)this.opaRegister.getValue());
        } else if (this.instruction == InstructionSet.XCH) {
            this.data.setValue(this.arith.getTempReg().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.SBM || this.instruction == InstructionSet.ADM || this.instruction == InstructionSet.IAC || this.instruction == InstructionSet.CMA || this.instruction == InstructionSet.DAC) {
            this.data.setValue(this.arith.getResult().getValue());
            this.arith.setAccu(this.data.getValue());
        } else if (this.instruction == InstructionSet.TCS) {
            this.data.setValue(0L);
            this.arith.setCarry(this.data.getValue());
        }
    }

    public void addValueChangeListener(i4004EditorFrame frame) {
        this.frame = frame;
        frame.stateChanged(this.cycleClock);
        frame.instructionChanged(this.instruction);
    }

    AddressStack getAddressStack() {
        return this.addressStack;
    }

    AluRegion getAluRegion() {
        return this.arith;
    }

    ScratchPad getScratchPad() {
        return this.registers;
    }

    i4004InternalReg getOPR() {
        return this.oprRegister;
    }

    i4004InternalReg getOPA() {
        return this.opaRegister;
    }
}

