/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.mcore.McoreALU;
import hades.utils.HexFormat;

public class TestMcore {
    private McoreALU mcore = new McoreALU();

    void test_addc(int rx, int valuex, int ry, int valuey, int valuec) {
        int opcode = 0x600 | ry << 4 | rx;
        int result = 0;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.setC(valuec);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        TestMcore.msg("addc: " + TestMcore._hex(rx, 2) + TestMcore._hex(valuex, 8) + TestMcore._hex(ry, 2) + TestMcore._hex(valuey, 8) + TestMcore._hex(valuec, 1) + " -> addc: " + TestMcore._hex(result, 8) + TestMcore._hex(this.mcore.getC(), 1));
    }

    void test_brev(int rx, int value) {
        int opcode = 0xF0 | rx;
        int result = 0;
        this.mcore.setReg(rx, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        TestMcore.msg("brev: " + TestMcore._hex(rx, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_sync() {
        try {
            this.mcore.decode(1);
            TestMcore.msg("sync: should not arrive here!");
        }
        catch (Throwable t) {
            TestMcore.msg("sync: " + t);
        }
    }

    void test_trap(int vector) {
        try {
            int opcode = 8 | vector & 3;
            this.mcore.decode(opcode);
            TestMcore.msg("trap: should not arrive here!");
        }
        catch (Throwable t) {
            TestMcore.msg("trap: " + t);
        }
    }

    void test_tst(int rx, int valuex, int ry, int valuey) {
        int opcode = 0xE00 | ry << 4 | rx;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.decode(opcode);
        int result = this.mcore.getReg(rx);
        TestMcore.msg("tst: " + TestMcore._hex(rx, 2) + TestMcore._hex(valuex, 8) + TestMcore._hex(ry, 2) + TestMcore._hex(valuey, 8) + "  C= " + TestMcore._hex(this.mcore.getC(), 1) + "  result= " + TestMcore._hex(result, 2));
    }

    void test_tstnbz(int rx, int value) {
        int opcode = 0x190 | rx;
        int carry0 = 0;
        int result = 0;
        this.mcore.setReg(rx, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        TestMcore.msg("tstnbz: " + TestMcore._hex(rx, 2) + TestMcore._hex(value, 8) + TestMcore._hex(carry0, 1) + "   " + TestMcore._hex(result, 8) + TestMcore._hex(this.mcore.getC(), 1));
    }

    void test_xor(int rx, int ry, int valuex, int valuey) {
        int opcode = 0x1700 | ry << 4 | rx;
        int result = 0;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        TestMcore.msg("xor: " + TestMcore._hex(rx, 2) + TestMcore._hex(valuex, 8) + TestMcore._hex(ry, 2) + TestMcore._hex(valuey, 8) + " xor= " + TestMcore._hex(result, 8));
    }

    void test_xsr(int rrrr, int value) {
        int opcode = 0x3800 | rrrr;
        int result = 0;
        int carry = -1;
        int carry0 = -1;
        carry0 = this.mcore.getC();
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        carry = this.mcore.getC();
        TestMcore.msg("xsr: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(carry0, 2) + " >> " + TestMcore._hex(result, 8) + TestMcore._hex(carry, 2));
    }

    void test_xtrb0(int rrrr, int value) {
        int result = this.test_xtrb_(304, rrrr, value);
        TestMcore.msg("xtrb0: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_xtrb1(int rrrr, int value) {
        int result = this.test_xtrb_(288, rrrr, value);
        TestMcore.msg("xtrb1: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_xtrb2(int rrrr, int value) {
        int result = this.test_xtrb_(272, rrrr, value);
        TestMcore.msg("xtrb2: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_xtrb3(int rrrr, int value) {
        int result = this.test_xtrb_(256, rrrr, value);
        TestMcore.msg("xtrb3: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    private int test_xtrb_(int opcode, int rrrr, int value) {
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode |= rrrr);
        return this.mcore.getReg(1);
    }

    void test_zextb(int rrrr, int value) {
        int opcode = 0x140 | rrrr;
        int result = 0;
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        TestMcore.msg("zextb: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_zexth(int rrrr, int value) {
        int opcode = 0x160 | rrrr;
        int result = 0;
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        TestMcore.msg("zexth: " + TestMcore._hex(rrrr, 2) + TestMcore._hex(value, 8) + TestMcore._hex(result, 8));
    }

    void test_all_instructions() {
        TestMcore.msg("");
        this.test_addc(0, 2, 15, 0x3300FF, 0);
        this.test_addc(1, -65521, 14, 65520, 0);
        this.test_addc(2, -65521, 13, 65520, 1);
        this.test_addc(2, -1, 12, -2, 0);
        this.test_addc(3, -1, 11, -2, 1);
        this.test_addc(4, Integer.MAX_VALUE, 10, 2, 0);
        this.test_addc(5, Integer.MIN_VALUE, 9, Integer.MIN_VALUE, 0);
        TestMcore.msg("");
        this.test_brev(0, 1);
        this.test_brev(0, 0x400002);
        this.test_brev(1, -2078212096);
        this.test_brev(9, -268430796);
        TestMcore.msg("");
        this.test_sync();
        TestMcore.msg("");
        this.test_trap(0);
        this.test_trap(3);
        this.test_trap(121);
        TestMcore.msg("");
        this.test_tst(0, 65535, 1, 0x33003300);
        this.test_tst(1, 0x1000000, 2, 1);
        TestMcore.msg("");
        this.test_tstnbz(3, 16909060);
        this.test_tstnbz(3, 0x111111);
        this.test_tstnbz(4, -1);
        this.test_tstnbz(4, 0x11001111);
        this.test_tstnbz(5, -1);
        this.test_tstnbz(5, 0x11110011);
        this.test_tstnbz(6, -1);
        this.test_tstnbz(6, 0x11111100);
        this.test_tstnbz(7, -1);
        this.test_tstnbz(7, 0x1E011001);
        TestMcore.msg("");
        this.test_xor(0, 3, 0, -65535);
        this.test_xor(0, 3, -252645136, 305419896);
        this.test_xor(0, 3, 20447231, -4992);
        TestMcore.msg("");
        this.test_xsr(0, 65537);
        this.test_xsr(1, -267325424);
        this.test_xsr(8, 0xF0F0F0F);
        TestMcore.msg("");
        this.test_xtrb0(2, -2023406815);
        this.test_xtrb0(3, 354826056);
        this.test_xtrb0(1, -889275714);
        this.test_xtrb1(4, -2023406815);
        this.test_xtrb1(5, 354826056);
        this.test_xtrb1(1, -889275714);
        this.test_xtrb2(6, -2023406815);
        this.test_xtrb2(7, 354826056);
        this.test_xtrb2(1, -889275714);
        this.test_xtrb3(8, -2023406815);
        this.test_xtrb3(9, 354826056);
        this.test_xtrb3(1, -889275714);
        TestMcore.msg("");
        this.test_zextb(0, 305419896);
        this.test_zextb(7, -559038737);
        this.test_zextb(15, -889275714);
        TestMcore.msg("");
        this.test_zexth(0, 305419896);
        this.test_zexth(7, -559038737);
        this.test_zexth(15, -889275714);
        TestMcore.msg("");
    }

    public static String _hex(int value, int n_chars) {
        long v_unsigned = value;
        if (v_unsigned < 0L) {
            v_unsigned &= 0xFFFFFFFFL;
        }
        return " " + HexFormat.getHexString(v_unsigned, n_chars) + " ";
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        TestMcore.msg("-I- MCORE selftest started...");
        TestMcore TMC = new TestMcore();
        if (argv.length > 0) {
            TMC.mcore.setEnableMessages(false);
        }
        TestMcore.msg("-1- phase 1: all instructions...");
        TMC.test_all_instructions();
        TestMcore.msg("-2- phase 2: some random instructions...");
    }
}

