/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.mcore.McoreALU;
import hades.utils.HexFormat;

public class McoreMillionCycles {
    private McoreALU mcore = new McoreALU();

    void test_addc(int rx, int valuex, int ry, int valuey, int valuec) {
        int opcode = 0x600 | ry << 4 | rx;
        int result = 0;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.setC(valuec);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        McoreMillionCycles.msg("addc: " + McoreMillionCycles._hex(rx, 2) + McoreMillionCycles._hex(valuex, 8) + McoreMillionCycles._hex(ry, 2) + McoreMillionCycles._hex(valuey, 8) + McoreMillionCycles._hex(valuec, 1) + " -> addc: " + McoreMillionCycles._hex(result, 8) + McoreMillionCycles._hex(this.mcore.getC(), 1));
    }

    void test_brev(int rx, int value) {
        int opcode = 0xF0 | rx;
        int result = 0;
        this.mcore.setReg(rx, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        McoreMillionCycles.msg("brev: " + McoreMillionCycles._hex(rx, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_sync() {
        try {
            this.mcore.decode(1);
            McoreMillionCycles.msg("sync: should not arrive here!");
        }
        catch (Throwable t) {
            McoreMillionCycles.msg("sync: " + t);
        }
    }

    void test_trap(int vector) {
        try {
            int opcode = 8 | vector & 3;
            this.mcore.decode(opcode);
            McoreMillionCycles.msg("trap: should not arrive here!");
        }
        catch (Throwable t) {
            McoreMillionCycles.msg("trap: " + t);
        }
    }

    void test_tst(int rx, int valuex, int ry, int valuey) {
        int opcode = 0xE00 | ry << 4 | rx;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.decode(opcode);
        int result = this.mcore.getReg(rx);
        McoreMillionCycles.msg("tst: " + McoreMillionCycles._hex(rx, 2) + McoreMillionCycles._hex(valuex, 8) + McoreMillionCycles._hex(ry, 2) + McoreMillionCycles._hex(valuey, 8) + "  C= " + McoreMillionCycles._hex(this.mcore.getC(), 1) + "  result= " + McoreMillionCycles._hex(result, 2));
    }

    void test_tstnbz(int rx, int value) {
        int opcode = 0x190 | rx;
        int carry0 = 0;
        int result = 0;
        this.mcore.setReg(rx, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        McoreMillionCycles.msg("tstnbz: " + McoreMillionCycles._hex(rx, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(carry0, 1) + "   " + McoreMillionCycles._hex(result, 8) + McoreMillionCycles._hex(this.mcore.getC(), 1));
    }

    void test_xor(int rx, int ry, int valuex, int valuey) {
        int opcode = 0x1700 | ry << 4 | rx;
        int result = 0;
        this.mcore.setReg(rx, valuex);
        this.mcore.setReg(ry, valuey);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rx);
        McoreMillionCycles.msg("xor: " + McoreMillionCycles._hex(rx, 2) + McoreMillionCycles._hex(valuex, 8) + McoreMillionCycles._hex(ry, 2) + McoreMillionCycles._hex(valuey, 8) + " xor= " + McoreMillionCycles._hex(result, 8));
    }

    void test_xsr(int rrrr, int value) {
        int opcode = 0x3800 | rrrr;
        int result = 0;
        int carry = -1;
        int carry0 = -1;
        carry0 = this.mcore.getC();
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        carry = this.mcore.getC();
        McoreMillionCycles.msg("xsr: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(carry0, 2) + " >> " + McoreMillionCycles._hex(result, 8) + McoreMillionCycles._hex(carry, 2));
    }

    void test_xtrb0(int rrrr, int value) {
        int result = this.test_xtrb_(304, rrrr, value);
        McoreMillionCycles.msg("xtrb0: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_xtrb1(int rrrr, int value) {
        int result = this.test_xtrb_(288, rrrr, value);
        McoreMillionCycles.msg("xtrb1: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_xtrb2(int rrrr, int value) {
        int result = this.test_xtrb_(272, rrrr, value);
        McoreMillionCycles.msg("xtrb2: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_xtrb3(int rrrr, int value) {
        int result = this.test_xtrb_(256, rrrr, value);
        McoreMillionCycles.msg("xtrb3: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    private int test_xtrb_(int opcode, int rrrr, int value) {
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode |= rrrr);
        return this.mcore.getReg(1);
    }

    void test_zextb(int rrrr, int value) {
        int opcode = 0x140 | rrrr;
        int result = 0;
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        McoreMillionCycles.msg("zextb: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_zexth(int rrrr, int value) {
        int opcode = 0x160 | rrrr;
        int result = 0;
        this.mcore.setReg(rrrr, value);
        this.mcore.decode(opcode);
        result = this.mcore.getReg(rrrr);
        McoreMillionCycles.msg("zexth: " + McoreMillionCycles._hex(rrrr, 2) + McoreMillionCycles._hex(value, 8) + McoreMillionCycles._hex(result, 8));
    }

    void test_all_instructions() {
        McoreMillionCycles.msg("");
        this.test_addc(0, 2, 15, 0x3300FF, 0);
        this.test_addc(1, -65521, 14, 65520, 0);
        this.test_addc(2, -65521, 13, 65520, 1);
        this.test_addc(2, -1, 12, -2, 0);
        this.test_addc(3, -1, 11, -2, 1);
        this.test_addc(4, Integer.MAX_VALUE, 10, 2, 0);
        this.test_addc(5, Integer.MIN_VALUE, 9, Integer.MIN_VALUE, 0);
        McoreMillionCycles.msg("");
        this.test_brev(0, 1);
        this.test_brev(0, 0x400002);
        this.test_brev(1, -2078212096);
        this.test_brev(9, -268430796);
        McoreMillionCycles.msg("");
        this.test_sync();
        McoreMillionCycles.msg("");
        this.test_trap(0);
        this.test_trap(3);
        this.test_trap(121);
        McoreMillionCycles.msg("");
        this.test_tst(0, 65535, 1, 0x33003300);
        this.test_tst(1, 0x1000000, 2, 1);
        McoreMillionCycles.msg("");
        this.test_tstnbz(3, 16909060);
        this.test_tstnbz(3, 0x111111);
        this.test_tstnbz(4, -1);
        this.test_tstnbz(4, 0x11001111);
        this.test_tstnbz(5, -1);
        this.test_tstnbz(5, 0x11110011);
        this.test_tstnbz(6, -1);
        this.test_tstnbz(6, 0x11111100);
        this.test_tstnbz(7, -1);
        this.test_tstnbz(7, 0x1E011001);
        McoreMillionCycles.msg("");
        this.test_xor(0, 3, 0, -65535);
        this.test_xor(0, 3, -252645136, 305419896);
        this.test_xor(0, 3, 20447231, -4992);
        McoreMillionCycles.msg("");
        this.test_xsr(0, 65537);
        this.test_xsr(1, -267325424);
        this.test_xsr(8, 0xF0F0F0F);
        McoreMillionCycles.msg("");
        this.test_xtrb0(2, -2023406815);
        this.test_xtrb0(3, 354826056);
        this.test_xtrb0(1, -889275714);
        this.test_xtrb1(4, -2023406815);
        this.test_xtrb1(5, 354826056);
        this.test_xtrb1(1, -889275714);
        this.test_xtrb2(6, -2023406815);
        this.test_xtrb2(7, 354826056);
        this.test_xtrb2(1, -889275714);
        this.test_xtrb3(8, -2023406815);
        this.test_xtrb3(9, 354826056);
        this.test_xtrb3(1, -889275714);
        McoreMillionCycles.msg("");
        this.test_zextb(0, 305419896);
        this.test_zextb(7, -559038737);
        this.test_zextb(15, -889275714);
        McoreMillionCycles.msg("");
        this.test_zexth(0, 305419896);
        this.test_zexth(7, -559038737);
        this.test_zexth(15, -889275714);
        McoreMillionCycles.msg("");
    }

    public static String _hex(int value, int n_chars) {
        long v_unsigned = value;
        if (v_unsigned < 0L) {
            v_unsigned &= 0xFFFFFFFFL;
        }
        return " " + HexFormat.getHexString(v_unsigned, n_chars) + " ";
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        McoreMillionCycles.msg("-I- MCORE selftest started...");
        long n_cycles = Integer.parseInt(argv[0]);
        McoreMillionCycles TMC = new McoreMillionCycles();
        McoreALU mcore = TMC.mcore;
        if (argv.length > 1) {
            mcore.setEnableMessages(false);
        }
        long t0 = System.currentTimeMillis();
        int opcode = 4981;
        int i = 0;
        while ((long)i < n_cycles) {
            opcode = (opcode << 3) + 3 & 0xFFFF;
            mcore.decode(opcode);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("performance: " + n_cycles + "instructions in " + (t1 - t0) + " msec. " + 1000L * n_cycles / (t1 - t0) + " I/sec.");
    }
}

