/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.utils.HexFormat;

public class McoreALU {
    int[] userRegs;
    int[] shadowRegs;
    int[] memory = new int[1024];
    int PC = 42;
    int PSR = 37;
    int[] regs = new int[16];
    int[] cregs = new int[13];
    int _C = 0;
    int opcode;
    int rrrr;
    int ssss;
    int zzzz;
    int tttt;
    int ccccc;
    int iiiii;
    boolean supervisorMode = false;
    static boolean enableMessages = true;
    static boolean debug = false;

    public void setEnableMessages(boolean b) {
        enableMessages = b;
    }

    public void setReg(int rrrr, int value) {
        this.regs[rrrr & 0xF] = value;
    }

    public int getReg(int rrrr) {
        return this.regs[rrrr & 0xF];
    }

    public void setC(int value) {
        this._C = value;
    }

    public int getC() {
        return this._C;
    }

    public void decode(int opcode_) {
        this.opcode = opcode_;
        this.tttt = this.opcode & 0xF000;
        this.rrrr = this.opcode & 0xF;
        this.ssss = (this.opcode & 0xF0) >> 4;
        this.zzzz = (this.opcode & 0xF00) >> 8;
        this.iiiii = this.ccccc = (this.opcode & 0x1F0) >> 4;
        block0 : switch (this.tttt) {
            case 0: {
                this._0000_decoder();
                break;
            }
            case 4096: {
                this._1000_decoder();
                break;
            }
            case 8192: {
                this._2000_decoder();
                break;
            }
            case 12288: {
                this._3000_decoder();
                break;
            }
            case 16384: {
                this._4000_decoder();
                break;
            }
            case 20480: {
                this._illegalOpcode();
                break;
            }
            case 24576: {
                this._movi();
                break;
            }
            case 28672: {
                switch (this.zzzz) {
                    case 0: {
                        this._jmpi();
                        break block0;
                    }
                    case 15: {
                        this._jsri();
                        break block0;
                    }
                }
                this._lrw();
                break;
            }
            case 32768: {
                this._ld();
                break;
            }
            case 36864: {
                this._st();
                break;
            }
            case 40960: {
                this._ld_b();
                break;
            }
            case 45056: {
                this._st_b();
                break;
            }
            case 49152: {
                this._ld_h();
                break;
            }
            case 53248: {
                this._st_h();
                break;
            }
            case 57344: {
                if (this.opcode <= 59391) {
                    this._bt();
                    break;
                }
                this._bf();
                break;
            }
            case 61440: {
                if (this.opcode <= 63487) {
                    this._br();
                    break;
                }
                this._bsr();
                break;
            }
            default: {
                this._illegalOpcode();
            }
        }
    }

    final void _0000_decoder() {
        if (this.opcode <= 15) {
            switch (this.rrrr) {
                case 0: {
                    this._bkpt();
                    break;
                }
                case 1: {
                    this._sync();
                    break;
                }
                case 2: {
                    this._rte();
                    break;
                }
                case 3: {
                    this._rfi();
                    break;
                }
                case 4: {
                    this._stop();
                    break;
                }
                case 5: {
                    this._wait();
                    break;
                }
                case 6: {
                    this._doze();
                    break;
                }
                case 7: {
                    this._illegalOpcode();
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this._trap();
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this._illegalOpcode();
                }
            }
        } else if (this.opcode <= 511) {
            switch (this.ccccc) {
                case 0: {
                    this._internalError();
                    break;
                }
                case 1: {
                    this._mvc();
                    break;
                }
                case 2: {
                    this._illegalOpcode();
                    break;
                }
                case 3: {
                    this._mvcv();
                    break;
                }
                case 4: {
                    this._ldq();
                    break;
                }
                case 5: {
                    this._stq();
                    break;
                }
                case 6: {
                    this._ldm();
                    break;
                }
                case 7: {
                    this._stm();
                    break;
                }
                case 8: {
                    this._dect();
                    break;
                }
                case 9: {
                    this._decf();
                    break;
                }
                case 10: {
                    this._inct();
                    break;
                }
                case 11: {
                    this._incf();
                    break;
                }
                case 12: {
                    this._jmp();
                    break;
                }
                case 13: {
                    this._jsr();
                    break;
                }
                case 14: {
                    this._ff1();
                    break;
                }
                case 15: {
                    this._brev();
                    break;
                }
                case 16: {
                    this._xtrb3();
                    break;
                }
                case 17: {
                    this._xtrb2();
                    break;
                }
                case 18: {
                    this._xtrb1();
                    break;
                }
                case 19: {
                    this._xtrb0();
                    break;
                }
                case 20: {
                    this._zextb();
                    break;
                }
                case 21: {
                    this._sextb();
                    break;
                }
                case 22: {
                    this._zexth();
                    break;
                }
                case 23: {
                    this._sexth();
                    break;
                }
                case 24: {
                    this._declt();
                    break;
                }
                case 25: {
                    this._tstnbz();
                    break;
                }
                case 26: {
                    this._decgt();
                    break;
                }
                case 27: {
                    this._decne();
                    break;
                }
                case 28: {
                    this._clrt();
                    break;
                }
                case 29: {
                    this._clrf();
                    break;
                }
                case 30: {
                    this._abs();
                    break;
                }
                case 31: {
                    this._not();
                    break;
                }
                default: {
                    this._internalError();
                    break;
                }
            }
        } else {
            switch (this.zzzz) {
                case 0: 
                case 1: {
                    this._internalError();
                    break;
                }
                case 2: {
                    this._movt();
                    break;
                }
                case 3: {
                    this._mult();
                    break;
                }
                case 4: {
                    this._loopt();
                    break;
                }
                case 5: {
                    this._subu();
                    break;
                }
                case 6: {
                    this._addc();
                    break;
                }
                case 7: {
                    this._subc();
                    break;
                }
                case 8: 
                case 9: {
                    this._illegalOpcode();
                    break;
                }
                case 10: {
                    this._movf();
                    break;
                }
                case 11: {
                    this._lsr();
                    break;
                }
                case 12: {
                    this._cmphs();
                    break;
                }
                case 13: {
                    this._cmplt();
                    break;
                }
                case 14: {
                    this._tst();
                    break;
                }
                case 15: {
                    this._cmpne();
                }
            }
        }
    }

    final void _1000_decoder() {
        switch (this.zzzz) {
            case 0: 
            case 1: {
                this._mfcr();
                break;
            }
            case 2: {
                this._mov();
                break;
            }
            case 3: {
                this._bgenr();
                break;
            }
            case 4: {
                this._rsub();
                break;
            }
            case 5: {
                this._ixw();
                break;
            }
            case 6: {
                this._and();
                break;
            }
            case 7: {
                this._xor();
                break;
            }
            case 8: 
            case 9: {
                this._mtcr();
                break;
            }
            case 10: {
                this._asr();
                break;
            }
            case 11: {
                this._lsl();
                break;
            }
            case 12: {
                this._addu();
                break;
            }
            case 13: {
                this._ixh();
                break;
            }
            case 14: {
                this._or();
                break;
            }
            case 15: {
                this._andn();
                break;
            }
            default: {
                this._illegalOpcode();
            }
        }
    }

    final void _2000_decoder() {
        switch (this.zzzz) {
            case 0: 
            case 1: {
                this._addi();
                break;
            }
            case 2: 
            case 3: {
                this._cmplti();
                break;
            }
            case 4: 
            case 5: {
                this._subi();
                break;
            }
            case 6: 
            case 7: {
                this._illegalOpcode();
                break;
            }
            case 8: 
            case 9: {
                this._rsubi();
                break;
            }
            case 10: 
            case 11: {
                this._cmpnei();
                break;
            }
            case 12: {
                switch (this.ssss) {
                    case 0: {
                        this._bmaski();
                        break;
                    }
                    case 1: {
                        this._divu();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this._illegalOpcode();
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this._bmaski();
                    }
                }
                break;
            }
            case 13: {
                this._bmaski();
                break;
            }
            case 14: 
            case 15: {
                this._andi();
                break;
            }
            default: {
                this._illegalOpcode();
            }
        }
    }

    final void _3000_decoder() {
        block0 : switch (this.zzzz) {
            case 0: 
            case 1: {
                this._bclri();
                break;
            }
            case 2: {
                switch (this.ssss) {
                    case 0: {
                        this._illegalOpcode();
                        break block0;
                    }
                    case 1: {
                        this._divs();
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this._illegalOpcode();
                        break block0;
                    }
                    case 7: {
                        this._bgeni();
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this._bgeni();
                        break block0;
                    }
                }
                this._internalError();
                break;
            }
            case 3: {
                this._bgeni();
                break;
            }
            case 4: 
            case 5: {
                this._bseti();
                break;
            }
            case 6: 
            case 7: {
                this._btsti();
                break;
            }
            case 8: 
            case 9: {
                if (this.opcode <= 14351) {
                    this._xsr();
                    break;
                }
                this._rotli();
                break;
            }
            case 10: 
            case 11: {
                if (this.opcode <= 14863) {
                    this._asrc();
                    break;
                }
                this._asri();
                break;
            }
            case 12: 
            case 13: {
                if (this.opcode <= 15375) {
                    this._lslc();
                    break;
                }
                this._lsli();
                break;
            }
            case 14: 
            case 15: {
                if (this.opcode <= 15887) {
                    this._lsrc();
                    break;
                }
                this._lsri();
                break;
            }
            default: {
                this._illegalOpcode();
            }
        }
    }

    final void _4000_decoder() {
        switch (this.opcode & 0x380) {
            case 0: 
            case 128: {
                this._h_exec();
                break;
            }
            case 256: {
                this._h_ret();
                break;
            }
            case 384: {
                this._h_call();
                break;
            }
            case 512: {
                this._h_ld();
                break;
            }
            case 640: {
                this._h_st();
                break;
            }
            case 768: {
                this._h_ld_h();
                break;
            }
            case 896: {
                this._h_st_h();
                break;
            }
            default: {
                this._illegalOpcode();
            }
        }
    }

    void _illegalOpcode() {
        if (debug) {
            McoreALU.msg("illegal opcode: " + this.opcode + " " + McoreALU.hex(this.opcode, 8));
        }
    }

    void _abs() {
        if (debug) {
            McoreALU.msg("abs " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = Math.abs(this.rrrr);
    }

    void _addc() {
        if (debug) {
            McoreALU.msg("addc " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        long sum = (long)this.regs[this.ssss] + (long)this.regs[this.rrrr] + (long)this._C;
        this.regs[this.rrrr] = (int)sum;
        this._C = (sum & 0x100000000L) != 0L ? 1 : 0;
    }

    void _addi() {
        if (debug) {
            McoreALU.msg("addi " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] + (this.iiiii + 1);
    }

    void _addu() {
        if (debug) {
            McoreALU.msg("addu " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] + this.regs[this.ssss];
    }

    void _and() {
        if (debug) {
            McoreALU.msg("and " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] & this.regs[this.ssss];
    }

    void _andi() {
        if (debug) {
            McoreALU.msg("andi " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] & this.iiiii;
    }

    void _andn() {
        if (debug) {
            McoreALU.msg("andn " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] & ~this.regs[this.ssss];
    }

    void _asr() {
        if (debug) {
            McoreALU.msg("asr " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] >> (this.regs[this.ssss] & 0x3F);
    }

    void _asrc() {
        if (debug) {
            McoreALU.msg("asrc " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] & 1;
        this.regs[this.rrrr] = this.regs[this.rrrr] >> 1;
    }

    void _asri() {
        if (debug) {
            McoreALU.msg("asri  " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] >> this.iiiii;
    }

    void _bclri() {
        if (debug) {
            McoreALU.msg("bclri " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        int n = this.rrrr;
        this.regs[n] = this.regs[n] | 1 << this.iiiii;
        int n2 = this.rrrr;
        this.regs[n2] = this.regs[n2] ^ 1 << this.iiiii;
    }

    void _bf() {
        int displacement = this.opcode & 0x7FF;
        if (debug) {
            McoreALU.msg("bf  " + McoreALU.hex(displacement, 6));
        }
        if (displacement > 1023) {
            displacement |= 0xFFFFF800;
        }
        this.PC = this._C == 0 ? this.PC + 2 + (displacement << 1) : (this.PC += 2);
    }

    void _bgeni() {
        if (debug) {
            McoreALU.msg("bgeni  " + this.formatReg(this.rrrr) + "," + this.iiiii);
        }
        if (this.iiiii < 7) {
            this._internalError();
        }
        this.regs[this.rrrr] = 1 << this.iiiii;
    }

    void _bgenr() {
        if (debug) {
            McoreALU.msg("bgenr " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = 1 << (this.regs[this.ssss] & 0x1F);
    }

    void _bkpt() {
        if (debug) {
            McoreALU.msg("bkpt ");
        }
        if (debug) {
            McoreALU.msg("NOT IMPLEMENTED YET");
        }
    }

    void _bmaski() {
        if (debug) {
            McoreALU.msg("bmaski " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        int tmp = this.regs[this.rrrr];
        switch (this.iiiii) {
            case 0: {
                tmp = -1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this._internalError();
                break;
            }
            case 8: {
                tmp = 255;
                break;
            }
            case 9: {
                tmp = 511;
                break;
            }
            case 10: {
                tmp = 1023;
                break;
            }
            case 11: {
                tmp = 2047;
                break;
            }
            case 12: {
                tmp = 4095;
                break;
            }
            case 13: {
                tmp = 8191;
                break;
            }
            case 14: {
                tmp = 16383;
                break;
            }
            case 15: {
                tmp = Short.MAX_VALUE;
                break;
            }
            case 16: {
                tmp = 65535;
                break;
            }
            case 17: {
                tmp = 131071;
                break;
            }
            case 18: {
                tmp = 262143;
                break;
            }
            case 19: {
                tmp = 524287;
                break;
            }
            case 20: {
                tmp = 1048575;
                break;
            }
            case 21: {
                tmp = 0x1FFFFF;
                break;
            }
            case 22: {
                tmp = 0x3FFFFF;
                break;
            }
            case 23: {
                tmp = 0x7FFFFF;
                break;
            }
            case 24: {
                tmp = 0xFFFFFF;
                break;
            }
            case 25: {
                tmp = 0x1FFFFFF;
                break;
            }
            case 26: {
                tmp = 0x3FFFFFF;
                break;
            }
            case 27: {
                tmp = 0x7FFFFFF;
                break;
            }
            case 28: {
                tmp = 0xFFFFFFF;
                break;
            }
            case 29: {
                tmp = 0x1FFFFFFF;
                break;
            }
            case 30: {
                tmp = 0x3FFFFFFF;
                break;
            }
            case 31: {
                tmp = Integer.MAX_VALUE;
            }
        }
        this.regs[this.rrrr] = tmp;
    }

    void _br() {
        int displacement = this.opcode & 0x7FF;
        if (debug) {
            McoreALU.msg("br  " + McoreALU.hex(displacement, 6));
        }
        if (displacement > 1023) {
            displacement |= 0xFFFFF800;
        }
        this.PC = this.PC + 2 + (displacement << 1);
    }

    void _brev() {
        if (debug) {
            McoreALU.msg("brev " + this.formatReg(this.rrrr));
        }
        int source = this.regs[this.rrrr];
        int result = 0;
        int i = 0;
        while (i < 32) {
            if ((source & 1) != 0) {
                result |= 1;
            }
            source >>>= 1;
            if (i < 31) {
                result <<= 1;
            }
            ++i;
        }
        this.regs[this.rrrr] = result;
        if (debug) {
            McoreALU.msg("... " + McoreALU.hex(source, 8) + " " + McoreALU.hex(result, 8));
        }
    }

    void _bseti() {
        if (debug) {
            McoreALU.msg("bseti " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        int n = this.rrrr;
        this.regs[n] = this.regs[n] | 1 << this.iiiii;
    }

    void _bsr() {
        int displacement = this.opcode & 0x7FF;
        if (debug) {
            McoreALU.msg("bsr  " + McoreALU.hex(displacement, 6));
        }
        if (displacement > 1023) {
            displacement |= 0xFFFFF800;
        }
        this.regs[15] = this.PC + 2;
        this.PC = this.PC + 2 + (displacement << 1);
    }

    void _bt() {
        int displacement = this.opcode & 0x7FF;
        if (debug) {
            McoreALU.msg("br  " + McoreALU.hex(displacement, 6));
        }
        if (displacement > 1023) {
            displacement |= 0xFFFFF800;
        }
        this.PC = this._C == 1 ? this.PC + 2 + (displacement << 1) : (this.PC += 2);
    }

    void _btsti() {
        if (debug) {
            McoreALU.msg("btsti " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        this._C = (this.regs[this.rrrr] & 1 << this.iiiii) > 0 ? 1 : 0;
    }

    void _clrf() {
        if (debug) {
            McoreALU.msg("clrf " + this.formatReg(this.rrrr));
        }
        if (this._C == 0) {
            this.regs[this.rrrr] = 0;
        }
    }

    void _clrt() {
        if (debug) {
            McoreALU.msg("clrt " + this.formatReg(this.rrrr));
        }
        if (this._C == 1) {
            this.regs[this.rrrr] = 0;
        }
    }

    void _cmphs() {
        long ry;
        long rx;
        if (debug) {
            McoreALU.msg("cmphs " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this._C = (rx = (long)this.regs[this.rrrr]) >= (ry = (long)this.regs[this.ssss]) ? 1 : 0;
    }

    void _cmplt() {
        if (debug) {
            McoreALU.msg("cmplt " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] < this.regs[this.ssss] ? 1 : 0;
    }

    void _cmplti() {
        if (debug) {
            McoreALU.msg("cmplti " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] < this.iiiii ? 1 : 0;
    }

    void _cmpne() {
        if (debug) {
            McoreALU.msg("cmpne " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] != this.regs[this.ssss] ? 1 : 0;
    }

    void _cmpnei() {
        if (debug) {
            McoreALU.msg("cmpnei " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] != this.ccccc ? 1 : 0;
    }

    void _decf() {
        if (debug) {
            McoreALU.msg("decf " + this.formatReg(this.rrrr));
        }
        if (this._C == 0) {
            int n = this.rrrr;
            this.regs[n] = this.regs[n] - 1;
        }
    }

    void _decgt() {
        if (debug) {
            McoreALU.msg("decgt " + this.formatReg(this.rrrr));
        }
        int n = this.rrrr;
        this.regs[n] = this.regs[n] - 1;
        this._C = this.regs[this.rrrr] > 0 ? 1 : 0;
    }

    void _decne() {
        if (debug) {
            McoreALU.msg("decne " + this.formatReg(this.rrrr));
        }
        int n = this.rrrr;
        this.regs[n] = this.regs[n] - 1;
        this._C = this.regs[this.rrrr] != 0 ? 1 : 0;
    }

    void _declt() {
        if (debug) {
            McoreALU.msg("declt " + this.formatReg(this.rrrr));
        }
        int n = this.rrrr;
        this.regs[n] = this.regs[n] - 1;
        this._C = this.regs[this.rrrr] < 0 ? 1 : 0;
    }

    void _dect() {
        if (debug) {
            McoreALU.msg("dect " + this.formatReg(this.rrrr));
        }
        if (this._C == 1) {
            int n = this.rrrr;
            this.regs[n] = this.regs[n] - 1;
        }
    }

    void _divs() {
        if (debug) {
            McoreALU.msg("divs " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        if (this.regs[1] == 0) {
            this._divideByZero();
        } else {
            this.regs[this.rrrr] = this.regs[this.rrrr] / this.regs[1];
        }
    }

    void _divu() {
        if (debug) {
            McoreALU.msg("divu " + McoreALU.hex(this.iiiii, 2) + " " + this.formatReg(this.rrrr));
        }
        if (this.regs[1] == 0) {
            this._divideByZero();
        } else {
            long rx = this.regs[this.rrrr];
            long r1 = this.regs[1];
            this.regs[this.rrrr] = (int)(rx /= r1);
        }
    }

    void _divideByZero() {
        throw new Error("_divideByZero not handled yet!");
    }

    void _doze() {
        if (debug) {
            McoreALU.msg("doze");
        }
        throw new Error("_doze not implemented yet!");
    }

    void _ff1() {
        if (debug) {
            McoreALU.msg("ff1 " + this.formatReg(this.rrrr));
        }
        int mask = Integer.MIN_VALUE;
        int rx = this.regs[this.rrrr];
        int count = 0;
        count = 0;
        while (count <= 32) {
            if ((rx & mask) != 0) break;
            mask >>>= 1;
            ++count;
        }
        this.regs[this.rrrr] = count;
    }

    void _incf() {
        if (debug) {
            McoreALU.msg("incf " + this.formatReg(this.rrrr));
        }
        if (this._C == 0) {
            int n = this.rrrr;
            this.regs[n] = this.regs[n] + 1;
        }
    }

    void _inct() {
        if (debug) {
            McoreALU.msg("incf " + this.formatReg(this.rrrr));
        }
        if (this._C == 1) {
            int n = this.rrrr;
            this.regs[n] = this.regs[n] + 1;
        }
    }

    void _ixh() {
        if (debug) {
            McoreALU.msg("ixh " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] + (this.regs[this.ssss] << 1);
    }

    void _ixw() {
        if (debug) {
            McoreALU.msg("ixw " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] + (this.regs[this.ssss] << 2);
    }

    void _jmp() {
        if (debug) {
            McoreALU.msg("jmp " + this.formatReg(this.rrrr));
        }
        this.PC = this.regs[this.rrrr];
    }

    void _jmpi() {
        int disp8 = this.opcode & 0xFF;
        int addr = this.PC + 2 + (disp8 << 2) & 0xFFFFFFFC;
        if (debug) {
            McoreALU.msg("jmpi " + McoreALU.hex(disp8, 4));
        }
        this.PC = this.readMemory(addr);
    }

    void _jsr() {
        if (debug) {
            McoreALU.msg("jsr " + this.formatReg(this.rrrr));
        }
        if (this.rrrr == 15) {
            throw new Error("JSR R15 undefined");
        }
        this.regs[15] = this.PC + 2;
        this.PC = this.regs[this.rrrr];
    }

    void _jsri() {
        int disp8 = this.opcode & 0xFF;
        int addr = this.PC + 2 + (disp8 << 2) & 0xFFFFFFFC;
        if (debug) {
            McoreALU.msg("jsri " + McoreALU.hex(disp8, 4));
        }
        this.regs[15] = this.PC + 2;
        this.PC = this.readMemory(addr);
    }

    void _ld() {
        if (debug) {
            McoreALU.msg("ld   " + McoreALU.hex(this.zzzz, 2) + ", (" + McoreALU.hex(this.ssss, 2) + "," + McoreALU.hex(this.rrrr, 2) + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 2);
        this.regs[this.zzzz] = this.readMemory(addr);
    }

    void _ld_b() {
        if (debug) {
            McoreALU.msg("ld.b " + McoreALU.hex(this.zzzz, 2) + ", (" + McoreALU.hex(this.ssss, 2) + "," + McoreALU.hex(this.rrrr, 2) + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 0);
        this.regs[this.zzzz] = this.readMemory(addr);
    }

    void _ld_h() {
        if (debug) {
            McoreALU.msg("ld.h " + McoreALU.hex(this.zzzz, 2) + ", (" + McoreALU.hex(this.ssss, 2) + "," + McoreALU.hex(this.rrrr, 2) + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 1);
        this.regs[this.zzzz] = this.readMemory(addr);
    }

    void _ldm() {
        if (debug) {
            McoreALU.msg("ldm " + this.formatReg(this.rrrr) + "-R15,(R0)");
        }
        if (this.rrrr == 0) {
            throw new Error("LDM R0 undefined");
        }
        if (this.rrrr == 15) {
            throw new Error("LDM R15 undefined");
        }
        int i = this.rrrr;
        while (i <= 15) {
            this.regs[i] = this.readMemory(this.regs[0] + i);
            ++i;
        }
    }

    void _ldq() {
        if (debug) {
            McoreALU.msg("ldq  R4-R7,(" + this.formatReg(this.rrrr) + ")");
        }
        if (this.rrrr >= 4 && this.rrrr <= 7) {
            throw new Error("LDM undefined for source " + this.rrrr);
        }
        int i = 4;
        while (i <= 7) {
            this.regs[i] = this.readMemory(this.regs[this.rrrr] + i);
            ++i;
        }
    }

    void _loopt() {
        if (debug) {
            McoreALU.msg("loopt " + this.formatReg(this.ssss) + ", " + McoreALU.hex(this.rrrr, 2));
        }
        if (this._C == 1) {
            int disp4 = 0xFFFFFFE0 | this.rrrr << 1;
            this.PC = this.PC + 2 + disp4;
        }
        this.regs[this.ssss] = this.regs[this.ssss] - 1;
        this._C = this.regs[this.ssss] > 0 ? 1 : 0;
    }

    void _lrw() {
        int disp8 = this.opcode & 0xFF;
        if (debug) {
            McoreALU.msg("lrw  " + this.formatReg(this.zzzz) + ",[" + McoreALU.hex(disp8, 4) + "]");
        }
        int addr = this.PC + 2 + (disp8 << 2) & 0xFFFFFFFC;
        this.regs[this.zzzz] = this.readMemory(addr);
    }

    void _lsl() {
        if (debug) {
            McoreALU.msg("lsl " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] << (this.regs[this.ssss] & 0x3F);
    }

    void _lslc() {
        if (debug) {
            McoreALU.msg("lslc " + this.formatReg(this.rrrr));
        }
        this._C = (this.regs[this.rrrr] & Integer.MIN_VALUE) != 0 ? 1 : 0;
        this.regs[this.rrrr] = this.regs[this.rrrr] << 1;
    }

    void _lsli() {
        if (debug) {
            McoreALU.msg("lsli " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] << this.iiiii;
    }

    void _lsr() {
        if (debug) {
            McoreALU.msg("lsr " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] >>> (this.regs[this.ssss] & 0x3F);
    }

    void _lsrc() {
        if (debug) {
            McoreALU.msg("lsrc " + this.formatReg(this.rrrr));
        }
        this._C = this.regs[this.rrrr] & 1;
        this.regs[this.rrrr] = this.regs[this.rrrr] >>> 1;
    }

    void _lsri() {
        if (debug) {
            McoreALU.msg("lsri " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] >>> this.iiiii;
    }

    void _mfcr() {
        if (debug) {
            McoreALU.msg("mfcr " + this.formatReg(this.rrrr) + ", " + this.formatCReg5(this.ccccc));
        }
        this.checkPrivileged();
        this.regs[this.rrrr] = this.cregs[this.ccccc];
    }

    void _mov() {
        if (debug) {
            McoreALU.msg("mov " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.ssss];
    }

    void _movf() {
        if (debug) {
            McoreALU.msg("movf " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        if (this._C == 0) {
            this.regs[this.rrrr] = this.regs[this.ssss];
        }
    }

    void _movi() {
        if (this.opcode >= 26624) {
            this._illegalOpcode();
        }
        int imm7 = this.opcode >> 4 & 0x7F;
        if (debug) {
            McoreALU.msg("movi " + this.formatReg(this.rrrr) + ", " + McoreALU.hex(imm7, 4));
        }
        this.regs[this.rrrr] = imm7;
    }

    void _movt() {
        if (debug) {
            McoreALU.msg("movt " + this.formatReg(this.ssss) + ", " + this.formatReg(this.rrrr));
        }
        if (this._C == 1) {
            this.regs[this.rrrr] = this.regs[this.ssss];
        }
    }

    void _mtcr() {
        if (debug) {
            McoreALU.msg("mtcr " + this.formatReg(this.rrrr) + ", " + this.formatCReg5(this.ccccc));
        }
        this.checkPrivileged();
        this.cregs[this.ccccc] = this.regs[this.rrrr];
    }

    void _mult() {
        if (debug) {
            McoreALU.msg("mult " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] * this.regs[this.ssss];
    }

    void _mvc() {
        if (debug) {
            McoreALU.msg("mvc " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this._C;
    }

    void _mvcv() {
        if (debug) {
            McoreALU.msg("mvcv " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = 1 & ~this._C;
    }

    void _not() {
        if (debug) {
            McoreALU.msg("not " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = ~this.regs[this.rrrr];
    }

    void _or() {
        if (debug) {
            McoreALU.msg("or " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] | this.regs[this.ssss];
    }

    void _rfi() {
        if (debug) {
            McoreALU.msg("rfi");
        }
        this.checkPrivileged();
        this.PC = this.cregs[5];
        this.PSR = this.cregs[3];
    }

    void _rotli() {
        if (debug) {
            McoreALU.msg("rotli " + this.formatReg(this.rrrr) + ", " + this.ccccc);
        }
        long tmptmp = ((long)this.regs[this.rrrr] << 32) + (long)this.regs[this.rrrr];
        this.regs[this.rrrr] = (int)(tmptmp << this.ccccc >> 32);
    }

    void _rsub() {
        if (debug) {
            McoreALU.msg("rsub " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.ssss] - this.regs[this.rrrr];
    }

    void _rsubi() {
        if (debug) {
            McoreALU.msg("rsubi " + this.formatReg(this.rrrr) + ", " + this.iiiii);
        }
        this.regs[this.rrrr] = this.iiiii - this.regs[this.rrrr];
    }

    void _rte() {
        if (debug) {
            McoreALU.msg("rte");
        }
        this.checkPrivileged();
        this.PC = this.cregs[4];
        this.PSR = this.cregs[2];
    }

    void _sextb() {
        int tmp;
        if (debug) {
            McoreALU.msg("sextb " + this.formatReg(this.rrrr));
        }
        if ((tmp = this.regs[this.rrrr] & 0xFF) > 127) {
            tmp |= 0xFFFFFF00;
        }
        this.regs[this.rrrr] = tmp;
    }

    void _sexth() {
        int tmp;
        if (debug) {
            McoreALU.msg("sexth " + this.formatReg(this.rrrr));
        }
        if ((tmp = this.regs[this.rrrr] & 0xFFFF) > Short.MAX_VALUE) {
            tmp |= 0xFFFF0000;
        }
        this.regs[this.rrrr] = tmp;
    }

    void _st() {
        if (debug) {
            McoreALU.msg("st " + this.formatReg(this.zzzz) + ", (" + this.formatReg(this.rrrr) + ", " + this.ssss + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 2);
        this.writeMemory(addr, this.regs[this.zzzz]);
    }

    void _st_b() {
        if (debug) {
            McoreALU.msg("stb " + this.formatReg(this.zzzz) + ", (" + this.formatReg(this.rrrr) + ", " + this.ssss + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 0);
        this.writeMemory(addr, this.regs[this.zzzz]);
    }

    void _st_h() {
        if (debug) {
            McoreALU.msg("sth " + this.formatReg(this.zzzz) + ", (" + this.formatReg(this.rrrr) + ", " + this.ssss + ")");
        }
        int addr = this.regs[this.rrrr] + (this.ssss << 1);
        this.writeMemory(addr, this.regs[this.zzzz]);
    }

    void _stm() {
        if (debug) {
            McoreALU.msg("stm " + this.formatReg(this.rrrr) + "-R15, (R0)");
        }
        if (this.rrrr == 0) {
            throw new Error("STM R0 undefined");
        }
        if (this.rrrr == 15) {
            throw new Error("STM R15 undefined");
        }
        int i = this.rrrr;
        while (i <= 15) {
            this.writeMemory(this.regs[0] + i, this.regs[i]);
            ++i;
        }
    }

    void _stop() {
        if (debug) {
            McoreALU.msg("stop ");
        }
        this.checkPrivileged();
        throw new Error("STOP not implemented yet!");
    }

    void _stq() {
        if (debug) {
            McoreALU.msg("stq  R4-R7,(" + this.formatReg(this.rrrr) + ")");
        }
        if (this.rrrr >= 4 && this.rrrr <= 7) {
            throw new Error("STM undefined for source " + this.rrrr);
        }
        int i = 4;
        while (i <= 7) {
            this.writeMemory(this.regs[this.rrrr] + i, this.regs[i]);
            ++i;
        }
    }

    void _subc() {
        if (debug) {
            McoreALU.msg("subc " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        long sum = (long)this.regs[this.rrrr] - (long)this.regs[this.ssss];
        if (this._C == 0) {
            --sum;
        }
        this.regs[this.rrrr] = (int)sum;
        this._C = (sum & 0x100000000L) != 0L ? 1 : 0;
    }

    void _subi() {
        if (debug) {
            McoreALU.msg("subi " + this.formatReg(this.rrrr) + ", " + this.ccccc);
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] - (this.ccccc + 1);
    }

    void _subu() {
        if (debug) {
            McoreALU.msg("subu " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] - this.regs[this.ssss];
    }

    void _sync() {
        if (debug) {
            McoreALU.msg("sync");
        }
        throw new Error("SYNC instruction not implemented, ignored!");
    }

    void _trap() {
        int vector = this.opcode & 3;
        if (debug) {
            McoreALU.msg("trap: " + vector);
        }
        throw new Error("TRAP " + vector + " not implemented yet!");
    }

    void _tst() {
        if (debug) {
            McoreALU.msg("tst " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this._C = (this.regs[this.rrrr] & this.regs[this.ssss]) != 0 ? 1 : 0;
    }

    void _tstnbz() {
        int tmp;
        if (debug) {
            McoreALU.msg("tstnbz " + this.formatReg(this.rrrr));
        }
        this._C = ((tmp = this.regs[this.rrrr]) & 0xFF000000) == 0 || (tmp & 0xFF0000) == 0 || (tmp & 0xFF00) == 0 || (tmp & 0xFF) == 0 ? 0 : 1;
    }

    void _wait() {
        if (debug) {
            McoreALU.msg("wait");
        }
        this.checkPrivileged();
        throw new Error("WAIT instruction not implemented yet!");
    }

    void _xor() {
        if (debug) {
            McoreALU.msg("xor " + this.formatReg(this.rrrr) + ", " + this.formatReg(this.ssss));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] ^ this.regs[this.ssss];
    }

    void _xsr() {
        if (debug) {
            McoreALU.msg("xsr " + this.formatReg(this.rrrr));
        }
        int _Ctmp = this._C != 0 ? Integer.MIN_VALUE : 0;
        this._C = this.regs[this.rrrr] & 1;
        this.regs[this.rrrr] = this.regs[this.rrrr] >>> 1;
        int n = this.rrrr;
        this.regs[n] = this.regs[n] | _Ctmp;
    }

    void _xtrb0() {
        if (debug) {
            McoreALU.msg("xtrb0 " + this.formatReg(this.rrrr));
        }
        this.regs[1] = (this.regs[this.rrrr] & 0xFF000000) >>> 24;
        this._C = this.regs[1] != 0 ? 1 : 0;
    }

    void _xtrb1() {
        if (debug) {
            McoreALU.msg("xtrb1 " + this.formatReg(this.rrrr));
        }
        this.regs[1] = (this.regs[this.rrrr] & 0xFF0000) >>> 16;
        this._C = this.regs[1] != 0 ? 1 : 0;
    }

    void _xtrb2() {
        if (debug) {
            McoreALU.msg("xtrb2 " + this.formatReg(this.rrrr));
        }
        this.regs[1] = (this.regs[this.rrrr] & 0xFF00) >>> 8;
        this._C = this.regs[1] != 0 ? 1 : 0;
    }

    void _xtrb3() {
        if (debug) {
            McoreALU.msg("xtrb3 " + this.formatReg(this.rrrr));
        }
        this.regs[1] = this.regs[this.rrrr] & 0xFF;
        this._C = this.regs[1] != 0 ? 1 : 0;
    }

    void _zextb() {
        if (debug) {
            McoreALU.msg("zextb " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] & 0xFF;
    }

    void _zexth() {
        if (debug) {
            McoreALU.msg("zexth " + this.formatReg(this.rrrr));
        }
        this.regs[this.rrrr] = this.regs[this.rrrr] & 0xFFFF;
    }

    void _h_exec() {
        if (debug) {
            McoreALU.msg("h_exec ");
        }
    }

    void _h_ret() {
        if (debug) {
            McoreALU.msg("h_ret ");
        }
    }

    void _h_call() {
        if (debug) {
            McoreALU.msg("h_call ");
        }
    }

    void _h_ld() {
        if (debug) {
            McoreALU.msg("h_ld ");
        }
    }

    void _h_st() {
        if (debug) {
            McoreALU.msg("h_st ");
        }
    }

    void _h_ld_h() {
        if (debug) {
            McoreALU.msg("h_ld.h ");
        }
    }

    void _h_st_h() {
        if (debug) {
            McoreALU.msg("h_st.h ");
        }
    }

    int readMemory(int addr) {
        return this.memory[addr];
    }

    void writeMemory(int addr, int data) {
        this.memory[addr] = data;
    }

    String formatReg(int rrrr) {
        return "R" + rrrr;
    }

    String formatCReg5(int ccccc) {
        return "R" + ccccc;
    }

    void checkPrivileged() {
        if (!this.supervisorMode) {
            throw new Error("Priviled instruction");
        }
    }

    void _internalError() {
        if (debug) {
            McoreALU.msg("internal error: unused opcode= " + this.opcode);
        }
    }

    static String hex(int value, int n_chars) {
        return HexFormat.getHexString(value, n_chars);
    }

    static void msg(String s) {
        if (enableMessages) {
            System.out.println(s);
        }
    }

    public static void main(String[] argv) {
        if (debug) {
            McoreALU.msg("MCORE decoding selftest...");
        }
        McoreALU mcore = new McoreALU();
        int i = 0;
        while (i < 2048) {
            mcore.decode(i);
            ++i;
        }
    }
}

