/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;

public class RemoteIpin
extends SimObject {
    String urlBase = "http://tech-www.informatik.uni-hamburg.de/cgi-bin/dummy";
    String userID = "0815";
    protected PortStdLogic1164[] yports = null;
    protected PortStdLogic1164 port_sample = null;
    protected PortStdLogic1164 port_error = null;
    private static String[] ynames = new String[]{"YA0", "YA1", "YA2", "YA3", "YA4", "YA5", "YA6", "YA7", "YB0", "YB1", "YB2", "YB3", "YB4", "YB5", "YB6", "YB7", "YC0", "YC1", "YC2", "YC3", "YC4", "YC5", "YC6", "YC7"};

    public int getNumberOfOutputs() {
        return 24;
    }

    public RemoteIpin() {
        this.createPorts();
    }

    public void createPorts() {
        int N_OUTPUTS = this.getNumberOfOutputs();
        this.yports = new PortStdLogic1164[N_OUTPUTS];
        int i = 0;
        while (i < N_OUTPUTS) {
            this.yports[i] = new PortStdLogic1164(this, ynames[i], 1, null);
            ++i;
        }
        this.port_error = new PortStdLogic1164(this, "error", 1, null);
        this.port_sample = new PortStdLogic1164(this, "sample", 0, null);
        this.ports = new Port[N_OUTPUTS + 2];
        int i2 = 0;
        while (i2 < N_OUTPUTS) {
            this.ports[i2] = this.yports[i2];
            ++i2;
        }
        this.ports[N_OUTPUTS] = this.port_error;
        this.ports[N_OUTPUTS + 1] = this.port_sample;
    }

    public String encodeURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.urlBase);
        sb.append("?");
        sb.append(this.userID);
        sb.append(":");
        sb.append(this.encodeTime(this.getSimTimeOr0()));
        return sb.toString();
    }

    public String encodeTime(double time) {
        return Long.toHexString(Double.doubleToLongBits(time));
    }

    public double getSimTimeOr0() {
        if (this.simulator != null) {
            return this.simulator.getSimTime();
        }
        return 0.0;
    }

    public void parseURLData() {
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String s) {
        this.urlBase = s;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String s) {
        this.userID = s;
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        this.schedule(this.port_error, Const1164.__0, 0.0);
        int n_outputs = this.getNumberOfOutputs();
        int i = 0;
        while (i < n_outputs) {
            this.schedule(this.yports[i], Const1164.__0, 0.0);
            ++i;
        }
    }

    public void evaluate(Object arg) {
        if (this.port_sample.hasEvent() && this.port_sample.getValueOrU().is_1()) {
            this.readFromRemoteServer();
        }
    }

    public void readFromRemoteServer() {
        double now = this.simulator.getSimTime();
        String encoded = this.encodeURL();
        System.out.println("RemoteIpin.rfrs: URL='" + encoded + "'");
        try {
            URL url = new URL(encoded);
            url.openConnection();
            InputStream IS = url.openStream();
            BufferedReader BR = new BufferedReader(new InputStreamReader(IS));
            String line = null;
            String line2 = null;
            while ((line = BR.readLine()) != null) {
                System.out.println(line);
                line2 = line;
            }
            int n = line2.length();
            int n_outputs = this.getNumberOfOutputs();
            int i = 0;
            while (i < n_outputs) {
                StdLogic1164 value = new StdLogic1164(line2.charAt(n - 1 - i));
                this.schedule(this.yports[i], value, now);
                ++i;
            }
            IS.close();
            this.schedule(this.port_error, Const1164.__0, now);
        }
        catch (Exception e) {
            System.out.println("RemoteIpin.rfrs: " + e);
            e.printStackTrace();
            this.schedule(this.port_error, Const1164.__1, now);
        }
    }

    private void schedule(Port port, StdLogic1164 value, double time) {
        Signal signal = port.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
        }
    }

    public SimObject copy() {
        RemoteIpin clone = (RemoteIpin)super.copy();
        clone.setUrlBase(this.getUrlBase());
        clone.setUserID(this.getUserID());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "URL='" + this.encodeURL() + "'";
    }

    public String toString() {
        return "RemoteIpin: " + this.getFullName();
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.urlBase) + " " + NameMangler.encodeWithUnicodeEscapes(this.userID));
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.urlBase = NameMangler.decodeUnicodeEscapes(st.nextToken());
            this.userID = NameMangler.decodeUnicodeEscapes(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- RemoteIpin.initialize: " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this RemoteIpin...");
        }
        String[] fields = new String[]{"instance name:", "name", "base URL:", "urlBase", "user ID:", "userID"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("no help yet");
        this.propertySheet.setVisible(true);
    }
}

