/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.OutputConnector;
import hades.models.StdLogic1164;
import hades.models.io.Opin;
import hades.symbols.ColoredCircle;
import hades.symbols.Label;
import hades.symbols.Symbol;
import java.awt.Color;
import java.util.Enumeration;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class OpinWithLabel
extends Opin
implements OutputConnector {
    static Color[] _colors = new Color[]{Color.black, Color.black, Color.black, Color.white, Color.black, Color.white, Color.white, Color.white, Color.white};
    private Label valueLabel = null;

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        FigObject tmp = null;
        if (this.symbol == null) {
            return;
        }
        Enumeration e = this.symbol.elements();
        while (e.hasMoreElements()) {
            tmp = (FigObject)e.nextElement();
            if (!(tmp instanceof ColoredCircle)) continue;
            this.showOnOff = (ColoredCircle)tmp;
            this.showState(new StdLogic1164());
            break;
        }
        this.valueLabel = new Label();
        this.valueLabel.initialize("450 150 2 $");
        this.symbol.addMember(this.valueLabel);
    }

    protected void showState(StdLogic1164 value) {
        if (!this.visible) {
            return;
        }
        if (this.showOnOff == null) {
            this.message(this.toString() + ".showState: showOnOff is null...");
            return;
        }
        FigAttribs attr = this.showOnOff.getAttributes();
        Color color = value.getColor();
        if (value.is_0()) {
            attr.fig_fill_color = 0;
            attr.fig_area_fill = 5;
        } else if (value.is_1()) {
            attr.fig_fill_color = 4;
            attr.fig_area_fill = 20;
        } else if (value.is_Z()) {
            attr.fig_fill_color = 6;
            attr.fig_area_fill = 20;
        } else {
            attr.fig_fill_color = 3;
            attr.fig_area_fill = 20;
        }
        attr.fillStyle = 2;
        attr.fillColor = color;
        this.showOnOff.setAttributes(attr);
        if (this.showOnOff.painter != null) {
            this.showOnOff.painter.paint(this.showOnOff);
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText("" + value.getChar());
            this.valueLabel.getAttributes().lineColor = _colors[value.intValue()];
            this.valueLabel.painter.paint(this.valueLabel);
        }
    }

    public String toString() {
        return "OpinWithLabel: " + this.getFullName();
    }
}

