/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.StdLogic1164;
import hades.models.io.SevenSegment;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ColoredPolyline;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.io.Serializable;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class HexDisplaySmall
extends SevenSegment
implements Simulatable,
Serializable {
    int index;
    private static int[][] CMATRIX = new int[][]{{1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 1}, {1, 1, 1, 1, 0, 0, 1}, {0, 1, 1, 0, 0, 1, 1}, {1, 0, 1, 1, 0, 1, 1}, {1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 0, 1}, {1, 0, 0, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1}, {2, 0, 0, 2, 0, 0, 2}};

    public HexDisplaySmall() {
        this.name = "HexDisplaySmall";
        this.ports = new Port[4];
        this.ports[0] = new Port(this, "A3", 0, null);
        this.ports[1] = new Port(this, "A2", 0, null);
        this.ports[2] = new Port(this, "A1", 0, null);
        this.ports[3] = new Port(this, "A0", 0, null);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.dark_gray = new Color(100, 100, 100);
        this.medium_gray = new Color(120, 120, 120);
        this.segments = new ColoredPolyline[7];
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new ColoredPolyline();
            ++i;
        }
        this.segments[0].initialize("2 750 275 1350 275");
        this.segments[1].initialize("2 1350 350  1275  800");
        this.segments[2].initialize("2  1275 950  1200 1400");
        this.segments[3].initialize("2 600 1475  1200 1475");
        this.segments[4].initialize("2 675 950 600 1400");
        this.segments[5].initialize("2 750 350 675  800");
        this.segments[6].initialize("2 675  875  1275  875");
        int i2 = 0;
        while (i2 < this.segments.length) {
            FigAttribs attr = this.segments[i2].getAttributes();
            attr.currentLayer = 5;
            attr.fig_cap_style = 1;
            attr.fig_line_color = 2;
            attr.fig_fill_color = 2;
            attr.fillStyle = 1;
            attr.currentLayer = 5;
            attr.lineWidth = 75.0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segments.length) {
            this.display.fastAddMember(this.segments[i3]);
            ++i3;
        }
        Rectangle r = new Rectangle();
        r.initialize("400 150 1450 1650");
        FigAttribs ra = r.getAttributes();
        ra.fillStyle = 2;
        ra.fillColor = this.dark_gray;
        ra.fig_fill_color = 0;
        ra.fig_area_fill = 20;
        ra.currentLayer = 50;
        r.setAttributes(ra);
        this.display.fastAddMember(r);
        this.display.update_bbox();
        Symbol symbol = this.getSymbol();
        this.display.setObjectPainter(symbol.painter);
        symbol.addMember(this.display);
    }

    private void show() {
        if (this.symbol == null) {
            return;
        }
        this.index = 0;
        int i = 0;
        while (i < this.ports.length) {
            this.index <<= 1;
            Signal signal = this.ports[i].getSignal();
            if (signal != null) {
                StdLogic1164 tmp = (StdLogic1164)((SignalStdLogic1164)signal).getValue();
                if (tmp.intValue() == 3) {
                    ++this.index;
                } else if (tmp.intValue() == 7) {
                    ++this.index;
                } else if (tmp.intValue() != 2 && tmp.intValue() != 6) {
                    this.index = 16;
                    break;
                }
            } else {
                this.index = 16;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.segments.length) {
            int cindex = CMATRIX[this.index][i2];
            Color color = cindex == 0 ? this.medium_gray : (cindex == 1 ? Color.red : Color.cyan);
            FigAttribs attr = this.segments[i2].getAttributes();
            attr.lineColor = color;
            attr.fillColor = color;
            if (cindex == 0) {
                attr.fig_line_color = 0;
                attr.fig_fill_color = 0;
                attr.fig_area_fill = 10;
            } else if (cindex == 1) {
                attr.fig_line_color = 4;
                attr.fig_fill_color = 4;
                attr.fig_area_fill = 20;
            } else {
                attr.fig_line_color = 3;
                attr.fig_fill_color = 3;
                attr.fig_area_fill = 20;
            }
            this.segments[i2].setAttributes(attr);
            ++i2;
        }
        if (this.getSymbol().painter != null) {
            this.getSymbol().painter.paint(this.display, 100);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        if (this.visible) {
            this.show();
        }
    }

    public void evaluate(Object arg) {
        this.show();
    }

    public String toString() {
        return "HexDisplay: " + this.getFullName() + " [value=" + this.index + "]";
    }
}

